/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UncheckedParseException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.common.utility.Mnemonics;
import com.swirlds.config.api.Configuration;
import com.swirlds.merkledb.MerkleDbDataSourceBuilder;
import com.swirlds.merkledb.config.MerkleDbConfig;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.MerkleProof;
import com.swirlds.state.QueueState;
import com.swirlds.state.SiblingHash;
import com.swirlds.state.StateChangeListener;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.merkle.StateItem;
import com.swirlds.state.merkle.StateKeyUtils;
import com.swirlds.state.merkle.StateUtils;
import com.swirlds.state.merkle.StateValue;
import com.swirlds.state.merkle.disk.OnDiskQueueHelper;
import com.swirlds.state.merkle.disk.OnDiskReadableKVState;
import com.swirlds.state.merkle.disk.OnDiskReadableQueueState;
import com.swirlds.state.merkle.disk.OnDiskReadableSingletonState;
import com.swirlds.state.merkle.disk.OnDiskWritableKVState;
import com.swirlds.state.merkle.disk.OnDiskWritableQueueState;
import com.swirlds.state.merkle.disk.OnDiskWritableSingletonState;
import com.swirlds.state.spi.CommittableWritableStates;
import com.swirlds.state.spi.EmptyReadableStates;
import com.swirlds.state.spi.KVChangeListener;
import com.swirlds.state.spi.QueueChangeListener;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableQueueState;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableKVStateBase;
import com.swirlds.state.spi.WritableQueueState;
import com.swirlds.state.spi.WritableQueueStateBase;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableSingletonStateBase;
import com.swirlds.state.spi.WritableStates;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.datasource.VirtualDataSourceBuilder;
import com.swirlds.virtualmap.datasource.VirtualLeafBytes;
import com.swirlds.virtualmap.internal.Path;
import com.swirlds.virtualmap.internal.RecordAccessor;
import com.swirlds.virtualmap.internal.merkle.VirtualMapMetadata;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.Hash;
import org.json.JSONObject;

public class VirtualMapState
implements MerkleNodeState {
    private static final Logger logger = LogManager.getLogger(VirtualMapState.class);
    protected final Map<String, Map<Integer, StateMetadata<?, ?>>> services = new HashMap();
    private final Map<String, ReadableStates> readableStatesMap = new ConcurrentHashMap<String, ReadableStates>();
    private final Map<String, MerkleWritableStates> writableStatesMap = new HashMap<String, MerkleWritableStates>();
    private final List<StateChangeListener> listeners = new ArrayList<StateChangeListener>();
    private final Metrics metrics;
    protected VirtualMap virtualMap;
    private boolean startupMode = true;

    public VirtualMapState(@NonNull Configuration configuration, @NonNull Metrics metrics) {
        Objects.requireNonNull(configuration);
        this.metrics = Objects.requireNonNull(metrics);
        MerkleDbConfig merkleDbConfig = (MerkleDbConfig)configuration.getConfigData(MerkleDbConfig.class);
        MerkleDbDataSourceBuilder dsBuilder = new MerkleDbDataSourceBuilder(configuration, merkleDbConfig.initialCapacity(), merkleDbConfig.hashesRamToDiskThreshold());
        this.virtualMap = new VirtualMap((VirtualDataSourceBuilder)dsBuilder, configuration);
        this.virtualMap.registerMetrics(metrics);
    }

    public VirtualMapState(@NonNull VirtualMap virtualMap, @NonNull Metrics metrics) {
        this.virtualMap = Objects.requireNonNull(virtualMap);
        this.metrics = Objects.requireNonNull(metrics);
        this.virtualMap.registerMetrics(metrics);
    }

    protected VirtualMapState(@NonNull VirtualMapState from) {
        this.virtualMap = from.virtualMap.copy();
        this.metrics = from.metrics;
        this.startupMode = from.startupMode;
        this.listeners.addAll(from.listeners);
        for (Map.Entry<String, Map<Integer, StateMetadata<?, ?>>> entry : from.services.entrySet()) {
            this.services.put(entry.getKey(), new HashMap(entry.getValue()));
        }
    }

    @NonNull
    public ReadableStates getReadableStates(@NonNull String serviceName) {
        return this.readableStatesMap.computeIfAbsent(serviceName, s -> {
            Map<Integer, StateMetadata<?, ?>> stateMetadata = this.services.get(s);
            return stateMetadata == null ? EmptyReadableStates.INSTANCE : new MerkleReadableStates(stateMetadata);
        });
    }

    @NonNull
    public WritableStates getWritableStates(@NonNull String serviceName) {
        this.virtualMap.throwIfImmutable();
        return this.writableStatesMap.computeIfAbsent(serviceName, s -> {
            Map<Integer, StateMetadata<?, ?>> stateMetadata = this.services.getOrDefault(s, Map.of());
            return new MerkleWritableStates(serviceName, stateMetadata);
        });
    }

    public void registerCommitListener(@NonNull StateChangeListener listener) {
        Objects.requireNonNull(listener);
        this.listeners.add(listener);
    }

    public void unregisterCommitListener(@NonNull StateChangeListener listener) {
        Objects.requireNonNull(listener);
        this.listeners.remove(listener);
    }

    @NonNull
    public VirtualMapState copy() {
        return new VirtualMapState(this);
    }

    public void computeHash() {
        this.virtualMap.throwIfMutable("Hashing should only be done on immutable states");
        this.virtualMap.throwIfDestroyed("Hashing should not be done on destroyed states");
        this.virtualMap.getHash();
    }

    public void initializeState(@NonNull StateMetadata<?, ?> md) {
        this.virtualMap.throwIfImmutable();
        Objects.requireNonNull(md);
        StateDefinition def = md.stateDefinition();
        String serviceName = md.serviceName();
        Map stateMetadata = this.services.computeIfAbsent(serviceName, k -> new HashMap());
        stateMetadata.put(def.stateId(), md);
        this.readableStatesMap.put(serviceName, new MerkleReadableStates(stateMetadata));
        this.writableStatesMap.put(serviceName, new MerkleWritableStates(serviceName, stateMetadata));
    }

    public void removeServiceState(@NonNull String serviceName, int stateId) {
        MerkleWritableStates writableStates;
        this.virtualMap.throwIfImmutable();
        Objects.requireNonNull(serviceName);
        Map<Integer, StateMetadata<?, ?>> stateMetadata = this.services.get(serviceName);
        if (stateMetadata != null) {
            stateMetadata.remove(stateId);
        }
        if ((writableStates = this.writableStatesMap.get(serviceName)) != null) {
            writableStates.remove(stateId);
        }
    }

    public Map<String, Map<Integer, StateMetadata<?, ?>>> getServices() {
        return this.services;
    }

    public boolean isStartUpMode() {
        return this.startupMode;
    }

    public void disableStartupMode() {
        this.startupMode = false;
    }

    public VirtualMap getRoot() {
        return this.virtualMap;
    }

    @NonNull
    public Hash getHash() {
        return this.virtualMap.getHash();
    }

    public void setHash(Hash hash) {
        throw new UnsupportedOperationException("VirtualMap is self hashing");
    }

    public boolean isMutable() {
        return this.virtualMap.isMutable();
    }

    public boolean isImmutable() {
        return this.virtualMap.isImmutable();
    }

    public boolean isDestroyed() {
        return this.virtualMap.isDestroyed();
    }

    public boolean release() {
        return this.virtualMap.release();
    }

    public void close() {
        logger.info("Closing VirtualMapState");
        try {
            this.virtualMap.getDataSource().close();
        }
        catch (IOException e) {
            logger.warn("Unable to close data source for the Virtual Map", (Throwable)e);
        }
    }

    public void commitSingletons() {
        this.services.forEach((serviceKey, serviceStates) -> serviceStates.entrySet().stream().filter(stateMetadata -> ((StateMetadata)stateMetadata.getValue()).stateDefinition().singleton()).forEach(service -> {
            WritableStates writableStates = this.getWritableStates((String)serviceKey);
            WritableSingletonStateBase writableSingleton = (WritableSingletonStateBase)writableStates.getSingleton(((Integer)service.getKey()).intValue());
            writableSingleton.commit();
        }));
    }

    public long getSingletonPath(int stateId) {
        return this.virtualMap.getRecords().findPath(StateUtils.getStateKeyForSingleton(stateId));
    }

    public long getQueueElementPath(int stateId, @NonNull Bytes expectedValue) {
        StateValue queueStateValue = (StateValue)this.virtualMap.get(StateKeyUtils.queueStateKey(stateId), OnDiskQueueHelper.QUEUE_STATE_VALUE_CODEC);
        if (queueStateValue == null) {
            return -1L;
        }
        QueueState queueState = (QueueState)queueStateValue.value();
        for (long i = queueState.head(); i < queueState.tail(); ++i) {
            Bytes actualValue;
            Bytes stateKey = StateUtils.getStateKeyForQueue(stateId, i);
            VirtualLeafBytes leafRecord = this.virtualMap.getRecords().findLeafRecord(stateKey);
            if (leafRecord == null || !(actualValue = StateUtils.unwrap(leafRecord.valueBytes())).equals((Object)expectedValue)) continue;
            return leafRecord.path();
        }
        return -1L;
    }

    public long getKvPath(int stateId, @NonNull Bytes key) {
        return this.virtualMap.getRecords().findPath(StateKeyUtils.kvKey(stateId, key));
    }

    public Hash getHashForPath(long path) {
        return this.virtualMap.getRecords().findHash(path);
    }

    public MerkleProof getMerkleProof(long path) {
        if (!this.isHashed()) {
            throw new IllegalStateException("Cannot get Merkle proof for unhashed virtual map");
        }
        VirtualLeafBytes leafRecord = this.virtualMap.getRecords().findLeafRecord(path);
        if (leafRecord == null) {
            return null;
        }
        ArrayList<SiblingHash> siblingHashes = new ArrayList<SiblingHash>();
        ArrayList<Hash> innerParentHashes = new ArrayList<Hash>();
        long currentPath = path;
        while (currentPath > 0L) {
            long siblingPath = Path.getSiblingPath((long)currentPath);
            boolean isSiblingRight = Path.isRight((long)siblingPath);
            Hash hashForPath = this.getHashForPath(siblingPath);
            Hash normalizedHashForPath = hashForPath == null ? Cryptography.NULL_HASH : hashForPath;
            siblingHashes.add(new SiblingHash(isSiblingRight, normalizedHashForPath));
            innerParentHashes.add(this.getHashForPath(currentPath));
            currentPath = Path.getParentPath((long)currentPath);
        }
        assert (this.virtualMap.getHash() != null);
        innerParentHashes.add(this.virtualMap.getHash());
        StateItem stateItem = new StateItem(leafRecord.keyBytes(), leafRecord.valueBytes());
        return new MerkleProof(StateItem.CODEC.toBytes((Object)stateItem), siblingHashes, innerParentHashes);
    }

    public boolean isHashed() {
        return this.virtualMap.isHashed();
    }

    public String getInfoJson() {
        JSONObject rootJson = new JSONObject();
        RecordAccessor recordAccessor = this.virtualMap.getRecords();
        VirtualMapMetadata virtualMapMetadata = this.virtualMap.getMetadata();
        JSONObject virtualMapMetadataJson = new JSONObject();
        virtualMapMetadataJson.put("firstLeafPath", virtualMapMetadata.getFirstLeafPath());
        virtualMapMetadataJson.put("lastLeafPath", virtualMapMetadata.getLastLeafPath());
        rootJson.put("VirtualMapMetadata", (Object)virtualMapMetadataJson);
        JSONObject singletons = new JSONObject();
        JSONObject queues = new JSONObject();
        this.services.forEach((key, value) -> value.forEach((s, stateMetadata) -> {
            Bytes queueStateKey;
            VirtualLeafBytes leafBytes;
            String serviceName = stateMetadata.serviceName();
            StateDefinition stateDefinition = stateMetadata.stateDefinition();
            int stateId = stateDefinition.stateId();
            String stateKey = stateDefinition.stateKey();
            if (stateDefinition.singleton()) {
                Bytes singletonKey = StateKeyUtils.singletonKey(stateId);
                VirtualLeafBytes leafBytes2 = recordAccessor.findLeafRecord(singletonKey);
                if (leafBytes2 != null) {
                    Hash hash = recordAccessor.findHash(leafBytes2.path());
                    JSONObject singletonJson = new JSONObject();
                    if (hash != null) {
                        singletonJson.put("mnemonic", (Object)Mnemonics.generateMnemonic((Hash)hash));
                    }
                    singletonJson.put("path", leafBytes2.path());
                    singletons.put(StateMetadata.computeLabel((String)serviceName, (String)stateKey), (Object)singletonJson);
                }
            } else if (stateDefinition.queue() && (leafBytes = recordAccessor.findLeafRecord(queueStateKey = StateKeyUtils.queueStateKey(stateId))) != null) {
                StateValue.StateValueCodec queueStateCodec = new StateValue.StateValueCodec(StateValue.extractStateIdFromStateValueOneOf(leafBytes.valueBytes()), new QueueState.QueueStateCodec());
                try {
                    QueueState queueState = (QueueState)((StateValue)queueStateCodec.parse(leafBytes.valueBytes())).value();
                    JSONObject queueJson = new JSONObject();
                    queueJson.put("head", queueState.head());
                    queueJson.put("tail", queueState.tail());
                    queueJson.put("path", leafBytes.path());
                    queues.put(StateMetadata.computeLabel((String)serviceName, (String)stateKey), (Object)queueJson);
                }
                catch (ParseException e) {
                    throw new UncheckedParseException(e);
                }
            }
        }));
        rootJson.put("Singletons", (Object)singletons);
        rootJson.put("Queues (Queue States)", (Object)queues);
        return rootJson.toString();
    }

    @Nullable
    public Bytes getKv(int stateId, @NonNull Bytes key) {
        Bytes stateKey = StateKeyUtils.kvKey(stateId, key);
        Bytes stored = this.virtualMap.getBytes(stateKey);
        return stored == null ? null : StateUtils.unwrap(stored);
    }

    public Bytes getSingleton(int singletonId) {
        try {
            Bytes stateKey = StateUtils.getStateKeyForSingleton(singletonId);
            Bytes stored = this.virtualMap.getBytes(stateKey);
            return stored == null ? null : StateUtils.unwrap(stored);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    public QueueState getQueueState(int stateID) {
        Bytes queueStateKey = StateKeyUtils.queueStateKey(stateID);
        Bytes queueStateBytes = this.virtualMap.getBytes(queueStateKey);
        if (queueStateBytes == null) {
            return null;
        }
        try {
            Bytes unwrapped = StateUtils.unwrap(queueStateBytes);
            return (QueueState)QueueState.QueueStateCodec.INSTANCE.parse(unwrapped);
        }
        catch (ParseException e) {
            throw new IllegalStateException("Failed to parse queue state for stateID: " + stateID, e);
        }
    }

    @Nullable
    public Bytes peekQueueHead(int stateId) {
        QueueState state = this.getQueueState(stateId);
        if (state == null || state.head() >= state.tail()) {
            return null;
        }
        Bytes elementKey = StateKeyUtils.queueKey(stateId, (int)state.head());
        Bytes stored = this.virtualMap.getBytes(elementKey);
        return stored == null ? null : StateUtils.unwrap(stored);
    }

    @Nullable
    public Bytes peekQueueTail(int stateId) {
        QueueState state = this.getQueueState(stateId);
        if (state == null || state.head() >= state.tail()) {
            return null;
        }
        Bytes elementKey = StateKeyUtils.queueKey(stateId, (int)(state.tail() - 1L));
        Bytes stored = this.virtualMap.getBytes(elementKey);
        return stored == null ? null : StateUtils.unwrap(stored);
    }

    @Nullable
    public Bytes peekQueue(int stateID, int index) {
        QueueState state = this.getQueueState(stateID);
        if (state == null) {
            return null;
        }
        if ((long)index < state.head() || (long)index >= state.tail()) {
            throw new IllegalArgumentException("Index " + index + " is out of bounds. Valid range is [" + state.head() + ", " + (state.tail() - 1L) + "]");
        }
        Bytes elementKey = StateKeyUtils.queueKey(stateID, index);
        Bytes stored = this.virtualMap.getBytes(elementKey);
        return stored == null ? null : StateUtils.unwrap(stored);
    }

    public List<Bytes> getQueueAsList(int stateID) {
        QueueState state = this.getQueueState(stateID);
        ArrayList<Bytes> result = new ArrayList<Bytes>();
        for (long i = state.head(); i < state.tail(); ++i) {
            Bytes element;
            Bytes elementKey = StateKeyUtils.queueKey(stateID, (int)i);
            Bytes stored = this.virtualMap.getBytes(elementKey);
            Bytes bytes = element = stored == null ? null : StateUtils.unwrap(stored);
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    public void updateSingleton(int stateId, @NonNull Bytes value) {
        Objects.requireNonNull(value, "value must not be null");
        Bytes key = StateKeyUtils.singletonKey(stateId);
        Bytes wrapped = StateUtils.wrapValue(stateId, value);
        this.virtualMap.putBytes(key, wrapped);
    }

    public void removeSingleton(int stateId) {
        this.virtualMap.remove(StateKeyUtils.singletonKey(stateId));
    }

    public void updateKv(int stateId, @NonNull Bytes key, @Nullable Bytes value) {
        Objects.requireNonNull(key, "key must not be null");
        Bytes stateKey = StateKeyUtils.kvKey(stateId, key);
        if (value == null) {
            this.virtualMap.remove(stateKey);
        } else {
            Bytes wrapped = StateUtils.wrapValue(stateId, value);
            this.virtualMap.putBytes(stateKey, wrapped);
        }
    }

    public void removeKv(int stateId, @NonNull Bytes key) {
        Objects.requireNonNull(key, "key must not be null");
        this.virtualMap.remove(StateKeyUtils.kvKey(stateId, key));
    }

    public void pushQueue(int stateId, @NonNull Bytes value) {
        QueueState qState;
        Objects.requireNonNull(value, "value must not be null");
        Bytes qStateKey = StateKeyUtils.queueStateKey(stateId);
        Bytes existing = this.virtualMap.getBytes(qStateKey);
        if (existing == null) {
            qState = new QueueState(1L, 1L);
        } else {
            try {
                Bytes unwrapped = StateUtils.unwrap(existing);
                qState = (QueueState)QueueState.QueueStateCodec.INSTANCE.parse(unwrapped);
            }
            catch (ParseException e) {
                throw new IllegalStateException("Failed to parse existing queue state", e);
            }
        }
        Bytes elementKey = StateKeyUtils.queueKey(stateId, (int)qState.tail());
        Bytes wrappedElement = StateUtils.wrapValue(stateId, value);
        this.virtualMap.putBytes(elementKey, wrappedElement);
        QueueState updated = qState.elementAdded();
        Bytes rawState = QueueState.QueueStateCodec.INSTANCE.toBytes((Object)updated);
        Bytes wrappedState = StateUtils.wrapValue(stateId, rawState);
        this.virtualMap.putBytes(qStateKey, wrappedState);
    }

    public Bytes popQueue(int stateId) {
        Bytes qStateKey = StateKeyUtils.queueStateKey(stateId);
        QueueState qState = this.getQueueState(stateId);
        if (qState == null) {
            return null;
        }
        if (qState.head() == qState.tail()) {
            return null;
        }
        Bytes elementKey = StateKeyUtils.queueKey(stateId, (int)qState.head());
        Bytes stored = this.virtualMap.getBytes(elementKey);
        Bytes value = stored == null ? null : StateUtils.unwrap(stored);
        this.virtualMap.remove(elementKey);
        QueueState updated = qState.elementRemoved();
        Bytes rawState = QueueState.QueueStateCodec.INSTANCE.toBytes((Object)updated);
        Bytes wrappedState = StateUtils.wrapValue(stateId, rawState);
        this.virtualMap.putBytes(qStateKey, wrappedState);
        return value;
    }

    public void removeQueue(int stateId) {
        Bytes qStateKey = StateKeyUtils.queueStateKey(stateId);
        QueueState qState = this.getQueueState(stateId);
        if (qState == null) {
            return;
        }
        long tail = qState.tail();
        while (qState.head() < tail) {
            this.virtualMap.remove(StateKeyUtils.queueKey(stateId, (int)qState.head()));
            qState = qState.elementRemoved();
        }
        this.virtualMap.remove(qStateKey);
    }

    public final class MerkleReadableStates
    extends MerkleStates {
        MerkleReadableStates(Map<Integer, StateMetadata<?, ?>> stateMetadata) {
            super(stateMetadata);
        }

        @NonNull
        protected ReadableKVState<?, ?> createReadableKVState(@NonNull StateMetadata md) {
            return new OnDiskReadableKVState(MerkleReadableStates.extractStateId(md), StateMetadata.computeLabel((String)md.serviceName(), (String)MerkleReadableStates.extractStateKey(md)), MerkleReadableStates.extractKeyCodec(md), MerkleReadableStates.extractValueCodec(md), VirtualMapState.this.virtualMap);
        }

        @NonNull
        protected ReadableSingletonState<?> createReadableSingletonState(@NonNull StateMetadata md) {
            return new OnDiskReadableSingletonState(MerkleReadableStates.extractStateId(md), StateMetadata.computeLabel((String)md.serviceName(), (String)MerkleReadableStates.extractStateKey(md)), MerkleReadableStates.extractValueCodec(md), VirtualMapState.this.virtualMap);
        }

        @Override
        @NonNull
        protected ReadableQueueState createReadableQueueState(@NonNull StateMetadata md) {
            return new OnDiskReadableQueueState(MerkleReadableStates.extractStateId(md), StateMetadata.computeLabel((String)md.serviceName(), (String)MerkleReadableStates.extractStateKey(md)), MerkleReadableStates.extractValueCodec(md), VirtualMapState.this.virtualMap);
        }
    }

    public final class MerkleWritableStates
    extends MerkleStates
    implements WritableStates,
    CommittableWritableStates {
        private final String serviceName;

        MerkleWritableStates(@NonNull String serviceName, Map<Integer, StateMetadata<?, ?>> stateMetadata) {
            super(stateMetadata);
            this.serviceName = Objects.requireNonNull(serviceName);
        }

        public void copyAndReleaseVirtualMap(int stateId) {
            StateMetadata md = (StateMetadata)this.stateMetadata.get(stateId);
            VirtualMap mutableCopy = VirtualMapState.this.virtualMap.copy();
            mutableCopy.registerMetrics(VirtualMapState.this.metrics);
            VirtualMapState.this.virtualMap.release();
            VirtualMapState.this.virtualMap = mutableCopy;
            this.kvInstances.put(stateId, this.createReadableKVState(md));
        }

        @NonNull
        public <K, V> WritableKVState<K, V> get(int stateId) {
            return (WritableKVState)super.get(stateId);
        }

        @NonNull
        public <V> WritableSingletonState<V> getSingleton(int stateId) {
            return (WritableSingletonState)super.getSingleton(stateId);
        }

        @NonNull
        public <E> WritableQueueState<E> getQueue(int stateId) {
            return (WritableQueueState)super.getQueue(stateId);
        }

        @NonNull
        protected WritableKVState<?, ?> createReadableKVState(@NonNull StateMetadata md) {
            OnDiskWritableKVState state = new OnDiskWritableKVState(MerkleWritableStates.extractStateId(md), StateMetadata.computeLabel((String)md.serviceName(), (String)MerkleWritableStates.extractStateKey(md)), MerkleWritableStates.extractKeyCodec(md), MerkleWritableStates.extractValueCodec(md), VirtualMapState.this.virtualMap);
            VirtualMapState.this.listeners.forEach(listener -> {
                if (listener.stateTypes().contains(StateChangeListener.StateType.MAP)) {
                    this.registerKVListener(state, (StateChangeListener)listener);
                }
            });
            return state;
        }

        @NonNull
        protected WritableSingletonState<?> createReadableSingletonState(@NonNull StateMetadata md) {
            OnDiskWritableSingletonState state = new OnDiskWritableSingletonState(MerkleWritableStates.extractStateId(md), StateMetadata.computeLabel((String)md.serviceName(), (String)MerkleWritableStates.extractStateKey(md)), MerkleWritableStates.extractValueCodec(md), VirtualMapState.this.virtualMap);
            VirtualMapState.this.listeners.forEach(listener -> {
                if (listener.stateTypes().contains(StateChangeListener.StateType.SINGLETON)) {
                    this.registerSingletonListener(state, (StateChangeListener)listener);
                }
            });
            return state;
        }

        @NonNull
        protected WritableQueueState<?> createReadableQueueState(@NonNull StateMetadata md) {
            OnDiskWritableQueueState state = new OnDiskWritableQueueState(MerkleWritableStates.extractStateId(md), StateMetadata.computeLabel((String)md.serviceName(), (String)MerkleWritableStates.extractStateKey(md)), MerkleWritableStates.extractValueCodec(md), VirtualMapState.this.virtualMap);
            VirtualMapState.this.listeners.forEach(listener -> {
                if (listener.stateTypes().contains(StateChangeListener.StateType.QUEUE)) {
                    this.registerQueueListener(state, (StateChangeListener)listener);
                }
            });
            return state;
        }

        public void commit() {
            this.kvInstances.keySet().stream().sorted().forEach(stateId -> ((WritableKVStateBase)this.kvInstances.get(stateId)).commit());
            if (VirtualMapState.this.startupMode) {
                this.singletonInstances.keySet().stream().sorted().forEach(stateId -> ((WritableSingletonStateBase)this.singletonInstances.get(stateId)).commit());
            }
            this.queueInstances.keySet().stream().sorted().forEach(stateId -> ((WritableQueueStateBase)this.queueInstances.get(stateId)).commit());
            VirtualMapState.this.readableStatesMap.remove(this.serviceName);
        }

        public void remove(int stateId) {
            if (!Map.of().equals(this.stateMetadata)) {
                this.stateMetadata.remove(stateId);
            }
            this.kvInstances.remove(stateId);
            this.singletonInstances.remove(stateId);
            this.queueInstances.remove(stateId);
        }

        private <V> void registerSingletonListener(@NonNull WritableSingletonStateBase<V> singletonState, @NonNull StateChangeListener listener) {
            int stateId = singletonState.getStateId();
            singletonState.registerListener(value -> listener.singletonUpdateChange(stateId, value));
        }

        private <V> void registerQueueListener(@NonNull WritableQueueStateBase<V> queueState, final @NonNull StateChangeListener listener) {
            final int stateId = queueState.getStateId();
            queueState.registerListener(new QueueChangeListener<V>(this){

                public void queuePushChange(@NonNull V value) {
                    listener.queuePushChange(stateId, value);
                }

                public void queuePopChange() {
                    listener.queuePopChange(stateId);
                }
            });
        }

        private <K, V> void registerKVListener(WritableKVStateBase<K, V> state, final StateChangeListener listener) {
            final int stateId = state.getStateId();
            state.registerListener(new KVChangeListener<K, V>(this){

                public void mapUpdateChange(@NonNull K key, @NonNull V value) {
                    listener.mapUpdateChange(stateId, key, value);
                }

                public void mapDeleteChange(@NonNull K key) {
                    listener.mapDeleteChange(stateId, key);
                }
            });
        }
    }

    private static abstract class MerkleStates
    implements ReadableStates {
        protected final Map<Integer, StateMetadata<?, ?>> stateMetadata;
        protected final Map<Integer, ReadableKVState<?, ?>> kvInstances;
        protected final Map<Integer, ReadableSingletonState<?>> singletonInstances;
        protected final Map<Integer, ReadableQueueState<?>> queueInstances;
        private final Set<Integer> stateIds;

        MerkleStates(@NonNull Map<Integer, StateMetadata<?, ?>> stateMetadata) {
            this.stateMetadata = Objects.requireNonNull(stateMetadata);
            this.stateIds = Collections.unmodifiableSet(stateMetadata.keySet());
            this.kvInstances = new HashMap();
            this.singletonInstances = new HashMap();
            this.queueInstances = new HashMap();
        }

        @NonNull
        public <K, V> ReadableKVState<K, V> get(int stateId) {
            ReadableKVState<?, ?> instance = this.kvInstances.get(stateId);
            if (instance != null) {
                return instance;
            }
            StateMetadata<?, ?> md = this.stateMetadata.get(stateId);
            if (md == null || !md.stateDefinition().onDisk()) {
                throw new IllegalArgumentException("Unknown k/v state ID '" + stateId + ";");
            }
            ReadableKVState ret = this.createReadableKVState(md);
            this.kvInstances.put(stateId, ret);
            return ret;
        }

        @NonNull
        public <V> ReadableSingletonState<V> getSingleton(int stateId) {
            ReadableSingletonState<?> instance = this.singletonInstances.get(stateId);
            if (instance != null) {
                return instance;
            }
            StateMetadata<?, ?> md = this.stateMetadata.get(stateId);
            if (md == null || !md.stateDefinition().singleton()) {
                throw new IllegalArgumentException("Unknown singleton state ID '" + stateId + "'");
            }
            ReadableSingletonState ret = this.createReadableSingletonState(md);
            this.singletonInstances.put(stateId, ret);
            return ret;
        }

        @NonNull
        public <E> ReadableQueueState<E> getQueue(int stateId) {
            ReadableQueueState<?> instance = this.queueInstances.get(stateId);
            if (instance != null) {
                return instance;
            }
            StateMetadata<?, ?> md = this.stateMetadata.get(stateId);
            if (md == null || !md.stateDefinition().queue()) {
                throw new IllegalArgumentException("Unknown queue state ID '" + stateId + "'");
            }
            ReadableQueueState ret = this.createReadableQueueState(md);
            this.queueInstances.put(stateId, ret);
            return ret;
        }

        public boolean contains(int stateId) {
            return this.stateMetadata.containsKey(stateId);
        }

        @NonNull
        public Set<Integer> stateIds() {
            return this.stateIds;
        }

        @NonNull
        protected abstract ReadableKVState createReadableKVState(@NonNull StateMetadata var1);

        @NonNull
        protected abstract ReadableSingletonState createReadableSingletonState(@NonNull StateMetadata var1);

        @NonNull
        protected abstract ReadableQueueState createReadableQueueState(@NonNull StateMetadata var1);

        static int extractStateId(@NonNull StateMetadata<?, ?> md) {
            return md.stateDefinition().stateId();
        }

        @NonNull
        static String extractStateKey(@NonNull StateMetadata<?, ?> md) {
            return md.stateDefinition().stateKey();
        }

        @NonNull
        static <K> Codec<K> extractKeyCodec(@NonNull StateMetadata<K, ?> md) {
            return Objects.requireNonNull(md.stateDefinition().keyCodec(), "Key codec is null");
        }

        @NonNull
        static <V> Codec<V> extractValueCodec(@NonNull StateMetadata<?, V> md) {
            return md.stateDefinition().valueCodec();
        }
    }
}

