/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb;

import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.common.io.utility.LegacyTemporaryFileBuilder;
import com.swirlds.config.api.Configuration;
import com.swirlds.merkledb.MerkleDbDataSource;
import com.swirlds.virtualmap.datasource.VirtualDataSource;
import com.swirlds.virtualmap.datasource.VirtualDataSourceBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;

public class MerkleDbDataSourceBuilder
implements VirtualDataSourceBuilder {
    private final Configuration configuration;
    private long initialCapacity = 0L;
    private long hashesRamToDiskThreshold = 0L;

    public MerkleDbDataSourceBuilder(@NonNull Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration);
    }

    public MerkleDbDataSourceBuilder(@NonNull Configuration configuration, long initialCapacity, long hashesRamToDiskThreshold) {
        this.configuration = Objects.requireNonNull(configuration);
        this.initialCapacity = initialCapacity;
        this.hashesRamToDiskThreshold = hashesRamToDiskThreshold;
    }

    private Path newDataSourceDir(String label) {
        try {
            return LegacyTemporaryFileBuilder.buildTemporaryFile((String)("merkledb-" + label), (Configuration)this.configuration);
        }
        catch (IOException z) {
            throw new UncheckedIOException("Failed to create a new temp MerkleDb folder", z);
        }
    }

    private Path snapshotDataDir(Path snapshotDir, String label) {
        return snapshotDir.resolve("data").resolve(label);
    }

    @NonNull
    public VirtualDataSource build(String label, @Nullable Path sourceDir, boolean compactionEnabled, boolean offlineUse) {
        if (sourceDir == null) {
            return this.buildNewDataSource(label, compactionEnabled, offlineUse);
        }
        return this.restoreDataSource(label, sourceDir, compactionEnabled, offlineUse);
    }

    @NonNull
    private VirtualDataSource buildNewDataSource(String label, boolean compactionEnabled, boolean offlineUse) {
        if (this.initialCapacity <= 0L) {
            throw new IllegalArgumentException("Initial map capacity not set");
        }
        try {
            Path dataSourceDir = this.newDataSourceDir(label);
            return new MerkleDbDataSource(dataSourceDir, this.configuration, label, this.initialCapacity, this.hashesRamToDiskThreshold, compactionEnabled, offlineUse);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private void snapshotDataSource(MerkleDbDataSource dataSource, Path dir) {
        try {
            try {
                dataSource.pauseCompaction();
                dataSource.snapshot(dir);
            }
            finally {
                dataSource.resumeCompaction();
            }
        }
        catch (IOException z) {
            throw new UncheckedIOException(z);
        }
    }

    @NonNull
    public Path snapshot(@Nullable Path snapshotDir, @NonNull VirtualDataSource dataSource) {
        if (!(dataSource instanceof MerkleDbDataSource)) {
            throw new IllegalArgumentException("The data source must be compatible with the MerkleDb");
        }
        MerkleDbDataSource merkleDbDataSource = (MerkleDbDataSource)dataSource;
        String label = merkleDbDataSource.getTableName();
        if (snapshotDir == null) {
            snapshotDir = this.newDataSourceDir(label);
        }
        Path snapshotDataSourceDir = this.snapshotDataDir(snapshotDir, label);
        this.snapshotDataSource(merkleDbDataSource, snapshotDataSourceDir);
        return snapshotDir;
    }

    @NonNull
    private VirtualDataSource restoreDataSource(String label, @NonNull Path snapshotDir, boolean compactionEnabled, boolean offlineUse) {
        try {
            Path dataSourceDir = this.newDataSourceDir(label);
            Path snapshotDataSourceDir = this.snapshotDataDir(snapshotDir, label);
            if (Files.isDirectory(snapshotDataSourceDir, new LinkOption[0])) {
                FileUtils.hardLinkTree((Path)snapshotDataSourceDir, (Path)dataSourceDir);
                return new MerkleDbDataSource(dataSourceDir, this.configuration, label, compactionEnabled, offlineUse);
            }
            throw new IOException("Cannot restore MerkleDb data source: label=" + label + " snapshotDir=" + String.valueOf(snapshotDir));
        }
        catch (IOException z) {
            throw new UncheckedIOException(z);
        }
    }

    public int hashCode() {
        return Objects.hash(this.initialCapacity, this.hashesRamToDiskThreshold);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MerkleDbDataSourceBuilder)) {
            return false;
        }
        MerkleDbDataSourceBuilder that = (MerkleDbDataSourceBuilder)obj;
        return this.initialCapacity == that.initialCapacity && this.hashesRamToDiskThreshold == that.hashesRamToDiskThreshold;
    }
}

