/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.pcli;

import com.hedera.pbj.runtime.ParseException;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.config.DefaultConfiguration;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.signed.SignedStateComparison;
import com.swirlds.platform.state.snapshot.SignedStateFileReader;
import com.swirlds.platform.util.BootstrapUtils;
import com.swirlds.state.StateLifecycleManager;
import com.swirlds.state.merkle.StateLifecycleManagerImpl;
import com.swirlds.state.merkle.VirtualMapState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.pcli.AbstractCommand;
import org.hiero.consensus.pcli.StateCommand;
import org.hiero.consensus.pcli.SubcommandOf;
import picocli.CommandLine;

@CommandLine.Command(name="compare", mixinStandardHelpOptions=true, description={"Compare two signed states for differences. Useful for debugging ISS incidents."})
@SubcommandOf(value=StateCommand.class)
public final class CompareStatesCommand
extends AbstractCommand {
    private static final Logger logger = LogManager.getLogger(CompareStatesCommand.class);
    private Path stateAPath;
    private Path stateBPath;
    private int nodeLimit = 100;
    private boolean deepComparison = false;
    private List<Path> configurationPaths = List.of();

    private CompareStatesCommand() {
    }

    @CommandLine.Option(names={"-c", "--config"}, description={"A path to where a configuration file can be found. If not provided then defaults are used."})
    private void setConfigurationPath(List<Path> configurationPaths) {
        configurationPaths.forEach(x$0 -> this.pathMustExist((Path)x$0));
        this.configurationPaths = configurationPaths;
    }

    @CommandLine.Parameters(description={"the path to the first state dir that is being compared"})
    private void setStateAPath(Path stateAPath) {
        this.stateAPath = this.pathMustExist(stateAPath.toAbsolutePath());
    }

    @CommandLine.Parameters(description={"the path to the second state dir that is being compared"})
    private void setStateBPath(Path stateBPath) {
        this.stateBPath = this.pathMustExist(stateBPath.toAbsolutePath());
    }

    @CommandLine.Option(names={"--limit"}, description={"the maximum number of mismatched merkle nodes to print"})
    private void setNodeLimit(int nodeLimit) {
        if (nodeLimit <= 0) {
            throw new CommandLine.ParameterException(this.getSpec().commandLine(), "node limit must be non-zero positive");
        }
        this.nodeLimit = nodeLimit;
    }

    @CommandLine.Option(names={"--deep"}, description={"if set then do a deep comparison of the states, useful if internal hashes have been corrupted"})
    private void setDeepComparison(boolean deepComparison) {
        this.deepComparison = deepComparison;
    }

    private static ReservedSignedState loadAndHashState(@NonNull PlatformContext platformContext, @NonNull Path stateDirPath) throws IOException, ParseException {
        Objects.requireNonNull(platformContext);
        Objects.requireNonNull(stateDirPath);
        logger.info(LogMarker.CLI.getMarker(), "Loading state from {}", (Object)stateDirPath);
        StateLifecycleManagerImpl stateLifecycleManager = new StateLifecycleManagerImpl(platformContext.getMetrics(), platformContext.getTime(), virtualMap -> new VirtualMapState(virtualMap, platformContext.getMetrics()), platformContext.getConfiguration());
        ReservedSignedState signedState = SignedStateFileReader.readState((Path)stateDirPath, (PlatformContext)platformContext, (StateLifecycleManager)stateLifecycleManager).reservedSignedState();
        logger.info(LogMarker.CLI.getMarker(), "Hashing state");
        signedState.get().getState().getHash();
        return signedState;
    }

    @Override
    public Integer call() throws IOException, ParseException {
        BootstrapUtils.setupConstructableRegistry();
        Configuration configuration = DefaultConfiguration.buildBasicConfiguration((ConfigurationBuilder)ConfigurationBuilder.create(), (Path)FileUtils.getAbsolutePath((String)"settings.txt"));
        PlatformContext platformContext = PlatformContext.create((Configuration)configuration);
        try (ReservedSignedState stateA = CompareStatesCommand.loadAndHashState(platformContext, this.stateAPath);
             ReservedSignedState stateB = CompareStatesCommand.loadAndHashState(platformContext, this.stateBPath);){
            SignedStateComparison.printMismatchedNodes((Iterator)SignedStateComparison.mismatchedNodeIterator((MerkleNode)stateA.get().getState().getRoot(), (MerkleNode)stateB.get().getState().getRoot(), (boolean)this.deepComparison), (int)this.nodeLimit);
        }
        return 0;
    }
}

