/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.spi.validation;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public final class Validations {
    private Validations() {
    }

    public static <T> T mustExist(@Nullable T subject, @NonNull ResponseCodeEnum code) throws PreCheckException {
        if (subject == null) {
            throw new PreCheckException(code);
        }
        return subject;
    }

    @NonNull
    public static AccountID validateAccountID(@Nullable AccountID subject, @Nullable ResponseCodeEnum responseCodeEnum) throws PreCheckException {
        AccountID result = null;
        try {
            result = Validations.validateNullableAccountID(subject);
            if (result == null) {
                throw new PreCheckException(responseCodeEnum == null ? ResponseCodeEnum.INVALID_ACCOUNT_ID : responseCodeEnum);
            }
        }
        catch (PreCheckException e) {
            if (responseCodeEnum != null) {
                throw new PreCheckException(responseCodeEnum);
            }
            throw e;
        }
        return result;
    }

    @Nullable
    public static AccountID validateNullableAccountID(@Nullable AccountID subject) throws PreCheckException {
        Bytes alias;
        if (subject == null) {
            return null;
        }
        if (subject.account().kind() == AccountID.AccountOneOfType.UNSET) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_ACCOUNT_ID);
        }
        if (subject.hasAccountNum() && subject.accountNumOrThrow() <= 0L) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_ACCOUNT_ID);
        }
        if (subject.hasAlias() && (alias = subject.aliasOrThrow()).length() < 1L) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_ACCOUNT_ID);
        }
        return subject;
    }
}

