/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle.dispatch;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SignatureMap;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.scheduled.SchedulableTransactionBody;
import com.hedera.hapi.node.transaction.SignedTransaction;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.hapi.util.UnknownHederaFunctionality;
import com.hedera.node.app.fees.AppFeeCharging;
import com.hedera.node.app.fees.ExchangeRateManager;
import com.hedera.node.app.fees.FeeAccumulator;
import com.hedera.node.app.fees.FeeManager;
import com.hedera.node.app.fees.ResourcePriceCalculatorImpl;
import com.hedera.node.app.hapi.utils.keys.KeyComparator;
import com.hedera.node.app.service.entityid.EntityNumGenerator;
import com.hedera.node.app.service.entityid.WritableEntityCounters;
import com.hedera.node.app.service.entityid.WritableEntityIdStore;
import com.hedera.node.app.service.entityid.impl.EntityNumGeneratorImpl;
import com.hedera.node.app.service.entityid.impl.WritableEntityIdStoreImpl;
import com.hedera.node.app.service.schedule.impl.handlers.HandlerUtility;
import com.hedera.node.app.service.token.api.FeeStreamBuilder;
import com.hedera.node.app.service.token.api.TokenServiceApi;
import com.hedera.node.app.services.ServiceScopeLookup;
import com.hedera.node.app.signature.AppKeyVerifier;
import com.hedera.node.app.signature.DefaultKeyVerifier;
import com.hedera.node.app.signature.impl.SignatureVerificationImpl;
import com.hedera.node.app.spi.api.ServiceApiProvider;
import com.hedera.node.app.spi.authorization.Authorizer;
import com.hedera.node.app.spi.fees.FeeCharging;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.fees.NodeFeeAccumulator;
import com.hedera.node.app.spi.info.NetworkInfo;
import com.hedera.node.app.spi.info.NodeInfo;
import com.hedera.node.app.spi.records.BlockRecordInfo;
import com.hedera.node.app.spi.signatures.SignatureVerification;
import com.hedera.node.app.spi.signatures.VerificationAssistant;
import com.hedera.node.app.spi.throttle.ThrottleAdviser;
import com.hedera.node.app.spi.workflows.ComputeDispatchFeesAsTopLevel;
import com.hedera.node.app.spi.workflows.DispatchOptions;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.node.app.store.ReadableStoreFactory;
import com.hedera.node.app.store.ServiceApiFactory;
import com.hedera.node.app.store.StoreFactoryImpl;
import com.hedera.node.app.store.WritableStoreFactory;
import com.hedera.node.app.workflows.TransactionChecker;
import com.hedera.node.app.workflows.TransactionInfo;
import com.hedera.node.app.workflows.dispatcher.TransactionDispatcher;
import com.hedera.node.app.workflows.handle.Dispatch;
import com.hedera.node.app.workflows.handle.DispatchHandleContext;
import com.hedera.node.app.workflows.handle.DispatchProcessor;
import com.hedera.node.app.workflows.handle.RecordDispatch;
import com.hedera.node.app.workflows.handle.record.TokenContextImpl;
import com.hedera.node.app.workflows.handle.stack.SavepointStackImpl;
import com.hedera.node.app.workflows.prehandle.PreHandleContextImpl;
import com.hedera.node.app.workflows.prehandle.PreHandleResult;
import com.hedera.node.app.workflows.purechecks.PureChecksContextImpl;
import com.hedera.node.config.data.BlockStreamConfig;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.types.StreamMode;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ChildDispatchFactory {
    private static final KeyComparator KEY_COMPARATOR = new KeyComparator();
    public static final NoOpKeyVerifier NO_OP_KEY_VERIFIER = new NoOpKeyVerifier();
    private static final Set<HederaFunctionality> RECURSIVE_FUNCTIONS = EnumSet.of(HederaFunctionality.CONTRACT_CALL, HederaFunctionality.CONTRACT_CREATE, HederaFunctionality.ETHEREUM_TRANSACTION);
    private final TransactionDispatcher dispatcher;
    private final Authorizer authorizer;
    private final NetworkInfo networkInfo;
    private final FeeManager feeManager;
    private final AppFeeCharging appFeeCharging;
    private final DispatchProcessor dispatchProcessor;
    private final ServiceScopeLookup serviceScopeLookup;
    private final ExchangeRateManager exchangeRateManager;
    private final TransactionChecker transactionChecker;
    private final Map<Class<?>, ServiceApiProvider<?>> apiProviders;
    private final NodeFeeAccumulator nodeFeeAccumulator;

    @Inject
    public ChildDispatchFactory(@NonNull TransactionDispatcher dispatcher, @NonNull Authorizer authorizer, @NonNull NetworkInfo networkInfo, @NonNull FeeManager feeManager, @NonNull AppFeeCharging appFeeCharging, @NonNull DispatchProcessor dispatchProcessor, @NonNull ServiceScopeLookup serviceScopeLookup, @NonNull ExchangeRateManager exchangeRateManager, @NonNull TransactionChecker transactionChecker, @NonNull Map<Class<?>, ServiceApiProvider<?>> apiProviders, @NonNull NodeFeeAccumulator nodeFeeAccumulator) {
        this.dispatcher = Objects.requireNonNull(dispatcher);
        this.authorizer = Objects.requireNonNull(authorizer);
        this.networkInfo = Objects.requireNonNull(networkInfo);
        this.feeManager = Objects.requireNonNull(feeManager);
        this.appFeeCharging = Objects.requireNonNull(appFeeCharging);
        this.dispatchProcessor = Objects.requireNonNull(dispatchProcessor);
        this.serviceScopeLookup = Objects.requireNonNull(serviceScopeLookup);
        this.exchangeRateManager = Objects.requireNonNull(exchangeRateManager);
        this.transactionChecker = Objects.requireNonNull(transactionChecker);
        this.apiProviders = Objects.requireNonNull(apiProviders);
        this.nodeFeeAccumulator = Objects.requireNonNull(nodeFeeAccumulator);
    }

    public Dispatch createChildDispatch(@NonNull Configuration config, @NonNull SavepointStackImpl stack, @NonNull ReadableStoreFactory readableStoreFactory, @NonNull NodeInfo creatorInfo, @NonNull HederaFunctionality topLevelFunction, @NonNull ThrottleAdviser throttleAdviser, @NonNull Instant consensusNow, @NonNull BlockRecordInfo blockRecordInfo, @NonNull DispatchOptions<?> options, @Nullable PreHandleResult overridePreHandleResult) {
        Objects.requireNonNull(config);
        Objects.requireNonNull(stack);
        Objects.requireNonNull(readableStoreFactory);
        Objects.requireNonNull(creatorInfo);
        Objects.requireNonNull(topLevelFunction);
        Objects.requireNonNull(throttleAdviser);
        Objects.requireNonNull(consensusNow);
        Objects.requireNonNull(blockRecordInfo);
        Objects.requireNonNull(options);
        PreHandleResult preHandleResult = overridePreHandleResult != null ? overridePreHandleResult : this.preHandleChild(options.body(), options.payerId(), config, readableStoreFactory, creatorInfo);
        AppKeyVerifier childVerifier = overridePreHandleResult != null ? new DefaultKeyVerifier((HederaConfig)config.getConfigData(HederaConfig.class), overridePreHandleResult.getVerificationResults()) : ChildDispatchFactory.getKeyVerifier(options.effectiveKeyVerifier(), config, options.authorizingKeys());
        boolean isLastAllowedPreset = false;
        if (options.body().hasScheduleCreate()) {
            HederaFunctionality scheduledFunction = HandlerUtility.functionalityForType((SchedulableTransactionBody.DataOneOfType)((SchedulableTransactionBody.DataOneOfType)options.body().scheduleCreateOrThrow().scheduledTransactionBodyOrElse(SchedulableTransactionBody.DEFAULT).data().kind()));
            isLastAllowedPreset = RECURSIVE_FUNCTIONS.contains(scheduledFunction);
        }
        TransactionBody body = options.usePresetTxnId() == DispatchOptions.UsePresetTxnId.NO ? options.body() : options.body().copyBuilder().transactionID(stack.nextPresetTxnId(isLastAllowedPreset)).build();
        TransactionInfo childTxnInfo = overridePreHandleResult != null ? overridePreHandleResult.txInfo() : ChildDispatchFactory.getTxnInfoFrom(options.payerId(), body);
        StreamMode streamMode = ((BlockStreamConfig)config.getConfigData(BlockStreamConfig.class)).streamMode();
        SavepointStackImpl childStack = SavepointStackImpl.newChildStack(stack, options.reversingBehavior(), options.category(), options.signedTxCustomizer(), streamMode);
        StreamBuilder streamBuilder = this.initializedForChild(childStack.getBaseBuilder(StreamBuilder.class), Objects.requireNonNull(childTxnInfo));
        return this.newChildDispatch(streamBuilder, childTxnInfo, options.payerId(), options.category(), childStack, preHandleResult, childVerifier, consensusNow, options.dispatchMetadata(), options.throttling(), options.customFeeCharging(), creatorInfo, config, topLevelFunction, throttleAdviser, this.authorizer, this.networkInfo, this.feeManager, this.dispatchProcessor, blockRecordInfo, this.serviceScopeLookup, this.exchangeRateManager, this.dispatcher);
    }

    private RecordDispatch newChildDispatch(@NonNull StreamBuilder builder, @NonNull TransactionInfo txnInfo, @NonNull AccountID payerId, @NonNull HandleContext.TransactionCategory category, @NonNull SavepointStackImpl childStack, @NonNull PreHandleResult preHandleResult, @NonNull AppKeyVerifier keyVerifier, @NonNull Instant consensusNow, @NonNull HandleContext.DispatchMetadata dispatchMetadata, @NonNull HandleContext.ConsensusThrottling consensusThrottling, @Nullable FeeCharging customFeeCharging, @NonNull NodeInfo creatorInfo, @NonNull Configuration config, @NonNull HederaFunctionality topLevelFunction, @NonNull ThrottleAdviser throttleAdviser, @NonNull Authorizer authorizer, @NonNull NetworkInfo networkInfo, @NonNull FeeManager feeManager, @NonNull DispatchProcessor dispatchProcessor, @NonNull BlockRecordInfo blockRecordInfo, @NonNull ServiceScopeLookup serviceScopeLookup, @NonNull ExchangeRateManager exchangeRateManager, @NonNull TransactionDispatcher dispatcher) {
        ReadableStoreFactory readableStoreFactory = new ReadableStoreFactory(childStack);
        WritableEntityIdStoreImpl writableEntityIdStore = new WritableEntityIdStoreImpl(childStack.getWritableStates("EntityIdService"));
        EntityNumGeneratorImpl entityNumGenerator = new EntityNumGeneratorImpl((WritableEntityIdStore)writableEntityIdStore);
        WritableStoreFactory writableStoreFactory = new WritableStoreFactory(childStack, serviceScopeLookup.getServiceName(txnInfo.txBody()), (WritableEntityCounters)writableEntityIdStore);
        ServiceApiFactory serviceApiFactory = new ServiceApiFactory(childStack, config, this.apiProviders, this.nodeFeeAccumulator);
        ResourcePriceCalculatorImpl priceCalculator = new ResourcePriceCalculatorImpl(consensusNow, txnInfo, feeManager, readableStoreFactory);
        StoreFactoryImpl storeFactory = new StoreFactoryImpl(readableStoreFactory, writableStoreFactory, serviceApiFactory);
        FeeAccumulator childFeeAccumulator = new FeeAccumulator(serviceApiFactory.getApi(TokenServiceApi.class), (FeeStreamBuilder)builder, childStack);
        FeeCharging feeCharging = customFeeCharging != null ? customFeeCharging : this.appFeeCharging;
        DispatchHandleContext dispatchHandleContext = new DispatchHandleContext(consensusNow, creatorInfo, txnInfo, config, authorizer, blockRecordInfo, priceCalculator, feeManager, feeCharging, storeFactory, payerId, keyVerifier, topLevelFunction, Key.DEFAULT, exchangeRateManager, childStack, (EntityNumGenerator)entityNumGenerator, dispatcher, networkInfo, this, dispatchProcessor, throttleAdviser, childFeeAccumulator, dispatchMetadata, this.transactionChecker, null, null, category);
        Fees childFees = category == HandleContext.TransactionCategory.BATCH_INNER ? dispatchHandleContext.dispatchComputeFees(txnInfo.txBody(), payerId, ComputeDispatchFeesAsTopLevel.YES) : dispatchHandleContext.dispatchComputeFees(txnInfo.txBody(), payerId);
        long congestionMultiplier = feeManager.congestionMultiplierFor(txnInfo.txBody(), txnInfo.functionality(), storeFactory.asReadOnly());
        if (congestionMultiplier > 1L) {
            builder.congestionMultiplier(congestionMultiplier);
        }
        TokenContextImpl childTokenContext = new TokenContextImpl(config, childStack, consensusNow, (WritableEntityCounters)writableEntityIdStore);
        return new RecordDispatch(builder, config, childFees, txnInfo, payerId, readableStoreFactory, childFeeAccumulator, keyVerifier, creatorInfo, consensusNow, preHandleResult.getRequiredKeys(), preHandleResult.getHollowAccounts(), dispatchHandleContext, childStack, category, childTokenContext, preHandleResult, consensusThrottling, customFeeCharging);
    }

    private PreHandleResult preHandleChild(@NonNull TransactionBody txBody, @NonNull AccountID syntheticPayerId, @NonNull Configuration config, @NonNull ReadableStoreFactory readableStoreFactory, @NonNull NodeInfo creatorInfo) {
        try {
            PureChecksContextImpl pureChecksContext = new PureChecksContextImpl(txBody, this.dispatcher);
            this.dispatcher.dispatchPureChecks(pureChecksContext);
            PreHandleContextImpl preHandleContext = new PreHandleContextImpl(readableStoreFactory, txBody, syntheticPayerId, config, this.dispatcher, this.transactionChecker, creatorInfo);
            this.dispatcher.dispatchPreHandle(preHandleContext);
            return new PreHandleResult(null, null, PreHandleResult.Status.SO_FAR_SO_GOOD, ResponseCodeEnum.OK, null, preHandleContext.requiredNonPayerKeys(), null, preHandleContext.requiredHollowAccounts(), null, null, 0L);
        }
        catch (PreCheckException e) {
            return new PreHandleResult(null, null, PreHandleResult.Status.PRE_HANDLE_FAILURE, e.responseCode(), null, Collections.emptySet(), null, Collections.emptySet(), null, null, 0L);
        }
    }

    public static AppKeyVerifier getKeyVerifier(final @Nullable Predicate<Key> callback, final @NonNull Configuration config, @NonNull Set<Key> authorizingKeys) {
        final SortedSet<Key> keys = ChildDispatchFactory.asSortedSet(authorizingKeys);
        return callback == null ? (authorizingKeys.isEmpty() ? NO_OP_KEY_VERIFIER : new NoOpKeyVerifier(){

            public SortedSet<Key> authorizingSimpleKeys() {
                return keys;
            }
        }) : new AppKeyVerifier(){
            private final AppKeyVerifier verifier;
            {
                this.verifier = new DefaultKeyVerifier((HederaConfig)config.getConfigData(HederaConfig.class), Collections.emptyMap());
            }

            @NonNull
            public SignatureVerification verificationFor(@NonNull Key key) {
                return this.verifier.verificationFor(key, (k, v) -> callback.test(k));
            }

            @NonNull
            public SignatureVerification verificationFor(@NonNull Key key, @NonNull VerificationAssistant callback2) {
                return this.verifier.verificationFor(key, callback2);
            }

            @Override
            @NonNull
            public SignatureVerification verificationFor(@NonNull Bytes evmAlias) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int numSignaturesVerified() {
                return 0;
            }

            public SortedSet<Key> authorizingSimpleKeys() {
                return keys;
            }
        };
    }

    public static TransactionInfo getTxnInfoFrom(@NonNull AccountID payerId, @NonNull TransactionBody txBody) {
        Objects.requireNonNull(payerId);
        Objects.requireNonNull(txBody);
        Bytes bodyBytes = TransactionBody.PROTOBUF.toBytes((Object)txBody);
        SignedTransaction signedTx = SignedTransaction.newBuilder().bodyBytes(bodyBytes).build();
        return new TransactionInfo(signedTx, txBody, txBody.transactionIDOrElse(TransactionID.DEFAULT), payerId, SignatureMap.DEFAULT, bodyBytes, ChildDispatchFactory.functionOfTxn(txBody), null);
    }

    public static HederaFunctionality functionOfTxn(TransactionBody txBody) {
        try {
            return HapiUtils.functionOf((TransactionBody)txBody);
        }
        catch (UnknownHederaFunctionality e) {
            throw new IllegalArgumentException("Unknown Hedera Functionality", e);
        }
    }

    private StreamBuilder initializedForChild(@NonNull StreamBuilder builder, @NonNull TransactionInfo txnInfo) {
        builder.signedTx(txnInfo.signedTx()).functionality(txnInfo.functionality()).memo(txnInfo.txBody().memo());
        TransactionID transactionID = txnInfo.txBody().transactionID();
        if (transactionID != null) {
            builder.transactionID(transactionID);
        }
        return builder;
    }

    private static SortedSet<Key> asSortedSet(final @NonNull Set<Key> keys) {
        return keys.isEmpty() ? Collections.emptySortedSet() : Collections.unmodifiableSortedSet(new TreeSet<Key>((Comparator)KEY_COMPARATOR){
            {
                super(comparator);
                this.addAll(keys);
            }
        });
    }

    public static class NoOpKeyVerifier
    implements AppKeyVerifier {
        private static final SignatureVerification PASSED_VERIFICATION = new SignatureVerificationImpl(Key.DEFAULT, Bytes.EMPTY, true);

        @NonNull
        public SignatureVerification verificationFor(@NonNull Key key) {
            return PASSED_VERIFICATION;
        }

        @NonNull
        public SignatureVerification verificationFor(@NonNull Key key, @NonNull VerificationAssistant callback) {
            return PASSED_VERIFICATION;
        }

        @Override
        @NonNull
        public SignatureVerification verificationFor(@NonNull Bytes evmAlias) {
            return PASSED_VERIFICATION;
        }

        @Override
        public int numSignaturesVerified() {
            return 0;
        }
    }
}

