/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.io.streams;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.stream.ReadableStreamingData;
import com.swirlds.base.function.CheckedFunction;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.hiero.base.ValueReference;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.SerializableDet;
import org.hiero.base.io.exceptions.ClassNotFoundException;
import org.hiero.base.io.exceptions.InvalidVersionException;
import org.hiero.base.io.streams.AugmentedDataInputStream;

public class SerializableDataInputStream
extends AugmentedDataInputStream {
    private static final int MAX_PBJ_RECORD_SIZE = 0x2000000;
    private static final Set<Integer> SUPPORTED_PROTOCOL_VERSIONS = Set.of(Integer.valueOf(1));
    private final ReadableSequentialData readableSequentialData;

    public SerializableDataInputStream(@NonNull InputStream in) {
        super(in);
        this.readableSequentialData = new ReadableStreamingData(in);
    }

    public int readProtocolVersion() throws IOException {
        int protocolVersion = this.readInt();
        if (!SUPPORTED_PROTOCOL_VERSIONS.contains(protocolVersion)) {
            throw new IOException("Unsupported protocol version " + protocolVersion);
        }
        return protocolVersion;
    }

    @Nullable
    public <T extends SelfSerializable> T readSerializable(@Nullable Set<Long> permissibleClassIds) throws IOException {
        return this.readSerializable(true, SerializableDataInputStream::registryConstructor, permissibleClassIds);
    }

    @Nullable
    public <T extends SelfSerializable> T readSerializable() throws IOException {
        return this.readSerializable(null);
    }

    @Nullable
    public <T extends SelfSerializable> T readSerializable(boolean readClassId, @NonNull Supplier<T> serializableConstructor, @Nullable Set<Long> permissibleClassIds) throws IOException {
        Objects.requireNonNull(serializableConstructor, "serializableConstructor must not be null");
        return this.readSerializable(readClassId, id -> (SelfSerializable)serializableConstructor.get(), permissibleClassIds);
    }

    @Nullable
    public <T extends SelfSerializable> T readSerializable(boolean readClassId, @NonNull Supplier<T> serializableConstructor) throws IOException {
        return this.readSerializable(readClassId, serializableConstructor, null);
    }

    protected void validateVersion(@NonNull SerializableDet object, int version) throws InvalidVersionException {
        if (version < object.getMinimumSupportedVersion() || version > object.getVersion()) {
            throw new InvalidVersionException(version, object);
        }
    }

    protected void recordClassId(long classId) {
    }

    protected void recordClass(Object o) {
    }

    @Nullable
    private <T extends SelfSerializable> T readSerializable(boolean readClassId, @NonNull CheckedFunction<Long, T, IOException> serializableConstructor, @Nullable Set<Long> permissibleClassIds) throws IOException {
        int version;
        Long classId;
        if (readClassId) {
            classId = this.readLong();
            if (permissibleClassIds != null && !permissibleClassIds.contains(classId)) {
                throw new IOException("Class ID " + classId + " is not in the set of permissible class IDs: " + String.valueOf(permissibleClassIds));
            }
            this.recordClassId(classId);
            if (classId == Long.MIN_VALUE) {
                return null;
            }
        } else {
            classId = null;
        }
        if ((version = this.readInt()) == Integer.MIN_VALUE) {
            return null;
        }
        SelfSerializable serializable = (SelfSerializable)serializableConstructor.apply((Object)classId);
        this.recordClass(serializable);
        this.validateVersion(serializable, version);
        serializable.deserialize(this, version);
        return (T)serializable;
    }

    public <T extends SelfSerializable> void readSerializableIterableWithSize(int maxSize, @NonNull Consumer<T> callback, @Nullable Set<Long> permissibleClassIds) throws IOException {
        int size = this.readInt();
        this.checkLengthLimit(size, maxSize);
        this.readSerializableIterableWithSizeInternal(size, true, SerializableDataInputStream::registryConstructor, callback, permissibleClassIds);
    }

    public <T extends SelfSerializable> void readSerializableIterableWithSize(int maxSize, @NonNull Consumer<T> callback) throws IOException {
        this.readSerializableIterableWithSize(maxSize, callback, null);
    }

    public <T extends SelfSerializable> void readSerializableIterableWithSize(int maxSize, boolean readClassId, @NonNull Supplier<T> serializableConstructor, @NonNull Consumer<T> callback, @Nullable Set<Long> permissibleClassIds) throws IOException {
        int size = this.readInt();
        this.checkLengthLimit(size, maxSize);
        this.readSerializableIterableWithSizeInternal(size, readClassId, id -> (SelfSerializable)serializableConstructor.get(), callback, permissibleClassIds);
    }

    public <T extends SelfSerializable> void readSerializableIterableWithSize(int maxSize, boolean readClassId, @NonNull Supplier<T> serializableConstructor, @NonNull Consumer<T> callback) throws IOException {
        this.readSerializableIterableWithSize(maxSize, readClassId, serializableConstructor, callback, null);
    }

    private <T extends SelfSerializable> void readSerializableIterableWithSizeInternal(int size, boolean readClassId, @NonNull CheckedFunction<Long, T, IOException> serializableConstructor, @NonNull Consumer<T> callback, @Nullable Set<Long> permissibleClassIds) throws IOException {
        if (serializableConstructor == null) {
            throw new IllegalArgumentException("serializableConstructor is null");
        }
        if (size == 0) {
            return;
        }
        boolean allSameClass = this.readBoolean();
        ValueReference<Long> classId = new ValueReference<Long>();
        ValueReference<Integer> version = new ValueReference<Integer>();
        for (int i = 0; i < size; ++i) {
            T next = this.readNextSerializableIteration(allSameClass, readClassId, classId, version, serializableConstructor, permissibleClassIds);
            callback.accept(next);
        }
    }

    @Nullable
    protected <T extends SelfSerializable> T readNextSerializableIteration(boolean allSameClass, boolean readClassId, @NonNull ValueReference<Long> classId, @NonNull ValueReference<Integer> version, @NonNull CheckedFunction<Long, T, IOException> serializableConstructor, @Nullable Set<Long> permissibleClassIds) throws IOException {
        if (!allSameClass) {
            return this.readSerializable(readClassId, serializableConstructor, permissibleClassIds);
        }
        boolean isNull = this.readBoolean();
        if (isNull) {
            return null;
        }
        if (version.getValue() == null) {
            if (readClassId) {
                classId.setValue(this.readLong());
                if (permissibleClassIds != null && !permissibleClassIds.contains(classId.getValue())) {
                    throw new IOException("Class ID " + String.valueOf(classId) + " is not in the set of permissible class IDs: " + String.valueOf(permissibleClassIds));
                }
            }
            version.setValue(this.readInt());
        }
        SelfSerializable serializable = (SelfSerializable)serializableConstructor.apply((Object)classId.getValue());
        this.recordClassId(serializable.getClassId());
        this.recordClass(serializable);
        serializable.deserialize(this, version.getValue());
        return (T)serializable;
    }

    @Nullable
    public <T extends SelfSerializable> List<T> readSerializableList(int maxListSize, @Nullable Set<Long> permissibleClassIds) throws IOException {
        return this.readSerializableList(maxListSize, true, SerializableDataInputStream::registryConstructor, permissibleClassIds);
    }

    @Nullable
    public <T extends SelfSerializable> List<T> readSerializableList(int maxListSize) throws IOException {
        return this.readSerializableList(maxListSize, null);
    }

    @Nullable
    public <T extends SelfSerializable> List<T> readSerializableList(int maxListSize, boolean readClassId, @NonNull Supplier<T> serializableConstructor, @Nullable Set<Long> permissibleClassIds) throws IOException {
        Objects.requireNonNull(serializableConstructor, "serializableConstructor must not be null");
        return this.readSerializableList(maxListSize, readClassId, id -> (SelfSerializable)serializableConstructor.get(), permissibleClassIds);
    }

    @Nullable
    public <T extends SelfSerializable> List<T> readSerializableList(int maxListSize, boolean readClassId, @NonNull Supplier<T> serializableConstructor) throws IOException {
        return this.readSerializableList(maxListSize, readClassId, serializableConstructor, null);
    }

    @Nullable
    private <T extends SelfSerializable> List<T> readSerializableList(int maxListSize, boolean readClassId, @NonNull CheckedFunction<Long, T, IOException> serializableConstructor, @Nullable Set<Long> permissibleClassIds) throws IOException {
        int length = this.readInt();
        if (length == -1) {
            return null;
        }
        this.checkLengthLimit(length, maxListSize);
        ArrayList list = new ArrayList(length);
        if (length == 0) {
            return list;
        }
        this.readSerializableIterableWithSizeInternal(length, readClassId, serializableConstructor, list::add, permissibleClassIds);
        return list;
    }

    @Nullable
    public <T extends SelfSerializable> T[] readSerializableArray(@NonNull IntFunction<T[]> arrayConstructor, int maxListSize, boolean readClassId, @Nullable Set<Long> permissibleClassIds) throws IOException {
        List<SelfSerializable> list = this.readSerializableList(maxListSize, readClassId, SerializableDataInputStream::registryConstructor, permissibleClassIds);
        if (list == null) {
            return null;
        }
        return list.toArray((SelfSerializable[])arrayConstructor.apply(list.size()));
    }

    @Nullable
    public <T extends SelfSerializable> T[] readSerializableArray(@NonNull IntFunction<T[]> arrayConstructor, int maxListSize, boolean readClassId, @NonNull Supplier<T> serializableConstructor, @Nullable Set<Long> permissibleClassIds) throws IOException {
        List<SelfSerializable> list = this.readSerializableList(maxListSize, readClassId, id -> (SelfSerializable)serializableConstructor.get(), permissibleClassIds);
        if (list == null) {
            return null;
        }
        return list.toArray((SelfSerializable[])arrayConstructor.apply(list.size()));
    }

    @Nullable
    public <T extends SelfSerializable> T[] readSerializableArray(@NonNull IntFunction<T[]> arrayConstructor, int maxListSize, boolean readClassId, @NonNull Supplier<T> serializableConstructor) throws IOException {
        return this.readSerializableArray(arrayConstructor, maxListSize, readClassId, serializableConstructor, null);
    }

    @NonNull
    private static <T extends SelfSerializable> T registryConstructor(long classId) throws IOException {
        SelfSerializable rc = (SelfSerializable)ConstructableRegistry.getInstance().createObject(classId);
        if (rc == null) {
            throw new ClassNotFoundException(classId);
        }
        return (T)rc;
    }

    @NonNull
    public <T> T readPbjRecord(@NonNull Codec<T> codec) throws IOException {
        int size = this.readInt();
        this.readableSequentialData.limit(this.readableSequentialData.position() + (long)size);
        try {
            Object parsed = codec.parse(this.readableSequentialData, false, false, 512, 0x2000000);
            if (this.readableSequentialData.position() != this.readableSequentialData.limit()) {
                throw new EOFException("PBJ record was not fully read");
            }
            return (T)parsed;
        }
        catch (ParseException e) {
            if (e.getCause() instanceof BufferOverflowException || e.getCause() instanceof BufferUnderflowException) {
                EOFException eofException = new EOFException("Buffer underflow while reading PBJ record");
                eofException.addSuppressed(e);
                throw eofException;
            }
            throw new IOException(e);
        }
    }
}

