/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.pcli.graph;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.pcli.graph.EventGraphSource;

public class EventGraphPipeline {
    private final EventGraphSource source;
    private final EventFilter filter;
    private final EventMapper mapper;
    private final EventSink eventSink;
    private final BatchEventSink batchEventSink;

    public EventGraphPipeline(@NonNull EventGraphSource source, @Nullable EventFilter filter, @Nullable EventMapper mapper, @Nullable EventSink eventSink, @Nullable BatchEventSink batchEventSink) {
        this.source = Objects.requireNonNull(source);
        this.filter = filter;
        this.mapper = mapper;
        this.eventSink = eventSink;
        this.batchEventSink = batchEventSink;
    }

    public void process() {
        ArrayList<PlatformEvent> outputEvents;
        ArrayList<PlatformEvent> arrayList = outputEvents = this.batchEventSink != null ? new ArrayList<PlatformEvent>() : null;
        while (this.source.hasNext()) {
            PlatformEvent outputEvent;
            PlatformEvent event = this.source.next();
            if (this.filter != null && !this.filter.filter(event)) continue;
            PlatformEvent platformEvent = outputEvent = this.mapper != null ? this.mapper.map(event) : event;
            if (this.eventSink != null) {
                this.eventSink.accept(outputEvent);
            }
            if (outputEvents == null) continue;
            outputEvents.add(outputEvent);
        }
        if (this.batchEventSink != null) {
            this.batchEventSink.accept(outputEvents);
        }
    }

    public static interface EventFilter
    extends Predicate<PlatformEvent> {
        public boolean filter(@NonNull PlatformEvent var1);

        @Override
        default public boolean test(@NonNull PlatformEvent event) {
            return this.filter(event);
        }
    }

    public static interface EventMapper
    extends Function<PlatformEvent, PlatformEvent> {
        @NonNull
        public PlatformEvent map(@NonNull PlatformEvent var1);

        @Override
        default public PlatformEvent apply(@NonNull PlatformEvent event) {
            return this.map(event);
        }
    }

    public static interface EventSink
    extends Consumer<PlatformEvent> {
    }

    public static interface BatchEventSink
    extends Consumer<List<PlatformEvent>> {
    }
}

