/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.node.config.data.AccountsConfig;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public class BaseCryptoHandler {
    @NonNull
    public static AccountID asAccount(long shard, long realm, long num) {
        return AccountID.newBuilder().shardNum(shard).realmNum(realm).accountNum(num).build();
    }

    public static boolean isStakingAccount(@NonNull Configuration configuration, @Nullable AccountID accountID) {
        long accountNum = accountID != null ? accountID.accountNum() : 0L;
        AccountsConfig accountsConfig = (AccountsConfig)configuration.getConfigData(AccountsConfig.class);
        return accountNum == accountsConfig.stakingRewardAccount() || accountNum == accountsConfig.nodeRewardAccount();
    }

    public static boolean hasAccountNumOrAlias(@Nullable AccountID accountID) {
        return accountID != null && (accountID.hasAccountNum() && accountID.accountNumOrThrow() != 0L || accountID.hasAlias() && accountID.aliasOrThrow().length() > 0L);
    }
}

