/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.features;

import io.helidon.common.features.metadata.FeatureMetadata;
import io.helidon.common.features.metadata.FeatureRegistry;
import io.helidon.metadata.MetadataDiscovery;
import io.helidon.metadata.hson.Hson;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

final class FeatureCatalog {
    private static final System.Logger LOGGER = System.getLogger(FeatureCatalog.class.getName());

    private FeatureCatalog() {
    }

    static List<FeatureMetadata> features(ClassLoader classLoader) {
        LinkedHashMap<String, FeatureMetadata> features = new LinkedHashMap<String, FeatureMetadata>();
        try {
            MetadataDiscovery.instance().list("feature-registry.json").forEach(metadatum -> {
                Hson.Array hson;
                try (InputStream in = metadatum.inputStream();){
                    hson = Hson.parse((InputStream)in).asArray();
                }
                catch (IOException e) {
                    LOGGER.log(System.Logger.Level.WARNING, "Failed to read features from " + metadatum.absoluteLocation(), (Throwable)e);
                    return;
                }
                List metadatas = FeatureRegistry.metadata((String)("Classpath: " + metadatum.absoluteLocation()), (Hson.Array)hson);
                for (FeatureMetadata metadata : metadatas) {
                    features.putIfAbsent(metadata.name(), metadata);
                }
            });
            Enumeration<URL> resources = classLoader.getResources("META-INF/helidon/feature-metadata.properties");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                Properties props = new Properties();
                try (InputStream in = url.openStream();){
                    props.load(in);
                }
                FeatureMetadata metadata = FeatureRegistry.metadata((String)("Classpath: " + url.toString()), (Properties)props);
                features.putIfAbsent(metadata.name(), metadata);
            }
        }
        catch (IOException e) {
            LOGGER.log(System.Logger.Level.WARNING, "Could not discover Helidon features", (Throwable)e);
        }
        return FeatureCatalog.orderFeatureMetadata(features);
    }

    private static List<FeatureMetadata> orderFeatureMetadata(Map<String, FeatureMetadata> features) {
        ArrayList<FeatureMetadata> result = new ArrayList<FeatureMetadata>(features.values());
        result.sort((first, second) -> {
            List path = first.path();
            List path2 = second.path();
            for (int i = 0; i < path.size() && i < path2.size(); ++i) {
                int comparison = ((String)path.get(i)).compareTo((String)path2.get(i));
                if (comparison == 0) continue;
                return comparison;
            }
            return path.size() - path2.size();
        });
        return result;
    }
}

