/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.crypto;

import java.security.Provider;
import java.security.Security;
import java.time.Instant;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class CryptoConstants {
    public static final int HASH_SIZE_BYTES = 48;
    public static final int SIG_KEY_SIZE_BITS = 3072;
    public static final int AGR_KEY_SIZE_BITS = 384;
    public static final int SIG_SIZE_BYTES = 384;
    public static final int SYM_KEY_SIZE_BYTES = 32;
    public static final String AGR_TYPE = "EC";
    public static final String AGR_PROVIDER = "SunEC";
    public static final String SIG_TYPE1 = "RSA";
    public static final String SIG_PROVIDER = CryptoConstants.getBCProviderName();
    public static final String SIG_TYPE2 = "SHA384withRSA";
    public static final String TLS_SUITE = "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384";
    public static final Instant DEFAULT_VALID_FROM = Instant.parse("2000-01-01T00:00:00Z");
    public static final Instant DEFAULT_VALID_TO = Instant.parse("2100-01-01T00:00:00Z");
    public static final String KEY_MANAGER_FACTORY_TYPE = "SunX509";
    public static final String TRUST_MANAGER_FACTORY_TYPE = "SunX509";
    public static final String SSL_VERSION = "TLSv1.2";
    public static final String KEYSTORE_TYPE = "pkcs12";

    private CryptoConstants() {
    }

    private static String getBCProviderName() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        return "BC";
    }
}

