/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.metrics.api;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.MetricType;
import com.swirlds.metrics.api.MetricsFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.EnumSet;
import java.util.Objects;

public interface Counter
extends Metric {
    @Override
    @NonNull
    default public MetricType getMetricType() {
        return MetricType.COUNTER;
    }

    @Override
    @NonNull
    default public Metric.DataType getDataType() {
        return Metric.DataType.INT;
    }

    @Override
    @NonNull
    default public EnumSet<Metric.ValueType> getValueTypes() {
        return EnumSet.of(Metric.ValueType.VALUE);
    }

    @Override
    @NonNull
    default public Long get(@NonNull Metric.ValueType valueType) {
        Objects.requireNonNull(valueType, "valueType must not be null");
        if (valueType == Metric.ValueType.VALUE) {
            return this.get();
        }
        throw new IllegalArgumentException("Unsupported ValueType: " + String.valueOf((Object)valueType));
    }

    public long get();

    public void add(long var1);

    public void increment();

    public static final class Config
    extends MetricConfig<Counter, Config> {
        public Config(@NonNull String category, @NonNull String name) {
            super(category, name, "%d");
        }

        private Config(@NonNull String category, @NonNull String name, @NonNull String description, @NonNull String unit) {
            super(category, name, description, unit, "%d");
        }

        @Override
        @NonNull
        public Config withDescription(@NonNull String description) {
            return new Config(this.getCategory(), this.getName(), description, this.getUnit());
        }

        @Override
        @NonNull
        public Config withUnit(@NonNull String unit) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), unit);
        }

        @Override
        @NonNull
        public Class<Counter> getResultClass() {
            return Counter.class;
        }

        @Override
        @NonNull
        public Counter create(@NonNull MetricsFactory factory) {
            return factory.createCounter(this);
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).toString();
        }
    }
}

