/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.OverflowException;
import org.hyperledger.besu.evm.internal.UnderflowException;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

abstract class AbstractFixedCostOperation
extends AbstractOperation {
    protected final Operation.OperationResult successResponse;
    protected final Operation.OperationResult outOfGasResponse;
    private final Operation.OperationResult underflowResponse;
    private final Operation.OperationResult overflowResponse;
    protected final long gasCost;

    protected AbstractFixedCostOperation(int opcode, String name, int stackItemsConsumed, int stackItemsProduced, GasCalculator gasCalculator, long fixedCost) {
        super(opcode, name, stackItemsConsumed, stackItemsProduced, gasCalculator);
        this.gasCost = fixedCost;
        this.successResponse = new Operation.OperationResult(this.gasCost, null);
        this.outOfGasResponse = new Operation.OperationResult(this.gasCost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        this.underflowResponse = new Operation.OperationResult(this.gasCost, ExceptionalHaltReason.INSUFFICIENT_STACK_ITEMS);
        this.overflowResponse = new Operation.OperationResult(this.gasCost, ExceptionalHaltReason.TOO_MANY_STACK_ITEMS);
    }

    @Override
    public final Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        try {
            if (frame.getRemainingGas() < this.gasCost) {
                return this.outOfGasResponse;
            }
            return this.executeFixedCostOperation(frame, evm);
        }
        catch (UnderflowException ufe) {
            return this.underflowResponse;
        }
        catch (OverflowException ofe) {
            return this.overflowResponse;
        }
    }

    protected abstract Operation.OperationResult executeFixedCostOperation(MessageFrame var1, EVM var2);
}

