/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hiero.base.crypto.DigestType;

public interface StreamingTreeHasher {
    public static final int HASH_LENGTH = DigestType.SHA_384.digestLength();
    public static final byte[] LEAF_PREFIX = new byte[]{0};
    public static final byte[] SINGLE_CHILD_INTERNAL_NODE_PREFIX = new byte[]{1};
    public static final byte[] INTERNAL_NODE_PREFIX = new byte[]{2};
    public static final Bytes INTERNAL_NODE_PREFIX_BYTES = Bytes.wrap((byte[])INTERNAL_NODE_PREFIX);

    public void addLeaf(@NonNull ByteBuffer var1);

    public CompletableFuture<Bytes> rootHash();

    default public Status status() {
        throw new UnsupportedOperationException();
    }

    public record Status(int numLeaves, @NonNull List<Bytes> rightmostHashes) {
        public static Status EMPTY = new Status(0, List.of());

        public boolean isEmpty() {
            return this.numLeaves == 0;
        }
    }
}

