/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle.steps;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.transaction.ExchangeRateSet;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.hedera.node.app.blocks.BlockStreamManager;
import com.hedera.node.app.blocks.impl.BoundaryStateChangeListener;
import com.hedera.node.app.blocks.impl.ImmediateStateChangeListener;
import com.hedera.node.app.fees.AppFeeCharging;
import com.hedera.node.app.fees.ExchangeRateManager;
import com.hedera.node.app.fees.FeeAccumulator;
import com.hedera.node.app.fees.FeeManager;
import com.hedera.node.app.fees.ResourcePriceCalculatorImpl;
import com.hedera.node.app.records.BlockRecordManager;
import com.hedera.node.app.service.entityid.EntityNumGenerator;
import com.hedera.node.app.service.entityid.WritableEntityCounters;
import com.hedera.node.app.service.entityid.WritableEntityIdStore;
import com.hedera.node.app.service.entityid.impl.EntityNumGeneratorImpl;
import com.hedera.node.app.service.entityid.impl.WritableEntityIdStoreImpl;
import com.hedera.node.app.service.token.api.FeeStreamBuilder;
import com.hedera.node.app.service.token.api.TokenServiceApi;
import com.hedera.node.app.services.ServiceScopeLookup;
import com.hedera.node.app.signature.AppKeyVerifier;
import com.hedera.node.app.signature.DefaultKeyVerifier;
import com.hedera.node.app.spi.api.ServiceApiProvider;
import com.hedera.node.app.spi.authorization.Authorizer;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.fees.NodeFeeAccumulator;
import com.hedera.node.app.spi.info.NetworkInfo;
import com.hedera.node.app.spi.info.NodeInfo;
import com.hedera.node.app.spi.records.BlockRecordInfo;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.node.app.store.ReadableStoreFactory;
import com.hedera.node.app.store.ServiceApiFactory;
import com.hedera.node.app.store.StoreFactoryImpl;
import com.hedera.node.app.store.WritableStoreFactory;
import com.hedera.node.app.throttle.AppThrottleAdviser;
import com.hedera.node.app.throttle.NetworkUtilizationManager;
import com.hedera.node.app.workflows.TransactionChecker;
import com.hedera.node.app.workflows.TransactionInfo;
import com.hedera.node.app.workflows.dispatcher.TransactionDispatcher;
import com.hedera.node.app.workflows.handle.Dispatch;
import com.hedera.node.app.workflows.handle.DispatchHandleContext;
import com.hedera.node.app.workflows.handle.DispatchProcessor;
import com.hedera.node.app.workflows.handle.RecordDispatch;
import com.hedera.node.app.workflows.handle.TransactionType;
import com.hedera.node.app.workflows.handle.dispatch.ChildDispatchFactory;
import com.hedera.node.app.workflows.handle.record.TokenContextImpl;
import com.hedera.node.app.workflows.handle.stack.SavepointStackImpl;
import com.hedera.node.app.workflows.handle.steps.ParentTxn;
import com.hedera.node.app.workflows.prehandle.PreHandleContextImpl;
import com.hedera.node.app.workflows.prehandle.PreHandleResult;
import com.hedera.node.app.workflows.prehandle.PreHandleWorkflow;
import com.hedera.node.app.workflows.purechecks.PureChecksContextImpl;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.VersionedConfiguration;
import com.hedera.node.config.data.BlockStreamConfig;
import com.hedera.node.config.data.ConsensusConfig;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.types.StreamMode;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.transaction.ConsensusTransaction;

@Singleton
public class ParentTxnFactory {
    private static final Logger log = LogManager.getLogger(ParentTxnFactory.class);
    private final ConfigProvider configProvider;
    private final ImmediateStateChangeListener immediateStateChangeListener;
    private final BoundaryStateChangeListener boundaryStateChangeListener;
    private final PreHandleWorkflow preHandleWorkflow;
    private final Authorizer authorizer;
    private final NetworkInfo networkInfo;
    private final FeeManager feeManager;
    private final AppFeeCharging appFeeCharging;
    private final DispatchProcessor dispatchProcessor;
    private final ServiceScopeLookup serviceScopeLookup;
    private final ExchangeRateManager exchangeRateManager;
    private final TransactionDispatcher dispatcher;
    private final NetworkUtilizationManager networkUtilizationManager;
    private final StreamMode streamMode;
    private final BlockRecordManager blockRecordManager;
    private final BlockStreamManager blockStreamManager;
    private final ChildDispatchFactory childDispatchFactory;
    private final TransactionChecker transactionChecker;
    private final Map<Class<?>, ServiceApiProvider<?>> apiProviders;
    private final NodeFeeAccumulator nodeFeeAccumulator;

    @Inject
    public ParentTxnFactory(@NonNull ConfigProvider configProvider, @NonNull ImmediateStateChangeListener immediateStateChangeListener, @NonNull BoundaryStateChangeListener boundaryStateChangeListener, @NonNull PreHandleWorkflow preHandleWorkflow, @NonNull Authorizer authorizer, @NonNull NetworkInfo networkInfo, @NonNull FeeManager feeManager, @NonNull AppFeeCharging appFeeCharging, @NonNull DispatchProcessor dispatchProcessor, @NonNull ServiceScopeLookup serviceScopeLookup, @NonNull ExchangeRateManager exchangeRateManager, @NonNull TransactionDispatcher dispatcher, @NonNull NetworkUtilizationManager networkUtilizationManager, @NonNull BlockRecordManager blockRecordManager, @NonNull BlockStreamManager blockStreamManager, @NonNull ChildDispatchFactory childDispatchFactory, @NonNull TransactionChecker transactionChecker, @NonNull Map<Class<?>, ServiceApiProvider<?>> apiProviders, @NonNull NodeFeeAccumulator nodeFeeAccumulator) {
        this.configProvider = Objects.requireNonNull(configProvider);
        this.immediateStateChangeListener = Objects.requireNonNull(immediateStateChangeListener);
        this.boundaryStateChangeListener = Objects.requireNonNull(boundaryStateChangeListener);
        this.preHandleWorkflow = Objects.requireNonNull(preHandleWorkflow);
        this.authorizer = Objects.requireNonNull(authorizer);
        this.networkInfo = Objects.requireNonNull(networkInfo);
        this.feeManager = Objects.requireNonNull(feeManager);
        this.appFeeCharging = Objects.requireNonNull(appFeeCharging);
        this.dispatcher = Objects.requireNonNull(dispatcher);
        this.networkUtilizationManager = Objects.requireNonNull(networkUtilizationManager);
        this.dispatchProcessor = Objects.requireNonNull(dispatchProcessor);
        this.serviceScopeLookup = Objects.requireNonNull(serviceScopeLookup);
        this.exchangeRateManager = Objects.requireNonNull(exchangeRateManager);
        this.blockStreamManager = Objects.requireNonNull(blockStreamManager);
        this.blockRecordManager = Objects.requireNonNull(blockRecordManager);
        this.childDispatchFactory = Objects.requireNonNull(childDispatchFactory);
        this.streamMode = ((BlockStreamConfig)configProvider.getConfiguration().getConfigData(BlockStreamConfig.class)).streamMode();
        this.transactionChecker = Objects.requireNonNull(transactionChecker);
        this.apiProviders = Objects.requireNonNull(apiProviders);
        this.nodeFeeAccumulator = Objects.requireNonNull(nodeFeeAccumulator);
    }

    public static HandleContext.TransactionCategory getTxnCategory(@NonNull PreHandleResult preHandleResult) {
        Objects.requireNonNull(preHandleResult);
        return preHandleResult.txnInfoOrThrow().signatureMap().sigPair().isEmpty() ? HandleContext.TransactionCategory.NODE : HandleContext.TransactionCategory.USER;
    }

    @Nullable
    public ParentTxn createTopLevelTxn(@NonNull State state, @Nullable NodeInfo creatorInfo, @NonNull ConsensusTransaction platformTxn, @NonNull Instant consensusNow, @NonNull BiConsumer<StateSignatureTransaction, Bytes> shortCircuitTxnCallback) {
        TransactionInfo txnInfo;
        Objects.requireNonNull(state);
        Objects.requireNonNull(platformTxn);
        Objects.requireNonNull(consensusNow);
        VersionedConfiguration config = this.configProvider.getConfiguration();
        SavepointStackImpl stack = this.createRootSavepointStack(state);
        ReadableStoreFactory readableStoreFactory = new ReadableStoreFactory(stack);
        PreHandleResult preHandleResult = this.preHandleWorkflow.getCurrentPreHandleResult(creatorInfo, platformTxn, readableStoreFactory, shortCircuitTxnCallback);
        if (platformTxn.getMetadata() == null) {
            log.error("Transaction {} has no metadata (preHandleResult={}), creating one", (Object)platformTxn, (Object)preHandleResult);
            platformTxn.setMetadata((Object)preHandleResult);
        }
        if ((txnInfo = preHandleResult.txInfo()) == null) {
            log.error("Node {} submitted an unparseable transaction {}", (Object)(creatorInfo != null ? Long.valueOf(creatorInfo.nodeId()) : null), (Object)platformTxn);
            return null;
        }
        if (creatorInfo == null || txnInfo.functionality() == HederaFunctionality.STATE_SIGNATURE_TRANSACTION) {
            return null;
        }
        TokenContextImpl tokenContext = new TokenContextImpl((Configuration)config, stack, consensusNow, (WritableEntityCounters)new WritableEntityIdStoreImpl(stack.getWritableStates("EntityIdService")));
        return new ParentTxn(txnInfo.functionality(), consensusNow, state, txnInfo, tokenContext, stack, preHandleResult, readableStoreFactory, (Configuration)config, creatorInfo);
    }

    public ParentTxn createSystemTxn(@NonNull State state, @NonNull NodeInfo creatorInfo, @NonNull Instant consensusNow, @NonNull TransactionType type, @NonNull AccountID payerId, @NonNull TransactionBody body) {
        Objects.requireNonNull(state);
        Objects.requireNonNull(creatorInfo);
        Objects.requireNonNull(consensusNow);
        Objects.requireNonNull(type);
        Objects.requireNonNull(payerId);
        Objects.requireNonNull(body);
        VersionedConfiguration config = this.configProvider.getConfiguration();
        SavepointStackImpl stack = this.createRootSavepointStack(state);
        ReadableStoreFactory readableStoreFactory = new ReadableStoreFactory(stack);
        HederaFunctionality functionality = ChildDispatchFactory.functionOfTxn(body);
        PreHandleResult preHandleResult = this.preHandleSystemTransaction(body, payerId, (Configuration)config, readableStoreFactory, creatorInfo, type);
        WritableEntityIdStoreImpl entityIdStore = new WritableEntityIdStoreImpl(stack.getWritableStates("EntityIdService"));
        TokenContextImpl tokenContext = new TokenContextImpl((Configuration)config, stack, consensusNow, (WritableEntityCounters)entityIdStore);
        return new ParentTxn(functionality, consensusNow, state, preHandleResult.txnInfoOrThrow(), tokenContext, stack, preHandleResult, readableStoreFactory, (Configuration)config, creatorInfo);
    }

    public Dispatch createDispatch(@NonNull ParentTxn parentTxn, @NonNull ExchangeRateSet exchangeRates) {
        Objects.requireNonNull(parentTxn);
        Objects.requireNonNull(exchangeRates);
        PreHandleResult preHandleResult = parentTxn.preHandleResult();
        DefaultKeyVerifier keyVerifier = new DefaultKeyVerifier((HederaConfig)parentTxn.config().getConfigData(HederaConfig.class), preHandleResult.getVerificationResults());
        HandleContext.TransactionCategory category = ParentTxnFactory.getTxnCategory(preHandleResult);
        StreamBuilder baseBuilder = parentTxn.initBaseBuilder(exchangeRates);
        return this.createDispatch(parentTxn, baseBuilder, keyVerifier, category);
    }

    public Dispatch createDispatch(@NonNull ParentTxn parentTxn, @NonNull StreamBuilder baseBuilder, @NonNull Predicate<Key> keyVerifierCallback, @NonNull HandleContext.TransactionCategory category) {
        Configuration config = parentTxn.config();
        AppKeyVerifier keyVerifier = ChildDispatchFactory.getKeyVerifier(keyVerifierCallback, config, Collections.emptySet());
        return this.createDispatch(parentTxn, baseBuilder, keyVerifier, category);
    }

    private Dispatch createDispatch(@NonNull ParentTxn parentTxn, @NonNull StreamBuilder baseBuilder, @NonNull AppKeyVerifier keyVerifier, @NonNull HandleContext.TransactionCategory transactionCategory) {
        long congestionMultiplier;
        Configuration config = parentTxn.config();
        TransactionInfo txnInfo = parentTxn.txnInfo();
        PreHandleResult preHandleResult = parentTxn.preHandleResult();
        SavepointStackImpl stack = parentTxn.stack();
        Instant consensusNow = parentTxn.consensusNow();
        NodeInfo creatorInfo = parentTxn.creatorInfo();
        TokenContextImpl tokenContextImpl = parentTxn.tokenContextImpl();
        WritableEntityIdStoreImpl entityIdStore = new WritableEntityIdStoreImpl(stack.getWritableStates("EntityIdService"));
        ReadableStoreFactory readableStoreFactory = new ReadableStoreFactory(stack);
        EntityNumGeneratorImpl entityNumGenerator = new EntityNumGeneratorImpl((WritableEntityIdStore)entityIdStore);
        WritableStoreFactory writableStoreFactory = new WritableStoreFactory(stack, this.serviceScopeLookup.getServiceName(txnInfo.txBody()), (WritableEntityCounters)entityIdStore);
        ServiceApiFactory serviceApiFactory = new ServiceApiFactory(stack, config, this.apiProviders, this.nodeFeeAccumulator);
        ResourcePriceCalculatorImpl priceCalculator = new ResourcePriceCalculatorImpl(consensusNow, txnInfo, this.feeManager, readableStoreFactory);
        StoreFactoryImpl storeFactory = new StoreFactoryImpl(readableStoreFactory, writableStoreFactory, serviceApiFactory);
        AppThrottleAdviser throttleAdvisor = new AppThrottleAdviser(this.networkUtilizationManager, consensusNow);
        FeeAccumulator feeAccumulator = new FeeAccumulator(serviceApiFactory.getApi(TokenServiceApi.class), (FeeStreamBuilder)baseBuilder, stack);
        DispatchHandleContext dispatchHandleContext = new DispatchHandleContext(consensusNow, creatorInfo, txnInfo, config, this.authorizer, (BlockRecordInfo)(this.streamMode != StreamMode.RECORDS ? this.blockStreamManager : this.blockRecordManager), priceCalculator, this.feeManager, this.appFeeCharging, storeFactory, Objects.requireNonNull(txnInfo.payerID()), keyVerifier, txnInfo.functionality(), preHandleResult.payerKey() == null ? Key.DEFAULT : preHandleResult.payerKey(), this.exchangeRateManager, stack, (EntityNumGenerator)entityNumGenerator, this.dispatcher, this.networkInfo, this.childDispatchFactory, this.dispatchProcessor, throttleAdvisor, feeAccumulator, HandleContext.DispatchMetadata.EMPTY_METADATA, this.transactionChecker, preHandleResult.innerResults(), this.preHandleWorkflow, transactionCategory);
        Fees fees = this.dispatcher.dispatchComputeFees(dispatchHandleContext);
        if (this.streamMode != StreamMode.RECORDS && (congestionMultiplier = this.feeManager.congestionMultiplierFor(txnInfo.txBody(), txnInfo.functionality(), storeFactory.asReadOnly())) > 1L) {
            baseBuilder.congestionMultiplier(congestionMultiplier);
        }
        return new RecordDispatch(baseBuilder, config, fees, txnInfo, Objects.requireNonNull(txnInfo.payerID()), readableStoreFactory, feeAccumulator, keyVerifier, creatorInfo, consensusNow, preHandleResult.getRequiredKeys(), preHandleResult.getHollowAccounts(), dispatchHandleContext, stack, transactionCategory, tokenContextImpl, preHandleResult, transactionCategory == HandleContext.TransactionCategory.SCHEDULED ? HandleContext.ConsensusThrottling.OFF : HandleContext.ConsensusThrottling.ON, null);
    }

    private SavepointStackImpl createRootSavepointStack(@NonNull State state) {
        VersionedConfiguration config = this.configProvider.getConfiguration();
        ConsensusConfig consensusConfig = (ConsensusConfig)config.getConfigData(ConsensusConfig.class);
        BlockStreamConfig blockStreamConfig = (BlockStreamConfig)config.getConfigData(BlockStreamConfig.class);
        return SavepointStackImpl.newRootStack(state, consensusConfig.handleMaxPrecedingRecords(), consensusConfig.handleMaxFollowingRecords(), this.boundaryStateChangeListener, this.immediateStateChangeListener, blockStreamConfig.streamMode());
    }

    private PreHandleResult preHandleSystemTransaction(@NonNull TransactionBody body, @NonNull AccountID payerId, @NonNull Configuration config, @NonNull ReadableStoreFactory readableStoreFactory, @NonNull NodeInfo creatorInfo, @NonNull TransactionType type) {
        if (type == TransactionType.INTERNAL_TRANSACTION) {
            return new PreHandleResult(payerId, null, PreHandleResult.Status.SO_FAR_SO_GOOD, ResponseCodeEnum.OK, ChildDispatchFactory.getTxnInfoFrom(payerId, body), Set.of(), Set.of(), Set.of(), Map.of(), null, 0L);
        }
        try {
            PureChecksContextImpl pureChecksContext = new PureChecksContextImpl(body, this.dispatcher);
            this.dispatcher.dispatchPureChecks(pureChecksContext);
            PreHandleContextImpl preHandleContext = new PreHandleContextImpl(readableStoreFactory, body, payerId, config, this.dispatcher, this.transactionChecker, creatorInfo);
            this.dispatcher.dispatchPreHandle(preHandleContext);
            TransactionInfo txInfo = ChildDispatchFactory.getTxnInfoFrom(payerId, body);
            return new PreHandleResult(null, null, PreHandleResult.Status.SO_FAR_SO_GOOD, ResponseCodeEnum.OK, txInfo, preHandleContext.requiredNonPayerKeys(), null, preHandleContext.requiredHollowAccounts(), null, null, 0L);
        }
        catch (PreCheckException e) {
            return new PreHandleResult(null, null, PreHandleResult.Status.PRE_HANDLE_FAILURE, e.responseCode(), null, Collections.emptySet(), null, Collections.emptySet(), null, null, 0L);
        }
    }
}

