/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network.protocol;

import com.swirlds.base.time.Time;
import com.swirlds.config.api.Configuration;
import com.swirlds.platform.heartbeats.HeartbeatPeerProtocol;
import com.swirlds.platform.network.NetworkMetrics;
import com.swirlds.platform.network.protocol.Protocol;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.Objects;
import org.hiero.consensus.gossip.config.SyncConfig;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.status.PlatformStatus;

public class HeartbeatProtocol
implements Protocol {
    private final Duration heartbeatPeriod;
    private final NetworkMetrics networkMetrics;
    private final Time time;

    public HeartbeatProtocol(@NonNull Duration heartbeatPeriod, @NonNull NetworkMetrics networkMetrics, @NonNull Time time) {
        this.heartbeatPeriod = Objects.requireNonNull(heartbeatPeriod);
        this.networkMetrics = Objects.requireNonNull(networkMetrics);
        this.time = Objects.requireNonNull(time);
    }

    public static HeartbeatProtocol create(@NonNull Configuration configuration, @NonNull Time time, @NonNull NetworkMetrics networkMetrics) {
        SyncConfig syncConfig = (SyncConfig)configuration.getConfigData(SyncConfig.class);
        return new HeartbeatProtocol(Duration.ofMillis(syncConfig.syncProtocolHeartbeatPeriod()), networkMetrics, time);
    }

    @Override
    @NonNull
    public HeartbeatPeerProtocol createPeerInstance(@NonNull NodeId peerId) {
        return new HeartbeatPeerProtocol(Objects.requireNonNull(peerId), this.heartbeatPeriod, this.networkMetrics, this.time);
    }

    @Override
    public void updatePlatformStatus(@NonNull PlatformStatus status) {
    }
}

