/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.signed;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.pbj.runtime.ParseException;
import com.swirlds.common.config.StateCommonConfig;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.SavedStateLoadedPayload;
import com.swirlds.platform.config.StateConfig;
import com.swirlds.platform.internal.SignedStateLoadingException;
import com.swirlds.platform.state.service.PlatformStateUtils;
import com.swirlds.platform.state.signed.HashedReservedSignedState;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.platform.state.snapshot.DeserializedSignedState;
import com.swirlds.platform.state.snapshot.SavedStateInfo;
import com.swirlds.platform.state.snapshot.SignedStateFilePath;
import com.swirlds.platform.state.snapshot.SignedStateFileReader;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.State;
import com.swirlds.state.StateLifecycleManager;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.crypto.ConsensusCryptoUtils;
import org.hiero.consensus.io.RecycleBin;
import org.hiero.consensus.model.node.NodeId;

public final class StartupStateUtils {
    private static final Logger logger = LogManager.getLogger(StartupStateUtils.class);

    private StartupStateUtils() {
    }

    @NonNull
    public static ReservedSignedState loadStateFile(@NonNull RecycleBin recycleBin, @NonNull NodeId selfId, @NonNull String mainClassName, @NonNull String swirldName, @NonNull SemanticVersion currentSoftwareVersion, @NonNull PlatformContext platformContext, @NonNull StateLifecycleManager stateLifecycleManager) {
        Configuration config = platformContext.getConfiguration();
        StateConfig stateConfig = (StateConfig)config.getConfigData(StateConfig.class);
        String actualMainClassName = stateConfig.getMainClassName(mainClassName);
        List<SavedStateInfo> savedStateFiles = new SignedStateFilePath((StateCommonConfig)config.getConfigData(StateCommonConfig.class)).getSavedStateFiles(actualMainClassName, selfId, swirldName);
        StartupStateUtils.logStatesFound(savedStateFiles);
        if (savedStateFiles.isEmpty()) {
            return ReservedSignedState.createNullReservation();
        }
        return StartupStateUtils.loadLatestState(recycleBin, currentSoftwareVersion, savedStateFiles, platformContext, stateLifecycleManager);
    }

    @NonNull
    public static HashedReservedSignedState copyInitialSignedState(@NonNull SignedState initialSignedState, @NonNull PlatformContext platformContext) {
        Objects.requireNonNull(platformContext);
        Objects.requireNonNull(platformContext.getConfiguration());
        Objects.requireNonNull(initialSignedState);
        MerkleNodeState stateCopy = initialSignedState.getState().copy();
        SignedState signedStateCopy = new SignedState(platformContext.getConfiguration(), ConsensusCryptoUtils::verifySignature, stateCopy, "StartupStateUtils: copy initial state", false, false, false);
        signedStateCopy.setSigSet(initialSignedState.getSigSet());
        Hash hash = initialSignedState.getState().getHash();
        return new HashedReservedSignedState(signedStateCopy.reserve("Copied initial state"), hash);
    }

    private static void logStatesFound(@NonNull List<SavedStateInfo> savedStateInfoList) {
        if (savedStateInfoList.isEmpty()) {
            logger.info(LogMarker.STARTUP.getMarker(), "No saved states were found on disk.");
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("The following saved states were found on disk:");
        for (SavedStateInfo savedStateInfo : savedStateInfoList) {
            sb.append("\n  - ").append(savedStateInfo.stateDirectory());
        }
        logger.info(LogMarker.STARTUP.getMarker(), sb.toString());
    }

    public static ReservedSignedState loadLatestState(@NonNull RecycleBin recycleBin, @NonNull SemanticVersion currentSoftwareVersion, @NonNull List<SavedStateInfo> savedStateList, @NonNull PlatformContext platformContext, @NonNull StateLifecycleManager stateLifecycleManager) throws SignedStateLoadingException {
        logger.info(LogMarker.STARTUP.getMarker(), "Loading latest state from disk.");
        for (SavedStateInfo savedStateInfo : savedStateList) {
            ReservedSignedState state = StartupStateUtils.loadStateFile(recycleBin, currentSoftwareVersion, savedStateInfo, platformContext, stateLifecycleManager);
            if (state == null) continue;
            return state;
        }
        logger.warn(LogMarker.STARTUP.getMarker(), "No valid saved states were found on disk. Starting from genesis.");
        return ReservedSignedState.createNullReservation();
    }

    @Nullable
    private static ReservedSignedState loadStateFile(@NonNull RecycleBin recycleBin, @NonNull SemanticVersion currentSoftwareVersion, @NonNull SavedStateInfo savedStateInfo, @NonNull PlatformContext platformContext, @NonNull StateLifecycleManager stateLifecycleManager) throws SignedStateLoadingException {
        DeserializedSignedState deserializedSignedState;
        logger.info(LogMarker.STARTUP.getMarker(), "Loading signed state from disk: {}", (Object)savedStateInfo.stateDirectory());
        Configuration configuration = platformContext.getConfiguration();
        try {
            deserializedSignedState = SignedStateFileReader.readState(savedStateInfo.stateDirectory(), platformContext, stateLifecycleManager);
        }
        catch (ParseException | IOException | UncheckedIOException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "unable to load state file {}", (Object)savedStateInfo.stateDirectory(), (Object)e);
            StateConfig stateConfig = (StateConfig)configuration.getConfigData(StateConfig.class);
            if (stateConfig.deleteInvalidStateFiles()) {
                StartupStateUtils.recycleState(recycleBin, savedStateInfo);
                return null;
            }
            throw new SignedStateLoadingException("unable to load state, this is unrecoverable", e);
        }
        MerkleNodeState state = deserializedSignedState.reservedSignedState().get().getState();
        Hash oldHash = deserializedSignedState.originalHash();
        Hash newHash = state.getRoot().getHash();
        SemanticVersion loadedVersion = PlatformStateUtils.creationSoftwareVersionOf((State)state);
        if (oldHash.equals((Object)newHash)) {
            logger.info(LogMarker.STARTUP.getMarker(), "Loaded state's hash is the same as when it was saved.");
        } else if (HapiUtils.SEMANTIC_VERSION_COMPARATOR.compare(loadedVersion, currentSoftwareVersion) == 0) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "The saved state {} was created with the current version of the software, but the state hash has changed. Unless the state was intentionally modified, this is a good indicator that there is probably a bug.", (Object)savedStateInfo.stateDirectory());
        } else {
            logger.warn(LogMarker.STARTUP.getMarker(), "The saved state {} was created with version {}, which is different than the current version {}. The hash of the loaded state is different than the hash of the state when it was first created, which is not abnormal if there have been data migrations.", (Object)savedStateInfo.stateDirectory(), (Object)loadedVersion, (Object)currentSoftwareVersion);
        }
        return deserializedSignedState.reservedSignedState();
    }

    private static void recycleState(@NonNull RecycleBin recycleBin, @NonNull SavedStateInfo stateInfo) {
        logger.warn(LogMarker.STARTUP.getMarker(), "Moving state {} to the recycle bin.", (Object)stateInfo.stateDirectory());
        try {
            recycleBin.recycle(stateInfo.stateDirectory());
        }
        catch (IOException e) {
            throw new UncheckedIOException("unable to recycle state", e);
        }
    }

    @NonNull
    public static HashedReservedSignedState loadInitialState(@NonNull RecycleBin recycleBin, @NonNull SemanticVersion softwareVersion, @NonNull Supplier<MerkleNodeState> stateRootSupplier, @NonNull String mainClassName, @NonNull String swirldName, @NonNull NodeId selfId, @NonNull PlatformContext platformContext, @NonNull StateLifecycleManager stateLifecycleManager) {
        ReservedSignedState reservedSignedState;
        ReservedSignedState loadedState;
        try (ReservedSignedState reservedSignedState2 = loadedState = StartupStateUtils.loadStateFile(recycleBin, selfId, mainClassName, swirldName, softwareVersion, platformContext, stateLifecycleManager);){
            if (loadedState.isNotNull()) {
                logger.info(LogMarker.STARTUP.getMarker(), (Object)new SavedStateLoadedPayload(loadedState.get().getRound(), loadedState.get().getConsensusTimestamp()));
                HashedReservedSignedState hashedReservedSignedState = StartupStateUtils.copyInitialSignedState(loadedState.get(), platformContext);
                return hashedReservedSignedState;
            }
        }
        MerkleNodeState stateRoot = stateRootSupplier.get();
        SignedState signedState = new SignedState(platformContext.getConfiguration(), ConsensusCryptoUtils::verifySignature, stateRoot, "genesis state", false, false, false);
        try (ReservedSignedState reservedSignedState3 = reservedSignedState = signedState.reserve("initial reservation on genesis state");){
            HashedReservedSignedState hashedReservedSignedState = StartupStateUtils.copyInitialSignedState(reservedSignedState.get(), platformContext);
            return hashedReservedSignedState;
        }
    }
}

