/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.file.impl.calculator;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.file.FileCreateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.ServiceFeeCalculator;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import org.hiero.hapi.fees.FeeKeyUtils;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.fees.FeeScheduleUtils;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.ServiceFeeDefinition;

public class FileCreateFeeCalculator
implements ServiceFeeCalculator {
    public void accumulateServiceFee(@NonNull TransactionBody txnBody, @Nullable FeeContext feeContext, @NonNull FeeResult feeResult, @NonNull FeeSchedule feeSchedule) {
        FileCreateTransactionBody op = txnBody.fileCreateOrThrow();
        long keyCount = 0L;
        if (op.hasKeys()) {
            keyCount = txnBody.fileCreateOrThrow().keys().keys().stream().mapToLong(FeeKeyUtils::countKeys).sum();
        }
        ServiceFeeDefinition serviceDef = FeeScheduleUtils.lookupServiceFee((FeeSchedule)feeSchedule, (HederaFunctionality)HederaFunctionality.FILE_CREATE);
        feeResult.setServiceBaseFeeTinycents(serviceDef.baseFee());
        this.addExtraFee(feeResult, serviceDef, Extra.KEYS, feeSchedule, keyCount);
        this.addExtraFee(feeResult, serviceDef, Extra.BYTES, feeSchedule, op.contents().length());
    }

    public TransactionBody.DataOneOfType getTransactionType() {
        return TransactionBody.DataOneOfType.FILE_CREATE;
    }
}

