/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.addressbook.impl.validators;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.hapi.utils.keys.KeyUtils;
import com.hedera.node.app.service.addressbook.AddressBookHelper;
import com.hedera.node.app.service.addressbook.ReadableAccountNodeRelStore;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.spi.validation.ExpiryValidator;
import com.hedera.node.app.spi.validation.Validations;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.config.data.NodesConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AddressBookValidator {
    @Inject
    public AddressBookValidator() {
    }

    public void validateDescription(@Nullable String description, @NonNull NodesConfig nodesConfig) {
        int maxUtf8Bytes;
        Objects.requireNonNull(nodesConfig);
        if (description == null || description.isEmpty()) {
            return;
        }
        byte[] raw = description.getBytes(StandardCharsets.UTF_8);
        HandleException.validateFalse((raw.length > (maxUtf8Bytes = nodesConfig.nodeMaxDescriptionUtf8Bytes()) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_NODE_DESCRIPTION);
        HandleException.validateFalse((boolean)this.containsZeroByte(raw), (ResponseCodeEnum)ResponseCodeEnum.INVALID_NODE_DESCRIPTION);
    }

    private boolean containsZeroByte(@NonNull byte[] bytes) {
        Objects.requireNonNull(bytes);
        boolean ret = false;
        for (byte b : bytes) {
            if (b != 0) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public void validateGossipEndpoint(@Nullable List<ServiceEndpoint> endpointList, @NonNull NodesConfig nodesConfig) {
        Objects.requireNonNull(nodesConfig);
        HandleException.validateFalse((endpointList == null || endpointList.isEmpty() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_GOSSIP_ENDPOINT);
        HandleException.validateFalse((endpointList.size() > nodesConfig.maxGossipEndpoint() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.GOSSIP_ENDPOINTS_EXCEEDED_LIMIT);
        for (ServiceEndpoint endpoint : endpointList) {
            HandleException.validateFalse((nodesConfig.gossipFqdnRestricted() && !endpoint.domainName().isEmpty() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.GOSSIP_ENDPOINT_CANNOT_HAVE_FQDN);
            this.validateEndpoint(endpoint, nodesConfig);
        }
    }

    public void validateServiceEndpoint(@Nullable List<ServiceEndpoint> endpointList, @NonNull NodesConfig nodesConfig) {
        Objects.requireNonNull(nodesConfig);
        HandleException.validateFalse((endpointList == null || endpointList.isEmpty() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_SERVICE_ENDPOINT);
        HandleException.validateFalse((endpointList.size() > nodesConfig.maxServiceEndpoint() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.SERVICE_ENDPOINTS_EXCEEDED_LIMIT);
        for (ServiceEndpoint endpoint : endpointList) {
            this.validateEndpoint(endpoint, nodesConfig);
        }
    }

    public void validateAdminKey(@Nullable Key key) throws PreCheckException {
        boolean keyEmpty = KeyUtils.isEmpty((Key)key);
        PreCheckException.validateFalsePreCheck((boolean)keyEmpty, (ResponseCodeEnum)ResponseCodeEnum.KEY_REQUIRED);
        PreCheckException.validateTruePreCheck((boolean)KeyUtils.isValid((Key)key), (ResponseCodeEnum)ResponseCodeEnum.INVALID_ADMIN_KEY);
    }

    public void validateAccountId(@Nullable AccountID accountId) throws PreCheckException {
        Validations.validateAccountID((AccountID)accountId, (ResponseCodeEnum)ResponseCodeEnum.INVALID_NODE_ACCOUNT_ID);
        PreCheckException.validateFalsePreCheck((!Objects.requireNonNull(accountId).hasAccountNum() && accountId.hasAlias() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_NODE_ACCOUNT_ID);
    }

    public Account validateAccount(@NonNull AccountID accountId, @NonNull ReadableAccountStore accountStore, @NonNull ReadableAccountNodeRelStore accountNodeRelStore, @NonNull ExpiryValidator expiryValidator) {
        Objects.requireNonNull(accountId);
        Objects.requireNonNull(accountStore);
        Objects.requireNonNull(accountNodeRelStore);
        Objects.requireNonNull(expiryValidator);
        Account account = accountStore.getAccountById(accountId);
        HandleException.validateTrue((account != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_NODE_ACCOUNT_ID);
        HandleException.validateFalse((boolean)account.deleted(), (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_DELETED);
        ResponseCodeEnum expiryStatus = expiryValidator.expirationStatus(EntityType.ACCOUNT, account.expiredAndPendingRemoval(), account.tinybarBalance());
        HandleException.validateTrue((expiryStatus == ResponseCodeEnum.OK ? 1 : 0) != 0, (ResponseCodeEnum)expiryStatus);
        HandleException.validateTrue((accountNodeRelStore.get(accountId) == null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_IS_LINKED_TO_A_NODE);
        return account;
    }

    public void validateEndpoint(@NonNull ServiceEndpoint endpoint, @NonNull NodesConfig nodesConfig) {
        Objects.requireNonNull(endpoint);
        Objects.requireNonNull(nodesConfig);
        HandleException.validateFalse((endpoint.port() == 0 ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ENDPOINT);
        long addressLen = endpoint.ipAddressV4().length();
        HandleException.validateFalse((addressLen == 0L && endpoint.domainName().trim().isEmpty() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ENDPOINT);
        HandleException.validateFalse((addressLen != 0L && !endpoint.domainName().trim().isEmpty() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.IP_FQDN_CANNOT_BE_SET_FOR_SAME_ENDPOINT);
        this.validateFqdnSize(endpoint, nodesConfig);
        HandleException.validateFalse((addressLen != 0L && addressLen != 4L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_IPV4_ADDRESS);
    }

    public void validateFqdnEndpoint(@NonNull ServiceEndpoint endpoint, @NonNull NodesConfig nodesConfig) {
        Objects.requireNonNull(endpoint);
        Objects.requireNonNull(nodesConfig);
        HandleException.validateFalse((boolean)endpoint.domainName().isEmpty(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_SERVICE_ENDPOINT);
        this.validateFqdnSize(endpoint, nodesConfig);
        HandleException.validateFalse((endpoint.ipAddressV4().length() > 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_SERVICE_ENDPOINT);
    }

    private void validateFqdnSize(@NonNull ServiceEndpoint endpoint, @NonNull NodesConfig nodesConfig) {
        HandleException.validateFalse((endpoint.domainName().trim().length() > nodesConfig.maxFqdnSize() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.FQDN_SIZE_TOO_LARGE);
    }

    public static void validateX509Certificate(@NonNull Bytes x509CertBytes) throws PreCheckException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            AddressBookHelper.writeCertificatePemFile((byte[])x509CertBytes.toByteArray(), (OutputStream)baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            X509Certificate cert = AddressBookHelper.readCertificatePemFile((InputStream)bais);
            cert.checkValidity();
        }
        catch (Exception ignore) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_GOSSIP_CA_CERTIFICATE);
        }
    }
}

