/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.scope;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.contract.ContractCreateTransactionBody;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.state.ContractStateStore;
import com.hedera.node.app.service.token.api.ContractChangeSummary;
import com.hedera.node.app.spi.fees.FeeCharging;
import com.hedera.node.app.spi.throttle.ThrottleAdviser;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import org.hyperledger.besu.datatypes.Address;

public interface HederaOperations {
    public static final ContractID MISSING_CONTRACT_ID = ContractID.newBuilder().contractNum(0L).build();

    @NonNull
    public HederaOperations begin();

    public void commit();

    public void revert();

    public ContractStateStore getStore();

    public long peekNextEntityNumber();

    public long useNextEntityNumber();

    public long contractCreationLimit();

    public long accountCreationLimit();

    @NonNull
    public Bytes entropy();

    public long lazyCreationCostInGas(@NonNull Address var1);

    public long gasPriceInTinybars();

    public long valueInTinybars(long var1);

    public void collectHtsFee(@NonNull AccountID var1, long var2);

    public void collectGasFee(@NonNull AccountID var1, long var2, boolean var4);

    public void refundGasFee(@NonNull AccountID var1, long var2);

    public void replayGasChargingIn(FeeCharging.Context var1);

    public void chargeStorageRent(ContractID var1, long var2, boolean var4);

    public void updateStorageMetadata(ContractID var1, @NonNull Bytes var2, int var3);

    public void updateLambdaStorageSlots(@NonNull AccountID var1, int var2, boolean var3);

    public void createContract(long var1, long var3, @Nullable Bytes var5);

    public void createContract(long var1, @NonNull ContractCreateTransactionBody var3, @Nullable Bytes var4);

    public void deleteAliasedContract(@NonNull Bytes var1);

    public void deleteUnaliasedContract(long var1);

    public List<Long> getModifiedAccountNumbers();

    public ContractChangeSummary summarizeContractChanges();

    public long getOriginalSlotsUsed(ContractID var1);

    public void externalizeHollowAccountMerge(@NonNull ContractID var1, @NonNull Bytes var2);

    public ContractID shardAndRealmValidated(@NonNull ContractID var1);

    default public ContractID configValidated(@NonNull ContractID contractId, @NonNull HederaConfig hederaConfig) {
        Objects.requireNonNull(contractId);
        Objects.requireNonNull(hederaConfig);
        return contractId.shardNum() == hederaConfig.shard() && contractId.realmNum() == hederaConfig.realm() ? contractId : MISSING_CONTRACT_ID;
    }

    @Nullable
    public ThrottleAdviser getThrottleAdviser();

    @Nullable
    public ContractMetrics contractMetrics();
}

