/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.util.FastHex;
import com.joemelsha.crypto.hash.Keccak;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public final class Address {
    static final int ADDRESS_BIT_LEN = 160;
    private static final int ADDRESS_DATA_BYTES = 20;
    private static final int ADDRESS_HEX_CHARS = 40;
    private static final int PREFIX_LEN = 2;
    private static final int ADDRESS_LEN_CHARS = 42;
    private static final int HEX_RADIX = 16;
    public static final int MAX_LABEL_LEN = 36;
    private final BigInteger value;
    private final String label;
    private static final byte[] LOWERCASE = new byte[256];
    private static final byte[] UPPERCASE = new byte[256];

    Address(BigInteger value) {
        this(value, null);
    }

    private Address(BigInteger value, String label) {
        this.value = value;
        this.label = label;
    }

    public BigInteger value() {
        return this.value;
    }

    public String getLabel() {
        return this.label;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Address) {
            Address other = (Address)o;
            return this.value.equals(other.value);
        }
        return false;
    }

    public String toString() {
        return Address.toChecksumAddress(this.value);
    }

    public static Address wrap(String checksumAddress) {
        return new Address(Address.validateAndDecodeAddress(checksumAddress));
    }

    public static Address wrap(String checksumAddress, String label) {
        if (label != null && label.length() > 36) {
            throw new IllegalArgumentException("label length exceeds maximum: " + label.length() + " > " + 36);
        }
        return new Address(Address.validateAndDecodeAddress(checksumAddress), label);
    }

    private static BigInteger validateAndDecodeAddress(String checksumAddress) {
        Address.validateChecksumAddress(checksumAddress);
        return new BigInteger(1, FastHex.decode(checksumAddress, 2, 40));
    }

    public Address withLabel(String label) {
        if (this.label != null) {
            throw new IllegalArgumentException("labeling aborted because existing label not null");
        }
        return new Address(this.value, label);
    }

    public static void validateChecksumAddress(String checksumAddress) {
        if (Address.toChecksumAddress(checksumAddress).equals(checksumAddress)) {
            return;
        }
        throw new IllegalArgumentException("invalid checksum");
    }

    public static String toChecksumAddress(BigInteger address) {
        String minimalHex = address.toString(16);
        int len = minimalHex.length();
        int start = 42 - len;
        if (start < 2) {
            throw new IllegalArgumentException("invalid bit length: " + address.bitLength());
        }
        byte[] addressBytes = "0x0000000000000000000000000000000000000000".getBytes(StandardCharsets.US_ASCII);
        minimalHex.getBytes(0, len, addressBytes, start);
        return Address.doChecksum(addressBytes);
    }

    public static String toChecksumAddress(String address) {
        if (address.length() == 42) {
            Address.checkPrefix(address);
            byte[] addressBytes = "0x0000000000000000000000000000000000000000".getBytes(StandardCharsets.US_ASCII);
            for (int i = 2; i < addressBytes.length; ++i) {
                byte val = LOWERCASE[address.charAt(i)];
                if (val == 0) {
                    throw new IllegalArgumentException("illegal hex val @ " + i);
                }
                addressBytes[i] = val;
            }
            return Address.doChecksum(addressBytes);
        }
        if (address.length() >= 2) {
            Address.checkPrefix(address);
        }
        throw new IllegalArgumentException("expected address length 42; actual is " + address.length());
    }

    private static void checkPrefix(String address) {
        if (!address.startsWith("0x")) {
            throw new IllegalArgumentException("missing 0x prefix");
        }
    }

    private static String doChecksum(byte[] addressBytes) {
        Keccak keccak256 = new Keccak(256);
        keccak256.update(addressBytes, 2, 40);
        boolean offset = true;
        byte[] buffer = new byte[21];
        keccak256.digest(ByteBuffer.wrap(buffer, 1, 20));
        byte[] hash = FastHex.encodeToBytes(buffer);
        for (int i = 2; i < addressBytes.length; ++i) {
            switch (hash[i]) {
                case 56: 
                case 57: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    addressBytes[i] = UPPERCASE[addressBytes[i]];
                }
            }
        }
        return new String(addressBytes, 0, 0, addressBytes.length);
    }

    static {
        String lowers = "abcdef";
        String uppers = "ABCDEF";
        String nums = "0123456789";
        for (int i = 0; i < nums.length(); ++i) {
            char d = nums.charAt(i);
            Address.LOWERCASE[d] = (byte)d;
            Address.UPPERCASE[d] = (byte)d;
            if (i >= lowers.length()) continue;
            char lo = lowers.charAt(i);
            char hi = uppers.charAt(i);
            Address.LOWERCASE[lo] = (byte)lo;
            Address.LOWERCASE[hi] = (byte)lo;
            Address.UPPERCASE[lo] = (byte)hi;
            Address.UPPERCASE[hi] = (byte)hi;
        }
    }
}

