/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.types;

import io.helidon.common.types.ElementSignature;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNameBlueprint;
import io.helidon.common.types.TypeNames;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

final class ElementSignatures {
    private ElementSignatures() {
    }

    static ElementSignature createNone() {
        return new NoSignature();
    }

    static ElementSignature createField(TypeName type, String name) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(name);
        return new FieldSignature(type, name);
    }

    static ElementSignature createConstructor(List<TypeName> parameters) {
        Objects.requireNonNull(parameters);
        return new MethodSignature(TypeNames.PRIMITIVE_VOID, "<init>", parameters);
    }

    static ElementSignature createMethod(TypeName returnType, String name, List<TypeName> parameters) {
        Objects.requireNonNull(returnType);
        Objects.requireNonNull(name);
        Objects.requireNonNull(parameters);
        return new MethodSignature(returnType, name, parameters);
    }

    static ElementSignature createParameter(TypeName type, String name) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(name);
        return new ParameterSignature(type, name);
    }

    private static String parameterTypesSection(List<TypeName> parameters, String delimiter, Function<TypeName, String> typeMapper) {
        return parameters.stream().map(typeMapper).collect(Collectors.joining(delimiter, "(", ")"));
    }

    static final class NoSignature
    implements ElementSignature {
        NoSignature() {
        }

        @Override
        public TypeName type() {
            return TypeNames.PRIMITIVE_VOID;
        }

        @Override
        public String name() {
            return "<INVALID>";
        }

        @Override
        public String text() {
            return "<INVALID>";
        }

        public String toString() {
            return this.text();
        }

        @Override
        public List<TypeName> parameterTypes() {
            return List.of();
        }
    }

    static final class FieldSignature
    implements ElementSignature {
        private final TypeName type;
        private final String name;

        private FieldSignature(TypeName type, String name) {
            this.type = type;
            this.name = name;
        }

        @Override
        public TypeName type() {
            return this.type;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public List<TypeName> parameterTypes() {
            return List.of();
        }

        @Override
        public String text() {
            return this.name;
        }

        public String toString() {
            return this.type.resolvedName() + " " + this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldSignature)) {
                return false;
            }
            FieldSignature that = (FieldSignature)o;
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hashCode(this.name);
        }
    }

    static final class MethodSignature
    implements ElementSignature {
        private final TypeName type;
        private final String name;
        private final List<TypeName> parameters;
        private final String text;
        private final boolean constructor;

        private MethodSignature(TypeName type, String name, List<TypeName> parameters) {
            this.type = type;
            this.name = name;
            this.parameters = parameters;
            if (name.equals("<init>")) {
                this.constructor = true;
                this.text = ElementSignatures.parameterTypesSection(parameters, ",", TypeNameBlueprint::fqName);
            } else {
                this.constructor = false;
                this.text = name + ElementSignatures.parameterTypesSection(parameters, ",", TypeNameBlueprint::fqName);
            }
        }

        @Override
        public TypeName type() {
            return this.type;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public List<TypeName> parameterTypes() {
            return this.parameters;
        }

        @Override
        public String text() {
            return this.text;
        }

        public String toString() {
            if (this.constructor) {
                return this.text;
            }
            return this.type.resolvedName() + " " + this.name + ElementSignatures.parameterTypesSection(this.parameters, ", ", TypeNameBlueprint::resolvedName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodSignature)) {
                return false;
            }
            MethodSignature that = (MethodSignature)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.parameters, that.parameters);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.parameters);
        }
    }

    static final class ParameterSignature
    implements ElementSignature {
        private final TypeName type;
        private final String name;

        private ParameterSignature(TypeName type, String name) {
            this.type = type;
            this.name = name;
        }

        @Override
        public TypeName type() {
            return this.type;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public List<TypeName> parameterTypes() {
            return List.of();
        }

        @Override
        public String text() {
            return this.name;
        }

        public String toString() {
            return this.type.resolvedName() + " " + this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParameterSignature)) {
                return false;
            }
            ParameterSignature that = (ParameterSignature)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hashCode(this.name);
        }
    }
}

