/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl;

import com.hedera.hapi.node.base.PendingAirdropId;
import com.hedera.hapi.node.state.token.AccountPendingAirdrop;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.service.entityid.ReadableEntityCounters;
import com.hedera.node.app.service.entityid.WritableEntityCounters;
import com.hedera.node.app.service.token.impl.ReadableAirdropStoreImpl;
import com.hedera.node.app.service.token.impl.schemas.V0530TokenSchema;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class WritableAirdropStore
extends ReadableAirdropStoreImpl {
    private final WritableKVState<PendingAirdropId, AccountPendingAirdrop> airdropState;
    private final WritableEntityCounters entityCounters;

    public WritableAirdropStore(@NonNull WritableStates states, @NonNull WritableEntityCounters entityCounters) {
        super((ReadableStates)states, (ReadableEntityCounters)entityCounters);
        this.airdropState = states.get(V0530TokenSchema.AIRDROPS_STATE_ID);
        this.entityCounters = entityCounters;
    }

    public void put(@NonNull PendingAirdropId airdropId, @NonNull AccountPendingAirdrop accountAirdrop) {
        Objects.requireNonNull(airdropId);
        Objects.requireNonNull(accountAirdrop);
        this.airdropState.put((Object)airdropId, (Object)accountAirdrop);
    }

    public void putAndIncrementCount(@NonNull PendingAirdropId airdropId, @NonNull AccountPendingAirdrop accountAirdrop) {
        this.put(airdropId, accountAirdrop);
        this.entityCounters.incrementEntityTypeCount(EntityType.AIRDROP);
    }

    public void remove(@NonNull PendingAirdropId airdropId) {
        this.airdropState.remove((Object)Objects.requireNonNull(airdropId));
        this.entityCounters.decrementEntityTypeCounter(EntityType.AIRDROP);
    }

    public boolean contains(PendingAirdropId pendingId) {
        return this.airdropState.contains((Object)pendingId);
    }
}

