/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.throttle;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.node.app.spi.throttle.ThrottleAdviser;
import com.hedera.node.app.throttle.NetworkUtilizationManager;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.Objects;

public class AppThrottleAdviser
implements ThrottleAdviser {
    private final NetworkUtilizationManager networkUtilizationManager;
    private final Instant consensusNow;

    public AppThrottleAdviser(@NonNull NetworkUtilizationManager networkUtilizationManager, @NonNull Instant consensusNow) {
        this.networkUtilizationManager = Objects.requireNonNull(networkUtilizationManager);
        this.consensusNow = Objects.requireNonNull(consensusNow);
    }

    public boolean shouldThrottleNOfUnscaled(int n, @NonNull HederaFunctionality function) {
        Objects.requireNonNull(function);
        return this.networkUtilizationManager.shouldThrottleNOfUnscaled(n, function, this.consensusNow);
    }

    public long availableOpsDurationCapacity() {
        return this.networkUtilizationManager.availableOpsDurationCapacity(this.consensusNow);
    }

    public void consumeOpsDurationThrottleCapacity(long opsDurationUnitsToConsume) {
        this.networkUtilizationManager.consumeOpsDurationThrottleCapacity(opsDurationUnitsToConsume, this.consensusNow);
    }
}

