/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.contracts;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.HookEntityId;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.hooks.LambdaMappingEntry;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.node.app.hapi.utils.MiscCryptoUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class HookUtils {
    public static Bytes minimalRepresentationOf(@NonNull Bytes bytes) {
        int i;
        int n = (int)bytes.length();
        for (i = 0; i < n && bytes.getByte((long)i) == 0; ++i) {
        }
        if (i == n) {
            return Bytes.EMPTY;
        }
        if (i == 0) {
            return bytes;
        }
        return bytes.slice((long)i, (long)(n - i));
    }

    public static Bytes slotKeyOfMappingEntry(@NonNull Bytes leftPaddedMappingSlot, @NonNull LambdaMappingEntry entry) {
        Bytes hK = entry.hasKey() ? HookUtils.leftPad32(entry.keyOrThrow()) : MiscCryptoUtils.keccak256DigestOf(entry.preimageOrThrow());
        return MiscCryptoUtils.keccak256DigestOf(hK.append(leftPaddedMappingSlot));
    }

    public static Bytes leftPad32(@NonNull Bytes bytes) {
        Objects.requireNonNull(bytes);
        int n = (int)bytes.length();
        if (n == 32) {
            return bytes;
        }
        byte[] padded = new byte[32];
        bytes.getBytes(0L, padded, 32 - n, n);
        return Bytes.wrap((byte[])padded);
    }

    public static boolean hasHookExecutions(@NonNull CryptoTransferTransactionBody op) {
        for (AccountAmount aa : op.transfersOrElse(TransferList.DEFAULT).accountAmounts()) {
            if (!aa.hasPreTxAllowanceHook() && !aa.hasPrePostTxAllowanceHook()) continue;
            return true;
        }
        for (TokenTransferList ttl : op.tokenTransfers()) {
            for (AccountAmount aa : ttl.transfers()) {
                if (!aa.hasPreTxAllowanceHook() && !aa.hasPrePostTxAllowanceHook()) continue;
                return true;
            }
            for (NftTransfer nft : ttl.nftTransfers()) {
                if (!nft.hasPreTxSenderAllowanceHook() && !nft.hasPrePostTxSenderAllowanceHook() && !nft.hasPreTxReceiverAllowanceHook() && !nft.hasPrePostTxReceiverAllowanceHook()) continue;
                return true;
            }
        }
        return false;
    }

    public static AccountID getHookOwnerId(@NonNull HookEntityId hookEntityId) {
        return Objects.requireNonNull(hookEntityId).hasAccountId() ? hookEntityId.accountIdOrThrow() : HookUtils.asAccountId(hookEntityId.contractIdOrThrow());
    }

    public static AccountID asAccountId(@NonNull ContractID contractID) {
        Objects.requireNonNull(contractID);
        return AccountID.newBuilder().shardNum(contractID.shardNum()).realmNum(contractID.realmNum()).accountNum(contractID.contractNumOrThrow().longValue()).build();
    }
}

