/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.forensics;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.FileID;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.CommonUtils;
import com.hedera.node.app.hapi.utils.forensics.TransactionParts;
import com.hedera.services.stream.proto.RecordStreamItem;
import com.hederahashgraph.api.proto.java.HederaFunctionality;
import com.hederahashgraph.api.proto.java.ResponseCodeEnum;
import com.hederahashgraph.api.proto.java.ScheduleID;
import com.hederahashgraph.api.proto.java.Transaction;
import com.hederahashgraph.api.proto.java.TransactionBody;
import com.hederahashgraph.api.proto.java.TransactionID;
import com.hederahashgraph.api.proto.java.TransactionRecord;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;

public record RecordStreamEntry(TransactionParts parts, TransactionRecord txnRecord, Instant consensusTime) implements Comparable<RecordStreamEntry>
{
    @Override
    public int compareTo(@NonNull RecordStreamEntry that) {
        return this.consensusTime.compareTo(that.consensusTime);
    }

    public static RecordStreamEntry from(@NonNull RecordStreamItem item) {
        TransactionRecord itemRecord = item.getRecord();
        return new RecordStreamEntry(TransactionParts.from(item.getTransaction()), itemRecord, CommonUtils.timestampToInstant(itemRecord.getConsensusTimestamp()));
    }

    public Transaction submittedTransaction() {
        return this.parts.wrapper();
    }

    public TransactionBody body() {
        return this.parts.body();
    }

    public ResponseCodeEnum finalStatus() {
        return this.txnRecord.getReceipt().getStatus();
    }

    public AccountID createdAccountId() {
        return CommonPbjConverters.toPbj(this.txnRecord.getReceipt().getAccountID());
    }

    public FileID createdFileId() {
        return CommonPbjConverters.toPbj(this.txnRecord.getReceipt().getFileID());
    }

    public ScheduleID createdScheduleId() {
        return this.txnRecord.getReceipt().getScheduleID();
    }

    public TransactionID scheduledTransactionId() {
        return this.txnRecord.getReceipt().getScheduledTransactionID();
    }

    public HederaFunctionality function() {
        return this.parts.function();
    }

    public TransactionRecord transactionRecord() {
        return this.txnRecord;
    }

    public Instant parentConsensusTimestamp() {
        return CommonUtils.timestampToInstant(this.txnRecord.getParentConsensusTimestamp());
    }

    public TransactionID txnId() {
        return this.txnRecord.getTransactionID();
    }

    @Override
    public String toString() {
        return String.format("RecordStreamEntry{consensusTime=%s, txn=%s, record=%s}", this.consensusTime, this.body(), this.txnRecord);
    }
}

