/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.hapi.fees;

import com.hedera.hapi.node.base.HederaFunctionality;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hiero.hapi.fees.FeeModel;
import org.hiero.hapi.fees.apis.common.StandardFeeModel;

public class FeeModelRegistry {
    private static final Map<HederaFunctionality, FeeModel> registry = new LinkedHashMap<HederaFunctionality, FeeModel>();

    private static void register(FeeModel feeModel) {
        registry.put(feeModel.getApi(), feeModel);
    }

    public static FeeModel lookupModel(HederaFunctionality service) {
        if (!registry.containsKey(service)) {
            throw new IllegalArgumentException("No registered model found for service " + service.protoName());
        }
        return registry.get(service);
    }

    static {
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.CONSENSUS_CREATE_TOPIC, "Create a new topic"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.CONSENSUS_UPDATE_TOPIC, "Update topic"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.CONSENSUS_DELETE_TOPIC, "Delete topic"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.CONSENSUS_GET_TOPIC_INFO, "Get metadata for a topic"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.CONSENSUS_SUBMIT_MESSAGE, "Submit message to topic"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.FILE_CREATE, "Create file"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.FILE_APPEND, "Append to file"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.FILE_UPDATE, "Update file"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.FILE_DELETE, "Delete file"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.FILE_GET_CONTENTS, "Get file contents"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.FILE_GET_INFO, "Get file info"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.CRYPTO_TRANSFER, "Transfer tokens among accounts"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.CRYPTO_UPDATE, "Update an account"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.CRYPTO_DELETE, "Delete an account"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.CRYPTO_CREATE, "Create a new account"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.CRYPTO_APPROVE_ALLOWANCE, "Approve an allowance for a spender"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.CRYPTO_DELETE_ALLOWANCE, "Delete an allowance for a spender"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.CONTRACT_CALL, "Execute a smart contract call"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.CONTRACT_CREATE, "Create a smart contract"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.CONTRACT_UPDATE, "Update a smart contract"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.CONTRACT_GET_INFO, "Get information about a smart contract"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.CONTRACT_GET_BYTECODE, "Get the compiled bytecode for a smart contract"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.CONTRACT_DELETE, "Delete a smart contract"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.TOKEN_CREATE, "Create a token"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.TOKEN_GET_INFO, "Get metadata for a token"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.TOKEN_FREEZE_ACCOUNT, "Freeze a specific account with respect to a token"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.TOKEN_UNFREEZE_ACCOUNT, "Unfreeze a specific account with respect to a token"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.TOKEN_GRANT_KYC_TO_ACCOUNT, "Grant KYC status to an account for a specific token"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.TOKEN_REVOKE_KYC_FROM_ACCOUNT, "Revoke KYC status from an account for a specific token"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.TOKEN_DELETE, "Delete a specific token"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.TOKEN_UPDATE, "Update a specific token"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.TOKEN_MINT, "Mint tokens"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.TOKEN_BURN, "Burn tokens"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.TOKEN_ACCOUNT_WIPE, "Wipe all amounts for a specific token"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.TOKEN_ASSOCIATE_TO_ACCOUNT, "Associate account to a specific token"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.TOKEN_DISSOCIATE_FROM_ACCOUNT, "Dissociate account from a specific token"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.TOKEN_PAUSE, "Pause a specific token"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.TOKEN_UNPAUSE, "Unpause a specific token"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.TOKEN_UPDATE_NFTS, "Update metadata of an NFT token"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.TOKEN_REJECT, "Reject a token"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.TOKEN_AIRDROP, "Airdrop one or more tokens"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.TOKEN_CANCEL_AIRDROP, "Cancel pending airdrops"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.TOKEN_CLAIM_AIRDROP, "Claim pending airdrops"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.SCHEDULE_CREATE, "Create a scheduled transaction"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.SCHEDULE_DELETE, "Delete a scheduled transaction"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.SCHEDULE_SIGN, "Sign a scheduled transaction"));
        FeeModelRegistry.register(new StandardFeeModel(HederaFunctionality.SCHEDULE_GET_INFO, "Get metadata for a scheduled transaction"));
    }
}

