/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common;

import io.helidon.common.LazyValue;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.Semaphore;
import java.util.function.Supplier;

class LazyValueImpl<T>
implements LazyValue<T> {
    private static final VarHandle THE_LOCK;
    private static final VarHandle LOADED;
    private T value;
    private Supplier<T> delegate;
    private volatile Semaphore theLock;
    private volatile int loaded;
    private static final int DONE = -1;
    private static final int INIT = 0;
    private static final int WORKING = 1;

    LazyValueImpl(T value) {
        this.value = value;
        this.loaded = -1;
    }

    LazyValueImpl(Supplier<T> supplier) {
        this.delegate = supplier;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        int loadedCopy = this.loaded;
        if (loadedCopy == -1) {
            return this.value;
        }
        Semaphore theLockCopy = this.theLock;
        while (loadedCopy != -1 && !LOADED.compareAndSet(this, 0, 1)) {
            if (theLockCopy == null) {
                THE_LOCK.compareAndSet(this, null, new Semaphore(0));
                theLockCopy = this.theLock;
            }
            if ((loadedCopy = this.loaded) != 1) continue;
            theLockCopy.acquireUninterruptibly();
            loadedCopy = this.loaded;
        }
        try {
            if (loadedCopy == -1) {
                T t = this.value;
                return t;
            }
            loadedCopy = 0;
            this.value = this.delegate.get();
            this.delegate = null;
            loadedCopy = -1;
            this.loaded = -1;
        }
        finally {
            if (loadedCopy == 0) {
                this.loaded = 0;
            }
            if ((theLockCopy = this.theLock) != null) {
                theLockCopy.release();
            }
        }
        return this.value;
    }

    static {
        try {
            THE_LOCK = MethodHandles.lookup().findVarHandle(LazyValueImpl.class, "theLock", Semaphore.class);
            LOADED = MethodHandles.lookup().findVarHandle(LazyValueImpl.class, "loaded", Integer.TYPE);
        }
        catch (Exception e) {
            throw new Error("Unable to obtain VarHandle's", e);
        }
    }
}

