/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.spi.validation;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.transaction.CustomFeeLimit;
import com.hedera.hapi.node.transaction.FixedFee;
import com.hedera.node.app.spi.workflows.PreCheckException;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class PreCheckValidator {
    private static final List<HederaFunctionality> FUNCTIONALITIES_WITH_MAX_CUSTOM_FEES = List.of(HederaFunctionality.CONSENSUS_SUBMIT_MESSAGE);

    private PreCheckValidator() {
    }

    public static void checkMemo(@Nullable String memo, int maxMemoUtf8Bytes) throws PreCheckException {
        if (memo == null) {
            return;
        }
        byte[] buffer = memo.getBytes(StandardCharsets.UTF_8);
        if (buffer.length > maxMemoUtf8Bytes) {
            throw new PreCheckException(ResponseCodeEnum.MEMO_TOO_LONG);
        }
        for (byte b : buffer) {
            if (b != 0) continue;
            throw new PreCheckException(ResponseCodeEnum.INVALID_ZERO_BYTE_IN_STRING);
        }
    }

    public static void checkMaxCustomFees(List<CustomFeeLimit> maxCustomFeeList, HederaFunctionality functionality) throws PreCheckException {
        if (!FUNCTIONALITIES_WITH_MAX_CUSTOM_FEES.contains(functionality) && !maxCustomFeeList.isEmpty()) {
            throw new PreCheckException(ResponseCodeEnum.MAX_CUSTOM_FEES_IS_NOT_SUPPORTED);
        }
        for (CustomFeeLimit maxCustomFee : maxCustomFeeList) {
            if (maxCustomFee.accountId() == null || maxCustomFee.fees().isEmpty()) {
                throw new PreCheckException(ResponseCodeEnum.INVALID_MAX_CUSTOM_FEES);
            }
            for (FixedFee fee : maxCustomFee.fees()) {
                if (fee.amount() >= 0L) continue;
                throw new PreCheckException(ResponseCodeEnum.INVALID_MAX_CUSTOM_FEES);
            }
        }
    }
}

