/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.bytes;

import org.apache.tuweni.bytes.Bytes48;
import org.apache.tuweni.bytes.Checks;
import org.apache.tuweni.bytes.DelegatingMutableBytes48;
import org.apache.tuweni.bytes.MutableArrayWrappingBytes48;
import org.apache.tuweni.bytes.MutableBytes;

public interface MutableBytes48
extends MutableBytes,
Bytes48 {
    public static MutableBytes48 create() {
        return new MutableArrayWrappingBytes48(new byte[48]);
    }

    public static MutableBytes48 wrap(byte[] value) {
        Checks.checkNotNull(value);
        return new MutableArrayWrappingBytes48(value);
    }

    public static MutableBytes48 wrap(byte[] value, int offset) {
        Checks.checkNotNull(value);
        return new MutableArrayWrappingBytes48(value, offset);
    }

    public static MutableBytes48 wrap(MutableBytes value) {
        Checks.checkNotNull(value);
        if (value instanceof MutableBytes48) {
            return (MutableBytes48)value;
        }
        return DelegatingMutableBytes48.delegateTo(value);
    }

    public static MutableBytes48 wrap(MutableBytes value, int offset) {
        Checks.checkNotNull(value);
        if (value instanceof MutableBytes48) {
            return (MutableBytes48)value;
        }
        MutableBytes slice = value.mutableSlice(offset, 48);
        if (slice instanceof MutableBytes48) {
            return (MutableBytes48)slice;
        }
        return DelegatingMutableBytes48.delegateTo(slice);
    }
}

