/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.validators;

import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.node.app.hapi.utils.keys.KeyUtils;
import com.hedera.node.app.spi.validation.AttributeValidator;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.config.data.TokensConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TokenAttributesValidator {
    @Inject
    public TokenAttributesValidator() {
    }

    public void validateTokenSymbol(@Nullable String symbol, @NonNull TokensConfig tokensConfig) {
        this.tokenStringCheck(symbol, tokensConfig.maxSymbolUtf8Bytes(), ResponseCodeEnum.MISSING_TOKEN_SYMBOL, ResponseCodeEnum.TOKEN_SYMBOL_TOO_LONG);
    }

    public void validateTokenName(@Nullable String name, @NonNull TokensConfig tokensConfig) {
        this.tokenStringCheck(name, tokensConfig.maxTokenNameUtf8Bytes(), ResponseCodeEnum.MISSING_TOKEN_NAME, ResponseCodeEnum.TOKEN_NAME_TOO_LONG);
    }

    public void validateTokenMetadata(@NonNull Bytes metadata, @NonNull TokensConfig tokensConfig) {
        if (metadata.length() > 0L) {
            HandleException.validateTrue((metadata.length() <= (long)tokensConfig.tokensMaxMetadataBytes() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.METADATA_TOO_LONG);
        }
    }

    private void tokenStringCheck(@Nullable String s, int maxLen, @NonNull ResponseCodeEnum onMissing, @NonNull ResponseCodeEnum onTooLong) {
        HandleException.validateTrue((s != null ? 1 : 0) != 0, (ResponseCodeEnum)onMissing);
        int numUtf8Bytes = s.getBytes(StandardCharsets.UTF_8).length;
        HandleException.validateTrue((numUtf8Bytes != 0 ? 1 : 0) != 0, (ResponseCodeEnum)onMissing);
        HandleException.validateTrue((numUtf8Bytes <= maxLen ? 1 : 0) != 0, (ResponseCodeEnum)onTooLong);
        HandleException.validateTrue((!s.contains("\u0000") ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ZERO_BYTE_IN_STRING);
    }

    public void validateTokenKeys(boolean hasAdminKey, @Nullable Key adminKey, boolean hasKycKey, @Nullable Key kycKey, boolean hasWipeKey, @Nullable Key wipeKey, boolean hasSupplyKey, @Nullable Key supplyKey, boolean hasFreezeKey, @Nullable Key freezeKey, boolean hasFeeScheduleKey, @Nullable Key feeScheduleKey, boolean hasPauseKey, @Nullable Key pauseKey, boolean hasMetadataKey, @Nullable Key metadataKey) {
        if (hasAdminKey && !AttributeValidator.isKeyRemoval((Key)adminKey)) {
            HandleException.validateTrue((boolean)KeyUtils.isValid((Key)adminKey), (ResponseCodeEnum)ResponseCodeEnum.INVALID_ADMIN_KEY);
        }
        if (hasKycKey && !AttributeValidator.isKeyRemoval((Key)kycKey)) {
            HandleException.validateTrue((boolean)KeyUtils.isValid((Key)kycKey), (ResponseCodeEnum)ResponseCodeEnum.INVALID_KYC_KEY);
        }
        if (hasWipeKey && !AttributeValidator.isKeyRemoval((Key)wipeKey)) {
            HandleException.validateTrue((boolean)KeyUtils.isValid((Key)wipeKey), (ResponseCodeEnum)ResponseCodeEnum.INVALID_WIPE_KEY);
        }
        if (hasSupplyKey && !AttributeValidator.isKeyRemoval((Key)supplyKey)) {
            HandleException.validateTrue((boolean)KeyUtils.isValid((Key)supplyKey), (ResponseCodeEnum)ResponseCodeEnum.INVALID_SUPPLY_KEY);
        }
        if (hasFreezeKey && !AttributeValidator.isKeyRemoval((Key)freezeKey)) {
            HandleException.validateTrue((boolean)KeyUtils.isValid((Key)freezeKey), (ResponseCodeEnum)ResponseCodeEnum.INVALID_FREEZE_KEY);
        }
        if (hasFeeScheduleKey && !AttributeValidator.isKeyRemoval((Key)feeScheduleKey)) {
            HandleException.validateTrue((boolean)KeyUtils.isValid((Key)feeScheduleKey), (ResponseCodeEnum)ResponseCodeEnum.INVALID_CUSTOM_FEE_SCHEDULE_KEY);
        }
        if (hasPauseKey && !AttributeValidator.isKeyRemoval((Key)pauseKey)) {
            HandleException.validateTrue((boolean)KeyUtils.isValid((Key)pauseKey), (ResponseCodeEnum)ResponseCodeEnum.INVALID_PAUSE_KEY);
        }
        if (hasMetadataKey && !AttributeValidator.isKeyRemoval((Key)metadataKey)) {
            HandleException.validateTrue((boolean)KeyUtils.isValid((Key)metadataKey), (ResponseCodeEnum)ResponseCodeEnum.INVALID_METADATA_KEY);
        }
    }
}

