/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token;

import com.esaulpaugh.headlong.abi.Function;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.EvmHookCall;
import com.hedera.hapi.node.base.HookEntityId;
import com.hedera.hapi.node.base.HookId;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.contract.ContractCallTransactionBody;
import com.hedera.hapi.node.hooks.HookCreation;
import com.hedera.hapi.node.hooks.HookCreationDetails;
import com.hedera.hapi.node.hooks.HookDispatchTransactionBody;
import com.hedera.hapi.node.hooks.HookExecution;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.token.records.HookDispatchStreamBuilder;
import com.hedera.node.app.spi.workflows.DispatchOptions;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UncheckedParseException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class HookDispatchUtils {
    private static final HandleContext.DispatchMetadata GROUP_METADATA = new HandleContext.DispatchMetadata(Map.of(HandleContext.DispatchMetadata.Type.EXPLICIT_WRITE_TRACING, true));
    public static final long HTS_HOOKS_CONTRACT_NUM = 365L;
    public static final String HTS_HOOKS_EVM_ADDRESS = "0x" + Long.toHexString(365L);

    @Nullable
    public static Long dispatchHookDeletions(@NonNull HandleContext context, @NonNull List<Long> hooksToDelete, @Nullable Long headBefore, @NonNull HookEntityId hookEntityId) {
        Long currentHead = headBefore;
        for (Long hookId : hooksToDelete) {
            Objects.requireNonNull(hookId);
            HookDispatchTransactionBody hookDispatch = HookDispatchTransactionBody.newBuilder().hookIdToDelete(new HookId(hookEntityId, hookId.longValue())).build();
            HookDispatchStreamBuilder streamBuilder = (HookDispatchStreamBuilder)context.dispatch(DispatchOptions.hookDispatch((AccountID)context.payer(), (TransactionBody)TransactionBody.newBuilder().hookDispatch(hookDispatch).build(), HookDispatchStreamBuilder.class));
            HandleException.validateTrue((streamBuilder.status() == ResponseCodeEnum.SUCCESS ? 1 : 0) != 0, (ResponseCodeEnum)streamBuilder.status());
            if (!Objects.equals(hookId, currentHead)) continue;
            currentHead = streamBuilder.getNextHookId();
        }
        return currentHead;
    }

    public static int dispatchHookCreations(@NonNull HandleContext context, @NonNull List<HookCreationDetails> creations, @Nullable Long currentHead, @NonNull HookEntityId hookOwnerId) {
        int totalStorageSlotsUpdated = 0;
        Long nextId = currentHead;
        for (int i = creations.size() - 1; i >= 0; --i) {
            HookCreationDetails d = creations.get(i);
            HookCreation.Builder creation = HookCreation.newBuilder().entityId(hookOwnerId).details(d);
            if (nextId != null) {
                creation.nextHookId(nextId);
            }
            totalStorageSlotsUpdated += HookDispatchUtils.dispatchCreation(context, creation.build());
            nextId = d.hookId();
        }
        return totalStorageSlotsUpdated;
    }

    static int dispatchCreation(@NonNull HandleContext context, @NonNull HookCreation creation) {
        HookDispatchTransactionBody hookDispatch = HookDispatchTransactionBody.newBuilder().creation(creation).build();
        HookDispatchStreamBuilder streamBuilder = (HookDispatchStreamBuilder)context.dispatch(DispatchOptions.hookDispatch((AccountID)context.payer(), (TransactionBody)TransactionBody.newBuilder().hookDispatch(hookDispatch).build(), HookDispatchStreamBuilder.class));
        HandleException.validateTrue((streamBuilder.status() == ResponseCodeEnum.SUCCESS ? 1 : 0) != 0, (ResponseCodeEnum)streamBuilder.status());
        return streamBuilder.getDeltaStorageSlotsUpdated();
    }

    public static void validateHookDuplicates(@NonNull List<HookCreationDetails> details) throws PreCheckException {
        Set hookIds;
        if (!details.isEmpty() && (hookIds = details.stream().map(HookCreationDetails::hookId).collect(Collectors.toSet())).size() != details.size()) {
            throw new PreCheckException(ResponseCodeEnum.HOOK_ID_REPEATED_IN_CREATION_DETAILS);
        }
    }

    public static void validateHookDuplicates(@NonNull List<HookCreationDetails> details, @NonNull List<Long> hookIdsToDelete) throws PreCheckException {
        HookDispatchUtils.validateHookDuplicates(details);
        if (!hookIdsToDelete.isEmpty()) {
            PreCheckException.validateTruePreCheck((hookIdsToDelete.stream().distinct().count() == (long)hookIdsToDelete.size() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOK_ID_REPEATED_IN_CREATION_DETAILS);
        }
    }

    public static void dispatchExecution(@NonNull HandleContext context, @NonNull HookExecution execution, @NonNull Function function, @NonNull EntityIdFactory entityIdFactory, boolean isolated) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(execution);
        Objects.requireNonNull(function);
        Objects.requireNonNull(entityIdFactory);
        HookDispatchTransactionBody hookDispatch = HookDispatchTransactionBody.newBuilder().execution(execution).build();
        ContractID hookContractId = entityIdFactory.newContractId(365L);
        StreamBuilder.SignedTxCustomizer executionCustomizer = signedTx -> {
            try {
                TransactionBody dispatchedBody = (TransactionBody)TransactionBody.PROTOBUF.parseStrict(signedTx.bodyBytes().toReadableSequentialData());
                EvmHookCall hookCall = dispatchedBody.hookDispatchOrThrow().executionOrThrow().callOrThrow().evmHookCallOrThrow();
                return StreamBuilder.signedTxWith((TransactionBody)dispatchedBody.copyBuilder().contractCall(new ContractCallTransactionBody(hookContractId, hookCall.gasLimit(), 0L, hookCall.data())).build());
            }
            catch (ParseException e) {
                throw new UncheckedParseException(e);
            }
        };
        HookDispatchStreamBuilder streamBuilder = (HookDispatchStreamBuilder)context.dispatch(DispatchOptions.hookDispatchForExecution((AccountID)context.payer(), (TransactionBody)TransactionBody.newBuilder().hookDispatch(hookDispatch).build(), HookDispatchStreamBuilder.class, (StreamBuilder.SignedTxCustomizer)executionCustomizer, (HandleContext.DispatchMetadata)(isolated ? HandleContext.DispatchMetadata.EMPTY_METADATA : GROUP_METADATA)));
        HandleException.validateTrue((streamBuilder.status() == ResponseCodeEnum.SUCCESS ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.REJECTED_BY_ACCOUNT_ALLOWANCE_HOOK);
        Bytes result = streamBuilder.getEvmCallResult();
        try {
            Tuple decoded = (Tuple)function.getOutputs().decode(result.toByteArray());
            HandleException.validateTrue((boolean)((Boolean)decoded.get(0)), (ResponseCodeEnum)ResponseCodeEnum.REJECTED_BY_ACCOUNT_ALLOWANCE_HOOK);
        }
        catch (Exception ignore) {
            throw new HandleException(ResponseCodeEnum.REJECTED_BY_ACCOUNT_ALLOWANCE_HOOK);
        }
    }
}

