/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.authorization;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.authorization.PrivilegesVerifier;
import com.hedera.node.app.spi.authorization.Authorizer;
import com.hedera.node.app.spi.authorization.SystemPrivilege;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.AccountsConfig;
import com.hedera.node.config.data.ApiPermissionConfig;
import com.hedera.node.config.types.PermissionedAccountsRange;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AuthorizerImpl
implements Authorizer {
    private final ConfigProvider configProvider;
    private final AccountsConfig accountsConfig;
    private final PrivilegesVerifier privilegedTransactionChecker;

    @Inject
    public AuthorizerImpl(@NonNull ConfigProvider configProvider, @NonNull PrivilegesVerifier privilegedTransactionChecker) {
        this.configProvider = Objects.requireNonNull(configProvider);
        this.accountsConfig = (AccountsConfig)configProvider.getConfiguration().getConfigData(AccountsConfig.class);
        this.privilegedTransactionChecker = Objects.requireNonNull(privilegedTransactionChecker);
    }

    public boolean isAuthorized(@NonNull AccountID id, @NonNull HederaFunctionality function) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(function);
        return this.permissibilityOf(id, function) == ResponseCodeEnum.OK;
    }

    public boolean isSuperUser(@NonNull AccountID accountID) {
        if (!accountID.hasAccountNum()) {
            return false;
        }
        long num = accountID.accountNumOrThrow();
        return num == this.accountsConfig.treasury() || num == this.accountsConfig.systemAdmin();
    }

    public boolean isTreasury(@NonNull AccountID accountID) {
        if (!accountID.hasAccountNum()) {
            return false;
        }
        long num = accountID.accountNumOrThrow();
        return num == this.accountsConfig.treasury();
    }

    public SystemPrivilege hasPrivilegedAuthorization(@NonNull AccountID payerId, @NonNull HederaFunctionality functionality, @NonNull TransactionBody txBody) {
        return this.privilegedTransactionChecker.hasPrivileges(payerId, functionality, txBody);
    }

    private ResponseCodeEnum permissibilityOf(@NonNull AccountID givenPayer, @NonNull HederaFunctionality function) {
        if (this.isSuperUser(givenPayer)) {
            return ResponseCodeEnum.OK;
        }
        if (!givenPayer.hasAccountNum()) {
            return ResponseCodeEnum.AUTHORIZATION_FAILED;
        }
        long num = givenPayer.accountNumOrThrow();
        ApiPermissionConfig permissionConfig = (ApiPermissionConfig)this.configProvider.getConfiguration().getConfigData(ApiPermissionConfig.class);
        PermissionedAccountsRange permission = permissionConfig.getPermission(function);
        return permission != null && permission.contains(num) ? ResponseCodeEnum.OK : ResponseCodeEnum.NOT_SUPPORTED;
    }
}

