/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.hapi.block.stream.BlockItem;
import com.hedera.hapi.block.stream.BlockProof;
import com.hedera.hapi.block.stream.ChainOfTrustProof;
import com.hedera.hapi.block.stream.MerklePath;
import com.hedera.hapi.block.stream.MerkleSiblingHash;
import com.hedera.hapi.block.stream.StateProof;
import com.hedera.hapi.block.stream.SubMerkleTree;
import com.hedera.hapi.block.stream.TssSignedBlockProof;
import com.hedera.hapi.block.stream.output.BlockFooter;
import com.hedera.hapi.block.stream.output.BlockHeader;
import com.hedera.hapi.block.stream.output.SingletonUpdateChange;
import com.hedera.hapi.block.stream.output.StateChange;
import com.hedera.hapi.block.stream.output.StateChanges;
import com.hedera.hapi.block.stream.output.StateIdentifier;
import com.hedera.hapi.node.base.BlockHashAlgorithm;
import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.blockstream.BlockStreamInfo;
import com.hedera.hapi.platform.state.PlatformState;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.blocks.BlockHashSigner;
import com.hedera.node.app.blocks.BlockItemWriter;
import com.hedera.node.app.blocks.BlockStreamManager;
import com.hedera.node.app.blocks.InitialStateHash;
import com.hedera.node.app.blocks.StreamingTreeHasher;
import com.hedera.node.app.blocks.impl.BlockImplUtils;
import com.hedera.node.app.blocks.impl.BoundaryStateChangeListener;
import com.hedera.node.app.blocks.impl.ConcurrentStreamingTreeHasher;
import com.hedera.node.app.blocks.impl.IncrementalStreamingHasher;
import com.hedera.node.app.blocks.impl.streaming.FileBlockItemWriter;
import com.hedera.node.app.blocks.schemas.V0560BlockStreamSchema;
import com.hedera.node.app.hapi.utils.CommonUtils;
import com.hedera.node.app.info.DiskStartupNetworks;
import com.hedera.node.app.records.BlockRecordService;
import com.hedera.node.app.records.impl.BlockRecordInfoUtils;
import com.hedera.node.app.spi.info.NetworkInfo;
import com.hedera.node.app.store.ReadableStoreFactory;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.VersionedConfiguration;
import com.hedera.node.config.data.BlockRecordStreamConfig;
import com.hedera.node.config.data.BlockStreamConfig;
import com.hedera.node.config.data.NetworkAdminConfig;
import com.hedera.node.config.data.TssConfig;
import com.hedera.node.config.data.VersionConfig;
import com.hedera.node.config.types.DiskNetworkExport;
import com.hedera.node.internal.network.PendingProof;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Counter;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.service.ReadablePlatformStateStore;
import com.swirlds.platform.state.service.schemas.V0540PlatformStateSchema;
import com.swirlds.platform.system.state.notifications.StateHashedNotification;
import com.swirlds.state.State;
import com.swirlds.state.merkle.VirtualMapState;
import com.swirlds.state.spi.CommittableWritableStates;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.concurrent.AbstractTask;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.model.hashgraph.Round;

@Singleton
public class BlockStreamManagerImpl
implements BlockStreamManager {
    private static final Logger log = LogManager.getLogger(BlockStreamManagerImpl.class);
    public static final Bytes NULL_HASH = Bytes.wrap((byte[])new byte[BlockRecordInfoUtils.HASH_SIZE]);
    private static final Bytes DEPTH_2_NODE_2_COMBINED;
    private final int roundsPerBlock;
    private final Duration blockPeriod;
    private final int hashCombineBatchSize;
    private final BlockHashSigner blockHashSigner;
    private final SemanticVersion version;
    private final SemanticVersion hapiVersion;
    private final ForkJoinPool executor;
    private final String diskNetworkExportFile;
    private final DiskNetworkExport diskNetworkExport;
    private final NetworkInfo networkInfo;
    private final ConfigProvider configProvider;
    private final Supplier<BlockItemWriter> writerSupplier;
    private final BoundaryStateChangeListener boundaryStateChangeListener;
    private final PlatformStateFacade platformStateFacade;
    private final BlockStreamManager.Lifecycle lifecycle;
    private final BlockHashManager blockHashManager;
    private final RunningHashManager runningHashManager;
    private final boolean streamToBlockNodes;
    private BlockStreamManager.PendingWork pendingWork = BlockStreamManager.PendingWork.NONE;
    private Instant lastIntervalProcessTime = Instant.EPOCH;
    private Instant lastTopLevelTime = Instant.EPOCH;
    private long blockNumber;
    private int eventIndex = 0;
    private final Map<Hash, Integer> eventIndexInBlock = new ConcurrentHashMap<Hash, Integer>();
    private Bytes lastBlockHash;
    private long lastRoundOfPrevBlock;
    private Instant blockTimestamp;
    private Instant consensusTimeLastRound;
    private Timestamp lastUsedTime;
    private BlockItemWriter writer;
    private IncrementalStreamingHasher previousBlockHashes;
    private StreamingTreeHasher consensusHeaderHasher;
    private StreamingTreeHasher inputTreeHasher;
    private StreamingTreeHasher outputTreeHasher;
    private StreamingTreeHasher stateChangesHasher;
    private StreamingTreeHasher traceDataHasher;
    private BlockStreamManagerTask worker;
    private final boolean hintsEnabled;
    private final Queue<PendingBlock> pendingBlocks = new ConcurrentLinkedQueue<PendingBlock>();
    private final Map<Long, CompletableFuture<Bytes>> endRoundStateHashes = new ConcurrentHashMap<Long, CompletableFuture<Bytes>>();
    @Nullable
    private volatile CompletableFuture<Void> fatalShutdownFuture = null;
    private boolean hasCheckedForPendingBlocks = false;
    private final Counter indirectProofCounter;

    @Inject
    public BlockStreamManagerImpl(@NonNull BlockHashSigner blockHashSigner, @NonNull Supplier<BlockItemWriter> writerSupplier, @NonNull ExecutorService executor, @NonNull ConfigProvider configProvider, @NonNull NetworkInfo networkInfo, @NonNull BoundaryStateChangeListener boundaryStateChangeListener, @NonNull InitialStateHash initialStateHash, @NonNull SemanticVersion version, @NonNull PlatformStateFacade platformStateFacade, @NonNull BlockStreamManager.Lifecycle lifecycle, @NonNull Metrics metrics) {
        this.blockHashSigner = Objects.requireNonNull(blockHashSigner);
        this.networkInfo = Objects.requireNonNull(networkInfo);
        this.version = Objects.requireNonNull(version);
        this.writerSupplier = Objects.requireNonNull(writerSupplier);
        this.executor = (ForkJoinPool)Objects.requireNonNull(executor);
        this.boundaryStateChangeListener = Objects.requireNonNull(boundaryStateChangeListener);
        this.platformStateFacade = Objects.requireNonNull(platformStateFacade);
        this.lifecycle = Objects.requireNonNull(lifecycle);
        this.configProvider = Objects.requireNonNull(configProvider);
        VersionedConfiguration config = configProvider.getConfiguration();
        this.hintsEnabled = ((TssConfig)config.getConfigData(TssConfig.class)).hintsEnabled();
        this.hapiVersion = this.hapiVersionFrom((Configuration)config);
        BlockStreamConfig blockStreamConfig = (BlockStreamConfig)config.getConfigData(BlockStreamConfig.class);
        this.roundsPerBlock = blockStreamConfig.roundsPerBlock();
        this.blockPeriod = blockStreamConfig.blockPeriod();
        this.hashCombineBatchSize = blockStreamConfig.hashCombineBatchSize();
        this.streamToBlockNodes = blockStreamConfig.streamToBlockNodes();
        NetworkAdminConfig networkAdminConfig = (NetworkAdminConfig)config.getConfigData(NetworkAdminConfig.class);
        this.diskNetworkExport = networkAdminConfig.diskNetworkExport();
        this.diskNetworkExportFile = networkAdminConfig.diskNetworkExportFile();
        this.blockHashManager = new BlockHashManager((Configuration)config);
        this.runningHashManager = new RunningHashManager();
        this.lastRoundOfPrevBlock = initialStateHash.roundNum();
        CompletableFuture<Bytes> hashFuture = initialStateHash.hashFuture();
        this.endRoundStateHashes.put(this.lastRoundOfPrevBlock, hashFuture);
        this.indirectProofCounter = (Counter)Objects.requireNonNull(metrics).getOrCreate((MetricConfig)new Counter.Config("block", "numIndirectProofs").withDescription("Number of blocks closed with indirect proofs"));
        log.info("Initialized BlockStreamManager from round {} with end-of-round state hash {}", (Object)this.lastRoundOfPrevBlock, (Object)(hashFuture.isDone() ? hashFuture.join().toHex() : "<PENDING>"));
    }

    @Override
    public boolean hasLedgerId() {
        return this.blockHashSigner.isReady();
    }

    @Override
    public void init(@NonNull State state, @Nullable Bytes lastBlockHash) {
        BlockStreamInfo blockStreamInfo = (BlockStreamInfo)state.getReadableStates("BlockStreamService").getSingleton(V0560BlockStreamSchema.BLOCK_STREAM_INFO_STATE_ID).get();
        Objects.requireNonNull(blockStreamInfo);
        Bytes prevBlockHash = blockStreamInfo.blockNumber() == 0L ? ZERO_BLOCK_HASH : BlockRecordInfoUtils.blockHashByBlockNumber(blockStreamInfo.trailingBlockHashes(), blockStreamInfo.blockNumber() - 1L, blockStreamInfo.blockNumber() - 1L);
        List<byte[]> prevBlocksIntermediateHashes = blockStreamInfo.intermediatePreviousBlockRootHashes().stream().map(Bytes::toByteArray).toList();
        this.previousBlockHashes = new IncrementalStreamingHasher(CommonUtils.sha384DigestOrThrow(), prevBlocksIntermediateHashes, blockStreamInfo.intermediateBlockRootsLeafCount());
        Bytes allPrevBlocksHash = Bytes.wrap((byte[])this.previousBlockHashes.computeRootHash());
        StreamingTreeHasher.Status penultimateStateChangesTreeStatus = new StreamingTreeHasher.Status(blockStreamInfo.numPrecedingStateChangesItems(), blockStreamInfo.rightmostPrecedingStateChangesTreeHashes());
        StateChange lastBlockFinalStateChange = StateChange.newBuilder().stateId(StateIdentifier.STATE_ID_BLOCK_STREAM_INFO.protoOrdinal()).singletonUpdate(SingletonUpdateChange.newBuilder().blockStreamInfoValue(blockStreamInfo).build()).build();
        BlockItem lastStateChanges = BlockItem.newBuilder().stateChanges(new StateChanges(blockStreamInfo.blockEndTime(), List.of(lastBlockFinalStateChange))).build();
        Bytes lastLeafHash = CommonUtils.noThrowSha384HashOf((Bytes)BlockItem.PROTOBUF.toBytes((Object)lastStateChanges));
        Bytes lastBlockFinalStateChangesHash = ConcurrentStreamingTreeHasher.rootHashFrom(penultimateStateChangesTreeStatus, lastLeafHash);
        Bytes calculatedLastBlockHash = Optional.ofNullable(lastBlockHash).orElseGet(() -> BlockStreamManagerImpl.combine(prevBlockHash, allPrevBlocksHash, blockStreamInfo.startOfBlockStateHash(), blockStreamInfo.consensusHeaderRootHash(), blockStreamInfo.inputTreeRootHash(), blockStreamInfo.outputItemRootHash(), lastBlockFinalStateChangesHash, blockStreamInfo.traceDataRootHash(), blockStreamInfo.blockTime()).blockRootHash());
        Objects.requireNonNull(calculatedLastBlockHash);
        this.lastBlockHash = calculatedLastBlockHash;
        this.previousBlockHashes.addLeaf(calculatedLastBlockHash.toByteArray());
    }

    @Override
    public void startRound(@NonNull Round round, @NonNull State state) {
        if (this.lastBlockHash == null) {
            throw new IllegalStateException("Last block hash must be initialized before starting a round");
        }
        if (this.fatalShutdownFuture != null) {
            log.fatal("Ignoring round {} after fatal shutdown request", (Object)round.getRoundNum());
            return;
        }
        this.endRoundStateHashes.put(round.getRoundNum(), new CompletableFuture());
        if (this.writer == null) {
            this.writer = this.writerSupplier.get();
            this.blockTimestamp = round.getConsensusTimestamp();
            this.lastUsedTime = HapiUtils.asTimestamp((Instant)round.getConsensusTimestamp());
            BlockStreamInfo blockStreamInfo = this.blockStreamInfoFrom(state);
            this.pendingWork = BlockStreamManagerImpl.classifyPendingWork(blockStreamInfo, this.version);
            this.lastTopLevelTime = HapiUtils.asInstant((Timestamp)blockStreamInfo.lastHandleTimeOrElse(BlockRecordService.EPOCH));
            this.lastIntervalProcessTime = HapiUtils.asInstant((Timestamp)blockStreamInfo.lastIntervalProcessTimeOrElse(BlockRecordService.EPOCH));
            this.blockHashManager.startBlock(blockStreamInfo, this.lastBlockHash);
            this.runningHashManager.startBlock(blockStreamInfo);
            this.lifecycle.onOpenBlock(state);
            this.resetSubtrees();
            this.blockNumber = blockStreamInfo.blockNumber() + 1L;
            if (this.hintsEnabled && !this.hasCheckedForPendingBlocks) {
                boolean hasBeenFrozen = Objects.requireNonNull((PlatformState)state.getReadableStates("PlatformStateService").getSingleton(V0540PlatformStateSchema.PLATFORM_STATE_STATE_ID).get()).hasLastFrozenTime();
                if (hasBeenFrozen) {
                    this.recoverPendingBlocks();
                }
                this.hasCheckedForPendingBlocks = true;
            }
            this.worker = new BlockStreamManagerTask();
            BlockHeader.Builder header = BlockHeader.newBuilder().number(this.blockNumber).hashAlgorithm(BlockHashAlgorithm.SHA2_384).softwareVersion(this.platformStateFacade.creationSemanticVersionOf(state)).blockTimestamp(HapiUtils.asTimestamp((Instant)this.blockTimestamp)).hapiProtoVersion(this.hapiVersion);
            this.worker.addItem(BlockItem.newBuilder().blockHeader(header).build());
        }
        this.consensusTimeLastRound = round.getConsensusTimestamp();
    }

    @VisibleForTesting
    void initLastBlockHash(@NonNull Bytes blockHash) {
        this.lastBlockHash = Objects.requireNonNull(blockHash);
    }

    private void recoverPendingBlocks() {
        VersionedConfiguration config = this.configProvider.getConfiguration();
        Path blockDirPath = FileBlockItemWriter.blockDirFor((Configuration)config);
        log.info("Attempting to recover any pending blocks contiguous to #{} still on disk @ {}", (Object)this.blockNumber, (Object)blockDirPath.toAbsolutePath());
        try {
            List<FileBlockItemWriter.OnDiskPendingBlock> onDiskPendingBlocks = FileBlockItemWriter.loadContiguousPendingBlocks(blockDirPath, this.blockNumber, BlockStreamManagerImpl.maxReadDepth((Configuration)config), BlockStreamManagerImpl.maxReadBytesSize((Configuration)config));
            if (onDiskPendingBlocks.isEmpty()) {
                log.info("No contiguous pending blocks found for block #{}", (Object)this.blockNumber);
                BlockItemWriter pendingWriter = this.writerSupplier.get();
                pendingWriter.jumpToBlockAfterFreeze(this.blockNumber);
                return;
            }
            for (int i = 0; i < onDiskPendingBlocks.size(); ++i) {
                FileBlockItemWriter.OnDiskPendingBlock block = onDiskPendingBlocks.get(i);
                try {
                    BlockItemWriter pendingWriter = this.writerSupplier.get();
                    if (i == 0) {
                        pendingWriter.jumpToBlockAfterFreeze(onDiskPendingBlocks.getFirst().number());
                    }
                    pendingWriter.openBlock(block.number());
                    block.items().forEach(item -> pendingWriter.writePbjItemAndBytes((BlockItem)item, BlockItem.PROTOBUF.toBytes(item)));
                    Bytes blockHash = block.blockHash();
                    this.pendingBlocks.add(new PendingBlock(block.number(), block.contentsPath(), blockHash, block.proofBuilder(), pendingWriter, block.siblingHashesIfUseful()));
                    log.info("Recovered pending block #{}", (Object)block.number());
                    continue;
                }
                catch (Exception e) {
                    log.warn("Failed to recover pending block #{}", (Object)block.number(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed to load pending blocks", (Throwable)e);
        }
    }

    @Override
    public void confirmPendingWorkFinished() {
        if (this.pendingWork == BlockStreamManager.PendingWork.NONE) {
            log.error("HandleWorkflow confirmed finished work but none was pending");
        }
        this.pendingWork = BlockStreamManager.PendingWork.NONE;
    }

    @Override
    @NonNull
    public BlockStreamManager.PendingWork pendingWork() {
        return this.pendingWork;
    }

    @Override
    @NonNull
    public Instant lastIntervalProcessTime() {
        return this.lastIntervalProcessTime;
    }

    @Override
    public void setLastIntervalProcessTime(@NonNull Instant lastIntervalProcessTime) {
        this.lastIntervalProcessTime = Objects.requireNonNull(lastIntervalProcessTime);
    }

    @Override
    @NonNull
    public final Instant lastTopLevelConsensusTime() {
        return this.lastTopLevelTime;
    }

    @Override
    public void setLastTopLevelTime(@NonNull Instant lastTopLevelTime) {
        this.lastTopLevelTime = Objects.requireNonNull(lastTopLevelTime);
    }

    @Override
    @NonNull
    public Instant lastUsedConsensusTime() {
        return HapiUtils.asInstant((Timestamp)this.lastUsedTime);
    }

    @Override
    public boolean endRound(@NonNull State state, long roundNum) {
        ReadableStoreFactory storeFactory = new ReadableStoreFactory(state);
        ReadablePlatformStateStore platformStateStore = storeFactory.getStore(ReadablePlatformStateStore.class);
        long freezeRoundNumber = platformStateStore.getLatestFreezeRound();
        boolean closesBlock = this.shouldCloseBlock(roundNum, freezeRoundNumber);
        if (closesBlock) {
            boolean exportNetworkToDisk;
            this.lifecycle.onCloseBlock(state);
            if (state instanceof VirtualMapState) {
                VirtualMapState hederaNewStateRoot = (VirtualMapState)state;
                hederaNewStateRoot.commitSingletons();
            }
            this.worker.addItem(this.flushChangesFromListener(this.boundaryStateChangeListener));
            this.worker.sync();
            Bytes blockStartStateHash = Objects.requireNonNull(this.endRoundStateHashes.get(this.lastRoundOfPrevBlock)).join();
            for (long i = this.lastRoundOfPrevBlock; i < roundNum; ++i) {
                this.endRoundStateHashes.remove(i);
            }
            this.lastRoundOfPrevBlock = roundNum;
            ConcurrentHashMap computedHashes = new ConcurrentHashMap();
            CompletableFuture<Void> future = CompletableFuture.allOf(new CompletableFuture[]{this.consensusHeaderHasher.rootHash().thenAccept(b -> computedHashes.put(SubMerkleTree.CONSENSUS_HEADER_ITEMS, b)), this.inputTreeHasher.rootHash().thenAccept(b -> computedHashes.put(SubMerkleTree.INPUT_ITEMS_TREE, b)), this.outputTreeHasher.rootHash().thenAccept(b -> computedHashes.put(SubMerkleTree.OUTPUT_ITEMS_TREE, b)), this.traceDataHasher.rootHash().thenAccept(b -> computedHashes.put(SubMerkleTree.TRACE_DATA_ITEMS_TREE, b))});
            future.join();
            Bytes consensusHeaderHash = (Bytes)computedHashes.get(SubMerkleTree.CONSENSUS_HEADER_ITEMS);
            Bytes inputsHash = (Bytes)computedHashes.get(SubMerkleTree.INPUT_ITEMS_TREE);
            Bytes outputsHash = (Bytes)computedHashes.get(SubMerkleTree.OUTPUT_ITEMS_TREE);
            StreamingTreeHasher.Status penultimateStateChangesTreeStatus = this.stateChangesHasher.status();
            Bytes traceDataHash = (Bytes)computedHashes.get(SubMerkleTree.TRACE_DATA_ITEMS_TREE);
            WritableStates writableState = state.getWritableStates("BlockStreamService");
            WritableSingletonState blockStreamInfoState = writableState.getSingleton(V0560BlockStreamSchema.BLOCK_STREAM_INFO_STATE_ID);
            BlockStreamInfo newBlockStreamInfo = new BlockStreamInfo(this.blockNumber, this.blockTimestamp(), this.runningHashManager.latestHashes(), this.blockHashManager.blockHashes(), inputsHash, blockStartStateHash, penultimateStateChangesTreeStatus.numLeaves(), penultimateStateChangesTreeStatus.rightmostHashes(), this.lastUsedTime, this.pendingWork != BlockStreamManager.PendingWork.POST_UPGRADE_WORK, this.version, HapiUtils.asTimestamp((Instant)this.lastIntervalProcessTime), HapiUtils.asTimestamp((Instant)this.lastTopLevelTime), consensusHeaderHash, outputsHash, traceDataHash, this.previousBlockHashes.intermediateHashingState(), this.previousBlockHashes.leafCount());
            blockStreamInfoState.put((Object)newBlockStreamInfo);
            ((CommittableWritableStates)writableState).commit();
            this.worker.addItem(this.flushChangesFromListener(this.boundaryStateChangeListener));
            this.worker.sync();
            Bytes stateChangesHash = this.stateChangesHasher.rootHash().join();
            Bytes prevBlockRootsHash = Bytes.wrap((byte[])this.previousBlockHashes.computeRootHash());
            RootAndSiblingHashes rootAndSiblingHashes = BlockStreamManagerImpl.combine(this.lastBlockHash, prevBlockRootsHash, blockStartStateHash, consensusHeaderHash, inputsHash, outputsHash, stateChangesHash, traceDataHash, newBlockStreamInfo.blockTime());
            Bytes finalBlockRootHash = rootAndSiblingHashes.blockRootHash();
            BlockFooter blockFooter = BlockFooter.newBuilder().previousBlockRootHash(this.lastBlockHash).rootHashOfAllBlockHashesTree(prevBlockRootsHash).startOfBlockStateRootHash(blockStartStateHash).build();
            BlockItem footerItem = BlockItem.newBuilder().blockFooter(blockFooter).build();
            this.worker.addItem(footerItem);
            this.worker.sync();
            BlockProof.Builder blockProofBuilder = BlockProof.newBuilder().block(this.blockNumber);
            this.pendingBlocks.add(new PendingBlock(this.blockNumber, null, finalBlockRootHash, blockProofBuilder, this.writer, rootAndSiblingHashes.siblingHashes()));
            this.lastBlockHash = finalBlockRootHash;
            this.previousBlockHashes.addLeaf(this.lastBlockHash.toByteArray());
            this.writer = null;
            if (this.hintsEnabled && roundNum == freezeRoundNumber) {
                AtomicBoolean hasPrecedingUnproven = new AtomicBoolean(false);
                this.pendingBlocks.forEach(block -> block.flushPending(hasPrecedingUnproven.getAndSet(true)));
            } else {
                BlockHashSigner.Attempt attempt = this.blockHashSigner.sign(finalBlockRootHash);
                attempt.signatureFuture().thenAcceptAsync(signature -> this.finishProofWithSignature(finalBlockRootHash, (Bytes)signature, attempt.verificationKey(), attempt.chainOfTrustProof()));
            }
            switch (this.diskNetworkExport) {
                default: {
                    throw new MatchException(null, null);
                }
                case NEVER: {
                    boolean bl = false;
                    break;
                }
                case EVERY_BLOCK: {
                    boolean bl = true;
                    break;
                }
                case ONLY_FREEZE_BLOCK: {
                    boolean bl = exportNetworkToDisk = roundNum == freezeRoundNumber;
                }
            }
            if (exportNetworkToDisk) {
                Path exportPath = Paths.get(this.diskNetworkExportFile, new String[0]);
                log.info("Writing network info to disk @ {} (REASON = {})", (Object)exportPath.toAbsolutePath(), (Object)this.diskNetworkExport);
                DiskStartupNetworks.writeNetworkInfo(state, exportPath, EnumSet.allOf(DiskStartupNetworks.InfoType.class), this.platformStateFacade);
            }
            this.eventIndexInBlock.clear();
            this.eventIndex = 0;
        }
        if (this.fatalShutdownFuture != null) {
            this.pendingBlocks.forEach(block -> log.fatal("Skipping incomplete block proof for block {}", (Object)block.number()));
            if (this.writer != null) {
                log.fatal("Prematurely closing block {}", (Object)this.blockNumber);
                this.writer.closeCompleteBlock();
                this.writer = null;
            }
            Objects.requireNonNull(this.fatalShutdownFuture).complete(null);
        }
        return closesBlock;
    }

    @Override
    public void writeItem(@NonNull BlockItem item) {
        this.lastUsedTime = switch ((BlockItem.ItemOneOfType)item.item().kind()) {
            case BlockItem.ItemOneOfType.STATE_CHANGES -> item.stateChangesOrThrow().consensusTimestampOrThrow();
            case BlockItem.ItemOneOfType.TRANSACTION_RESULT -> item.transactionResultOrThrow().consensusTimestampOrThrow();
            default -> this.lastUsedTime;
        };
        this.worker.addItem(item);
    }

    @Override
    public void writeItem(@NonNull Function<Timestamp, BlockItem> itemSpec) {
        Objects.requireNonNull(itemSpec);
        this.writeItem(itemSpec.apply(this.lastUsedTime));
    }

    @Nullable
    public Bytes prngSeed() {
        this.worker.sync();
        byte[] seed = this.runningHashManager.nMinus3Hash;
        return seed == null ? null : Bytes.wrap((byte[])this.runningHashManager.nMinus3Hash);
    }

    public long blockNo() {
        return this.blockNumber;
    }

    @NonNull
    public Timestamp blockTimestamp() {
        return new Timestamp(this.blockTimestamp.getEpochSecond(), this.blockTimestamp.getNano());
    }

    @Nullable
    public Bytes blockHashByBlockNumber(long blockNo) {
        return this.blockHashManager.hashOfBlock(blockNo);
    }

    private synchronized void finishProofWithSignature(@NonNull Bytes blockHash, @NonNull Bytes blockSignature, @Nullable Bytes verificationKey, @Nullable ChainOfTrustProof chainOfTrustProof) {
        long blockNumber = Long.MIN_VALUE;
        boolean impliesIndirectProof = false;
        ArrayList<List<MerkleSiblingHash>> siblingHashes = new ArrayList<List<MerkleSiblingHash>>();
        for (PendingBlock block : this.pendingBlocks) {
            if (impliesIndirectProof) {
                siblingHashes.add(List.of(block.siblingHashes()));
            }
            if (block.blockHash().equals((Object)blockHash)) {
                blockNumber = block.number();
                break;
            }
            impliesIndirectProof = true;
        }
        if (blockNumber == Long.MIN_VALUE) {
            log.debug("Ignoring signature on already proven block hash '{}'", (Object)blockHash);
            return;
        }
        TssSignedBlockProof latestSignedBlockProof = TssSignedBlockProof.newBuilder().blockSignature(blockSignature).build();
        while (!this.pendingBlocks.isEmpty() && this.pendingBlocks.peek().number() <= blockNumber) {
            BlockProof.Builder proof;
            PendingBlock block;
            block = this.pendingBlocks.poll();
            if (block.number() == blockNumber) {
                proof = block.proofBuilder().signedBlockProof(latestSignedBlockProof);
            } else {
                proof = block.proofBuilder().blockStateProof(StateProof.newBuilder().paths(new MerklePath[]{MerklePath.newBuilder().build()}).signedBlockProof(latestSignedBlockProof).build()).siblingHashes(siblingHashes.stream().flatMap(Collection::stream).toList());
                this.indirectProofCounter.increment();
            }
            if (verificationKey != null) {
                proof.verificationKey(verificationKey);
                if (chainOfTrustProof != null) {
                    proof.verificationKeyProof(chainOfTrustProof);
                }
            }
            BlockItem proofItem = BlockItem.newBuilder().blockProof(proof).build();
            block.writer().writePbjItemAndBytes(proofItem, BlockItem.PROTOBUF.toBytes((Object)proofItem));
            block.writer().closeCompleteBlock();
            if (block.number() != blockNumber) {
                siblingHashes.removeFirst();
            }
            if (block.contentsPath() == null) continue;
            FileBlockItemWriter.cleanUpPendingBlock(block.contentsPath());
        }
    }

    @VisibleForTesting
    static BlockStreamManager.PendingWork classifyPendingWork(@NonNull BlockStreamInfo blockStreamInfo, @NonNull SemanticVersion version) {
        Objects.requireNonNull(version);
        Objects.requireNonNull(blockStreamInfo);
        if (BlockRecordService.EPOCH.equals((Object)blockStreamInfo.lastHandleTimeOrElse(BlockRecordService.EPOCH))) {
            return BlockStreamManager.PendingWork.GENESIS_WORK;
        }
        if (BlockStreamManagerImpl.impliesPostUpgradeWorkPending(blockStreamInfo, version)) {
            return BlockStreamManager.PendingWork.POST_UPGRADE_WORK;
        }
        return BlockStreamManager.PendingWork.NONE;
    }

    private static boolean impliesPostUpgradeWorkPending(@NonNull BlockStreamInfo blockStreamInfo, @NonNull SemanticVersion version) {
        return !version.equals((Object)blockStreamInfo.creationSoftwareVersion()) || !blockStreamInfo.postUpgradeWorkDone();
    }

    @NonNull
    private BlockStreamInfo blockStreamInfoFrom(@NonNull State state) {
        ReadableSingletonState blockStreamInfoState = state.getReadableStates("BlockStreamService").getSingleton(V0560BlockStreamSchema.BLOCK_STREAM_INFO_STATE_ID);
        return Objects.requireNonNull((BlockStreamInfo)blockStreamInfoState.get());
    }

    private boolean shouldCloseBlock(long roundNumber, long freezeRoundNumber) {
        if (this.fatalShutdownFuture != null) {
            return true;
        }
        if (!this.blockHashSigner.isReady()) {
            return false;
        }
        if (roundNumber == freezeRoundNumber || roundNumber == 1L) {
            return true;
        }
        if (this.blockPeriod.isZero()) {
            return roundNumber % (long)this.roundsPerBlock == 0L;
        }
        Duration elapsed = Duration.between(this.blockTimestamp, this.consensusTimeLastRound);
        return elapsed.compareTo(this.blockPeriod) >= 0;
    }

    private SemanticVersion hapiVersionFrom(@NonNull Configuration config) {
        return ((VersionConfig)config.getConfigData(VersionConfig.class)).hapiVersion();
    }

    public void notify(@NonNull StateHashedNotification notification) {
        this.endRoundStateHashes.get(notification.round()).complete(notification.hash().getBytes());
    }

    @Override
    public void notifyFatalEvent() {
        this.fatalShutdownFuture = new CompletableFuture();
    }

    @Override
    public void awaitFatalShutdown(@NonNull Duration timeout) {
        Objects.requireNonNull(timeout);
        log.fatal("Awaiting any in-progress round to be closed within {}", (Object)timeout);
        Optional.ofNullable(this.fatalShutdownFuture).orElse(CompletableFuture.completedFuture(null)).completeOnTimeout(null, timeout.toSeconds(), TimeUnit.SECONDS).join();
        log.fatal("Block stream fatal shutdown complete");
    }

    @Override
    public void trackEventHash(@NonNull Hash eventHash) {
        this.eventIndexInBlock.put(eventHash, this.eventIndex++);
    }

    @Override
    public Optional<Integer> getEventIndex(@NonNull Hash eventHash) {
        return Optional.ofNullable(this.eventIndexInBlock.get(eventHash));
    }

    private BlockItem flushChangesFromListener(@NonNull BoundaryStateChangeListener boundaryStateChangeListener) {
        StateChanges stateChanges = new StateChanges(this.lastUsedTime, boundaryStateChangeListener.allStateChanges());
        boundaryStateChangeListener.reset();
        return BlockItem.newBuilder().stateChanges(stateChanges).build();
    }

    private void resetSubtrees() {
        this.consensusHeaderHasher = new ConcurrentStreamingTreeHasher(this.executor, this.hashCombineBatchSize);
        this.inputTreeHasher = new ConcurrentStreamingTreeHasher(this.executor, this.hashCombineBatchSize);
        this.outputTreeHasher = new ConcurrentStreamingTreeHasher(this.executor, this.hashCombineBatchSize);
        this.stateChangesHasher = new ConcurrentStreamingTreeHasher(this.executor, this.hashCombineBatchSize);
        this.traceDataHasher = new ConcurrentStreamingTreeHasher(this.executor, this.hashCombineBatchSize);
    }

    private static RootAndSiblingHashes combine(@Nullable Bytes maybePrevBlockHash, @Nullable Bytes maybePrevBlockRootsHash, @Nullable Bytes maybeStartingStateHash, @Nullable Bytes maybeConsensusHeaderHash, @Nullable Bytes maybeInputsHash, @Nullable Bytes maybeOutputsHash, @Nullable Bytes maybeStateChangesHash, @Nullable Bytes maybeTraceDataHash, @NonNull Timestamp firstConsensusTimeOfCurrentBlock) {
        Bytes prevBlockHash = CommonUtils.inputOrNullHash((Bytes)maybePrevBlockHash);
        Bytes prevBlockRootsHash = CommonUtils.inputOrNullHash((Bytes)maybePrevBlockRootsHash);
        Bytes startingStateHash = CommonUtils.inputOrNullHash((Bytes)maybeStartingStateHash);
        Bytes consensusHeaderHash = CommonUtils.inputOrNullHash((Bytes)maybeConsensusHeaderHash);
        Bytes inputsHash = CommonUtils.inputOrNullHash((Bytes)maybeInputsHash);
        Bytes outputsHash = CommonUtils.inputOrNullHash((Bytes)maybeOutputsHash);
        Bytes stateChangesHash = CommonUtils.inputOrNullHash((Bytes)maybeStateChangesHash);
        Bytes traceDataHash = CommonUtils.inputOrNullHash((Bytes)maybeTraceDataHash);
        Bytes depth4Node1 = BlockImplUtils.combine(prevBlockHash, prevBlockRootsHash);
        Bytes depth4Node2 = BlockImplUtils.combine(startingStateHash, consensusHeaderHash);
        Bytes depth4Node3 = BlockImplUtils.combine(inputsHash, outputsHash);
        Bytes depth4Node4 = BlockImplUtils.combine(stateChangesHash, traceDataHash);
        Bytes depth3Node1 = BlockImplUtils.combine(depth4Node1, depth4Node2);
        Bytes depth3Node2 = BlockImplUtils.combine(depth4Node3, depth4Node4);
        Bytes depth2Node1 = BlockImplUtils.combine(depth3Node1, depth3Node2);
        Bytes depth1Node1 = BlockImplUtils.combine(depth2Node1, DEPTH_2_NODE_2_COMBINED);
        Bytes timestamp = Timestamp.PROTOBUF.toBytes((Object)firstConsensusTimeOfCurrentBlock);
        Bytes depth1Node0 = CommonUtils.noThrowSha384HashOf((Bytes)timestamp);
        Bytes rootHash = BlockImplUtils.combine(depth1Node0, depth1Node1);
        return new RootAndSiblingHashes(rootHash, new MerkleSiblingHash[]{new MerkleSiblingHash(false, prevBlockRootsHash), new MerkleSiblingHash(false, depth4Node2), new MerkleSiblingHash(false, depth3Node2), new MerkleSiblingHash(false, DEPTH_2_NODE_2_COMBINED)});
    }

    private static int maxReadDepth(@NonNull Configuration config) {
        Objects.requireNonNull(config);
        return ((BlockStreamConfig)config.getConfigData(BlockStreamConfig.class)).maxReadDepth();
    }

    private static int maxReadBytesSize(@NonNull Configuration config) {
        Objects.requireNonNull(config);
        return ((BlockStreamConfig)config.getConfigData(BlockStreamConfig.class)).maxReadBytesSize();
    }

    static {
        Bytes combinedNullHash = BlockImplUtils.combine(NULL_HASH, NULL_HASH);
        Bytes depth3Node3 = BlockImplUtils.combine(combinedNullHash, combinedNullHash);
        Bytes depth3Node4 = BlockImplUtils.combine(combinedNullHash, combinedNullHash);
        DEPTH_2_NODE_2_COMBINED = BlockImplUtils.combine(depth3Node3, depth3Node4);
    }

    private class BlockHashManager {
        final int numTrailingBlocks;
        private Bytes blockHashes;

        BlockHashManager(Configuration config) {
            this.numTrailingBlocks = ((BlockRecordStreamConfig)config.getConfigData(BlockRecordStreamConfig.class)).numOfBlockHashesInState();
        }

        void startBlock(@NonNull BlockStreamInfo blockStreamInfo, @NonNull Bytes prevBlockHash) {
            this.blockHashes = BlockImplUtils.appendHash(prevBlockHash, blockStreamInfo.trailingBlockHashes(), this.numTrailingBlocks);
        }

        @Nullable
        Bytes hashOfBlock(long blockNo) {
            return BlockRecordInfoUtils.blockHashByBlockNumber(this.blockHashes, BlockStreamManagerImpl.this.blockNumber - 1L, blockNo);
        }

        Bytes blockHashes() {
            return this.blockHashes;
        }
    }

    private static class RunningHashManager {
        private static final ThreadLocal<byte[]> HASHES = ThreadLocal.withInitial(() -> new byte[BlockRecordInfoUtils.HASH_SIZE]);
        private static final ThreadLocal<MessageDigest> DIGESTS = ThreadLocal.withInitial(CommonUtils::sha384DigestOrThrow);
        byte[] nMinus3Hash;
        byte[] nMinus2Hash;
        byte[] nMinus1Hash;
        byte[] hash;

        private RunningHashManager() {
        }

        Bytes latestHashes() {
            int numMissing;
            byte[][] all = new byte[][]{this.nMinus3Hash, this.nMinus2Hash, this.nMinus1Hash, this.hash};
            for (numMissing = 0; numMissing < all.length && all[numMissing] == null; ++numMissing) {
            }
            byte[] hashes = new byte[(all.length - numMissing) * BlockRecordInfoUtils.HASH_SIZE];
            for (int i = numMissing; i < all.length; ++i) {
                System.arraycopy(all[i], 0, hashes, (i - numMissing) * BlockRecordInfoUtils.HASH_SIZE, BlockRecordInfoUtils.HASH_SIZE);
            }
            return Bytes.wrap((byte[])hashes);
        }

        void startBlock(@NonNull BlockStreamInfo blockStreamInfo) {
            Bytes hashes = blockStreamInfo.trailingOutputHashes();
            int n = (int)(hashes.length() / (long)BlockRecordInfoUtils.HASH_SIZE);
            this.nMinus3Hash = n < 4 ? null : hashes.toByteArray(0, BlockRecordInfoUtils.HASH_SIZE);
            this.nMinus2Hash = n < 3 ? null : hashes.toByteArray((n - 3) * BlockRecordInfoUtils.HASH_SIZE, BlockRecordInfoUtils.HASH_SIZE);
            this.nMinus1Hash = n < 2 ? null : hashes.toByteArray((n - 2) * BlockRecordInfoUtils.HASH_SIZE, BlockRecordInfoUtils.HASH_SIZE);
            this.hash = n < 1 ? new byte[BlockRecordInfoUtils.HASH_SIZE] : hashes.toByteArray((n - 1) * BlockRecordInfoUtils.HASH_SIZE, BlockRecordInfoUtils.HASH_SIZE);
        }

        void nextResultHash(@NonNull ByteBuffer hash) {
            Objects.requireNonNull(hash);
            this.nMinus3Hash = this.nMinus2Hash;
            this.nMinus2Hash = this.nMinus1Hash;
            this.nMinus1Hash = this.hash;
            MessageDigest digest = DIGESTS.get();
            digest.update(this.hash);
            byte[] resultHash = HASHES.get();
            hash.get(resultHash);
            digest.update(resultHash);
            this.hash = digest.digest();
        }
    }

    class BlockStreamManagerTask {
        SequentialTask prevTask = null;
        SequentialTask currentTask;

        BlockStreamManagerTask() {
            this.currentTask = new SequentialTask();
            this.currentTask.send();
        }

        void addItem(BlockItem item) {
            new ParallelTask(item, this.currentTask).send();
            SequentialTask nextTask = new SequentialTask();
            this.currentTask.send(nextTask);
            this.prevTask = this.currentTask;
            this.currentTask = nextTask;
        }

        void sync() {
            if (this.prevTask != null) {
                this.prevTask.join();
            }
        }
    }

    private record PendingBlock(long number, @Nullable Path contentsPath, @NonNull Bytes blockHash, @NonNull BlockProof.Builder proofBuilder, @NonNull BlockItemWriter writer, @NonNull MerkleSiblingHash[] siblingHashes) {
        public void flushPending(boolean withSiblingHashes) {
            PendingProof pendingProof = PendingProof.newBuilder().block(this.number).blockHash(this.blockHash).siblingHashesFromPrevBlockRoot(withSiblingHashes ? List.of(this.siblingHashes) : List.of()).build();
            this.writer.flushPendingBlock(pendingProof);
        }
    }

    private record RootAndSiblingHashes(Bytes blockRootHash, MerkleSiblingHash[] siblingHashes) {
    }

    class SequentialTask
    extends AbstractTask {
        SequentialTask next;
        BlockItem item;
        Bytes serialized;
        ByteBuffer hash;

        SequentialTask() {
            super(BlockStreamManagerImpl.this.executor, 3);
        }

        protected boolean onExecute() {
            BlockItem.ItemOneOfType kind = (BlockItem.ItemOneOfType)this.item.item().kind();
            switch (kind) {
                case EVENT_HEADER: 
                case ROUND_HEADER: {
                    BlockStreamManagerImpl.this.consensusHeaderHasher.addLeaf(this.hash);
                    break;
                }
                case SIGNED_TRANSACTION: {
                    BlockStreamManagerImpl.this.inputTreeHasher.addLeaf(this.hash);
                    break;
                }
                case TRANSACTION_RESULT: {
                    BlockStreamManagerImpl.this.runningHashManager.nextResultHash(this.hash);
                    this.hash.rewind();
                    BlockStreamManagerImpl.this.outputTreeHasher.addLeaf(this.hash);
                    break;
                }
                case TRANSACTION_OUTPUT: 
                case BLOCK_HEADER: {
                    BlockStreamManagerImpl.this.outputTreeHasher.addLeaf(this.hash);
                    break;
                }
                case STATE_CHANGES: {
                    BlockStreamManagerImpl.this.stateChangesHasher.addLeaf(this.hash);
                    break;
                }
                case TRACE_DATA: {
                    BlockStreamManagerImpl.this.traceDataHasher.addLeaf(this.hash);
                    break;
                }
            }
            BlockHeader header = this.item.blockHeader();
            if (header != null) {
                BlockStreamManagerImpl.this.writer.openBlock(header.number());
            }
            BlockStreamManagerImpl.this.writer.writePbjItemAndBytes(this.item, this.serialized);
            this.next.send();
            return true;
        }

        protected void onException(Throwable t) {
            log.error("Error occurred while executing task", t);
        }

        void send(SequentialTask next) {
            this.next = next;
            this.send();
        }

        void send(BlockItem item, ByteBuffer hash, Bytes serialized) {
            this.item = item;
            this.hash = hash;
            this.serialized = serialized;
            this.send();
        }
    }

    class ParallelTask
    extends AbstractTask {
        BlockItem item;
        SequentialTask out;

        ParallelTask(BlockItem item, SequentialTask out) {
            super(BlockStreamManagerImpl.this.executor, 1);
            this.item = item;
            this.out = out;
        }

        protected boolean onExecute() {
            try {
                Bytes bytes = BlockItem.PROTOBUF.toBytes((Object)this.item);
                BlockItem.ItemOneOfType kind = (BlockItem.ItemOneOfType)this.item.item().kind();
                ByteBuffer hash = null;
                switch (kind) {
                    case STATE_CHANGES: 
                    case TRANSACTION_RESULT: 
                    case EVENT_HEADER: 
                    case SIGNED_TRANSACTION: 
                    case TRANSACTION_OUTPUT: 
                    case ROUND_HEADER: 
                    case BLOCK_HEADER: 
                    case TRACE_DATA: {
                        MessageDigest digest = CommonUtils.sha384DigestOrThrow();
                        bytes.writeTo(digest);
                        hash = ByteBuffer.wrap(digest.digest());
                    }
                }
                this.out.send(this.item, hash, bytes);
                return true;
            }
            catch (Exception e) {
                log.error("{} - error hashing item {}", (Object)"Possibly CATASTROPHIC failure", (Object)this.item, (Object)e);
                return false;
            }
        }
    }
}

