/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl.streaming;

import com.hedera.hapi.block.stream.BlockItem;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class BlockState {
    private final long blockNumber;
    private final AtomicInteger itemIndex = new AtomicInteger(-1);
    private final ConcurrentMap<Integer, BlockItem> blockItems = new ConcurrentHashMap<Integer, BlockItem>();
    private volatile Instant closedTimestamp;

    public BlockState(long blockNumber) {
        this.blockNumber = blockNumber;
    }

    public void addItem(@Nullable BlockItem item) {
        if (item == null) {
            return;
        }
        if (this.closedTimestamp != null) {
            throw new IllegalStateException("Block is closed; adding more items is not permitted");
        }
        int index = this.itemIndex.incrementAndGet();
        this.blockItems.put(index, item);
    }

    public long blockNumber() {
        return this.blockNumber;
    }

    public boolean isClosed() {
        return this.closedTimestamp != null;
    }

    public void closeBlock() {
        this.closeBlock(Instant.now());
    }

    public void closeBlock(@NonNull Instant timestamp) {
        this.closedTimestamp = Objects.requireNonNull(timestamp);
    }

    @Nullable
    public Instant closedTimestamp() {
        return this.closedTimestamp;
    }

    @Nullable
    public BlockItem blockItem(int index) {
        return (BlockItem)this.blockItems.get(index);
    }

    public int itemCount() {
        return this.itemIndex.get() + 1;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockState that = (BlockState)o;
        return this.blockNumber == that.blockNumber && Objects.equals(this.blockItems, that.blockItems) && Objects.equals(this.closedTimestamp, that.closedTimestamp);
    }

    public int hashCode() {
        return Objects.hash(this.blockNumber, this.blockItems, this.closedTimestamp);
    }

    public String toString() {
        return "BlockState{blockNumber=" + this.blockNumber + ", closedTimestamp=" + String.valueOf(this.closedTimestamp) + ", blockItemCount=" + this.blockItems.size() + "}";
    }
}

