/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.virtualmerkle.config;

import com.swirlds.demo.virtualmerkle.config.TransactionRequestConfig;
import com.swirlds.logging.legacy.LogMarker;
import java.util.List;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SequentialTransactionRequestSupplier
implements Supplier<TransactionRequestConfig> {
    private static final Logger logger = LogManager.getLogger(SequentialTransactionRequestSupplier.class);
    private final List<TransactionRequestConfig> sequenceOfConfigs;
    private int transactionConfigIndex = 0;

    public SequentialTransactionRequestSupplier(List<TransactionRequestConfig> requestConfigs) {
        this.sequenceOfConfigs = requestConfigs;
    }

    @Override
    public TransactionRequestConfig get() {
        if (this.transactionConfigIndex == this.sequenceOfConfigs.size()) {
            return null;
        }
        TransactionRequestConfig transactionRequestConfig = this.sequenceOfConfigs.get(this.transactionConfigIndex);
        if (transactionRequestConfig.decrementAndGetAmount() == 0L) {
            ++this.transactionConfigIndex;
            logger.info(LogMarker.DEMO_INFO.getMarker(), "Finished generating {} transactions", (Object)transactionRequestConfig.getType());
        }
        return transactionRequestConfig;
    }
}

