/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.fees;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.FeeData;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.SignatureMap;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.transaction.SignedTransaction;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.hapi.util.UnknownHederaFunctionality;
import com.hedera.node.app.fees.congestion.CongestionMultipliers;
import com.hedera.node.app.hapi.fees.calc.OverflowCheckingCalc;
import com.hedera.node.app.hapi.fees.usage.BaseTransactionMeta;
import com.hedera.node.app.hapi.fees.usage.SigUsage;
import com.hedera.node.app.hapi.fees.usage.state.UsageAccumulator;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.fee.FeeBuilder;
import com.hedera.node.app.hapi.utils.fee.FeeObject;
import com.hedera.node.app.hapi.utils.fee.SigValueObj;
import com.hedera.node.app.spi.fees.FeeCalculator;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.store.ReadableStoreFactory;
import com.hedera.node.app.workflows.TransactionInfo;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hederahashgraph.api.proto.java.ExchangeRate;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Function;
import org.hiero.hapi.support.fees.FeeSchedule;

public class FeeCalculatorImpl
implements FeeCalculator {
    private final UsageAccumulator usage;
    private final com.hederahashgraph.api.proto.java.FeeData feeData;
    private final ExchangeRate currentRate;
    private final SigUsage sigUsage;
    private final CongestionMultipliers congestionMultipliers;
    private final ReadableStoreFactory storeFactory;
    private final TransactionInfo txInfo;
    private final FeeSchedule simpleFeesSchedule;

    public FeeCalculatorImpl(@NonNull TransactionBody txBody, @NonNull Key payerKey, int numVerifications, int signatureMapSize, @NonNull FeeData feeData, @NonNull com.hedera.hapi.node.transaction.ExchangeRate currentRate, boolean isInternalDispatch, CongestionMultipliers congestionMultipliers, ReadableStoreFactory storeFactory, @NonNull FeeSchedule simpleFeesSchedule) {
        Objects.requireNonNull(txBody);
        Objects.requireNonNull(payerKey);
        this.feeData = CommonPbjConverters.fromPbj((FeeData)feeData);
        this.simpleFeesSchedule = simpleFeesSchedule;
        this.currentRate = CommonPbjConverters.fromPbj((com.hedera.hapi.node.transaction.ExchangeRate)currentRate);
        if (numVerifications < 0) {
            throw new IllegalArgumentException("numVerifications must be >= 0");
        }
        this.sigUsage = new SigUsage(numVerifications, signatureMapSize, HapiUtils.countOfCryptographicKeys((Key)payerKey));
        BaseTransactionMeta baseMeta = new BaseTransactionMeta(isInternalDispatch ? 0 : txBody.memo().getBytes(StandardCharsets.UTF_8).length, txBody.data().kind() == TransactionBody.DataOneOfType.CRYPTO_TRANSFER ? ((CryptoTransferTransactionBody)txBody.data().as()).transfersOrElse(TransferList.DEFAULT).accountAmounts().size() : 0);
        this.usage = UsageAccumulator.fromGrpc((com.hederahashgraph.api.proto.java.FeeData)this.feeData);
        this.usage.resetForTransaction(baseMeta, this.sigUsage);
        this.congestionMultipliers = congestionMultipliers;
        this.storeFactory = storeFactory;
        try {
            this.txInfo = new TransactionInfo(SignedTransaction.DEFAULT, txBody, SignatureMap.DEFAULT, Bytes.EMPTY, HapiUtils.functionOf((TransactionBody)txBody), null);
        }
        catch (UnknownHederaFunctionality e) {
            throw new IllegalStateException("Invalid transaction body " + String.valueOf(txBody), e);
        }
    }

    public FeeCalculatorImpl(@Nullable FeeData feeData, @NonNull com.hedera.hapi.node.transaction.ExchangeRate currentRate, CongestionMultipliers congestionMultipliers, ReadableStoreFactory storeFactory, HederaFunctionality functionality, @NonNull FeeSchedule simpleFeesSchedule) {
        if (feeData == null) {
            this.feeData = null;
            this.usage = null;
        } else {
            this.feeData = CommonPbjConverters.fromPbj((FeeData)feeData);
            this.usage = UsageAccumulator.fromGrpc((com.hederahashgraph.api.proto.java.FeeData)this.feeData);
            this.usage.reset();
            this.usage.addBpt(244L);
            this.usage.addBpr(16L);
        }
        this.simpleFeesSchedule = simpleFeesSchedule;
        this.currentRate = CommonPbjConverters.fromPbj((com.hedera.hapi.node.transaction.ExchangeRate)currentRate);
        this.sigUsage = new SigUsage(0, 0, 0);
        this.congestionMultipliers = congestionMultipliers;
        this.storeFactory = storeFactory;
        this.txInfo = new TransactionInfo(SignedTransaction.DEFAULT, TransactionBody.newBuilder().transactionID(TransactionID.newBuilder().accountID(AccountID.DEFAULT).build()).build(), SignatureMap.DEFAULT, Bytes.EMPTY, functionality, null);
    }

    @NonNull
    public FeeCalculator withResourceUsagePercent(double percent) {
        return this;
    }

    @NonNull
    public FeeCalculator addBytesPerTransaction(long bytes) {
        this.failIfLegacyOnly();
        this.usage.addBpt(bytes);
        return this;
    }

    @NonNull
    public FeeCalculator addNetworkRamByteSeconds(long amount) {
        this.failIfLegacyOnly();
        this.usage.addNetworkRbs(amount);
        return this;
    }

    @NonNull
    public FeeCalculator addRamByteSeconds(long amount) {
        this.failIfLegacyOnly();
        this.usage.addRbs(amount);
        return this;
    }

    @NonNull
    public FeeCalculator addStorageBytesSeconds(long seconds) {
        this.failIfLegacyOnly();
        this.usage.addSbs(seconds);
        return this;
    }

    @NonNull
    public FeeCalculator addVerificationsPerTransaction(long amount) {
        this.failIfLegacyOnly();
        this.usage.addVpt(amount);
        return this;
    }

    @NonNull
    public FeeCalculator addGas(long amount) {
        this.failIfLegacyOnly();
        this.usage.addGas(amount);
        return this;
    }

    @NonNull
    public FeeCalculator resetUsage() {
        if (this.usage != null) {
            this.usage.reset();
        }
        return this;
    }

    @NonNull
    public Fees legacyCalculate(@NonNull Function<SigValueObj, com.hederahashgraph.api.proto.java.FeeData> callback) {
        SigValueObj sigValueObject = new SigValueObj(this.sigUsage.numSigs(), this.sigUsage.numPayerKeys(), this.sigUsage.sigsSize());
        com.hederahashgraph.api.proto.java.FeeData matrix = callback.apply(sigValueObject);
        FeeObject feeObject = FeeBuilder.getFeeObject((com.hederahashgraph.api.proto.java.FeeData)this.feeData, (com.hederahashgraph.api.proto.java.FeeData)matrix, (ExchangeRate)this.currentRate, (long)1L);
        return new Fees(feeObject.nodeFee(), feeObject.networkFee(), feeObject.serviceFee());
    }

    @NonNull
    public Fees calculate() {
        this.failIfLegacyOnly();
        OverflowCheckingCalc overflowCalc = new OverflowCheckingCalc();
        FeeObject feeObject = overflowCalc.fees(this.usage, this.feeData, this.currentRate, this.congestionMultipliers.maxCurrentMultiplier(this.txInfo, this.storeFactory));
        return new Fees(feeObject.nodeFee(), feeObject.networkFee(), feeObject.serviceFee());
    }

    public long getCongestionMultiplier() {
        return this.congestionMultipliers.maxCurrentMultiplier(this.txInfo, this.storeFactory);
    }

    private void failIfLegacyOnly() {
        if (this.usage == null) {
            throw new UnsupportedOperationException("Only legacy calculation supported");
        }
    }

    @NonNull
    public FeeSchedule getSimpleFeesSchedule() {
        return this.simpleFeesSchedule;
    }
}

