/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.staking;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.NetworkStakingRewards;
import com.hedera.hapi.node.state.token.StakingNodeInfo;
import com.hedera.node.app.hapi.utils.CommonUtils;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableNetworkStakingRewardsStore;
import com.hedera.node.app.service.token.impl.WritableStakingInfoStore;
import com.hedera.node.app.service.token.impl.comparator.TokenComparators;
import com.hedera.node.app.service.token.impl.handlers.staking.StakingUtilities;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.StakingConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class StakingRewardsHelper {
    private static final Logger log = LogManager.getLogger(StakingRewardsHelper.class);
    public static final long MAX_PENDING_REWARDS = 5000000000000000000L;
    private final boolean assumeContiguousPeriods;

    @Inject
    public StakingRewardsHelper(@NonNull ConfigProvider configProvider) {
        Objects.requireNonNull(configProvider);
        this.assumeContiguousPeriods = ((StakingConfig)configProvider.getConfiguration().getConfigData(StakingConfig.class)).assumeContiguousPeriods();
    }

    public static Set<AccountID> getAllRewardReceivers(WritableAccountStore writableAccountStore, Set<AccountID> stakeToMeRewardReceivers, @NonNull Set<AccountID> explicitRewardReceivers) {
        LinkedHashSet<AccountID> possibleRewardReceivers = new LinkedHashSet<AccountID>(stakeToMeRewardReceivers);
        StakingRewardsHelper.addIdsInRewardSituation(writableAccountStore, writableAccountStore.modifiedAccountsInState(), possibleRewardReceivers, FilterType.IS_CANONICAL_REWARD_SITUATION);
        StakingRewardsHelper.addIdsInRewardSituation(writableAccountStore, explicitRewardReceivers, possibleRewardReceivers, FilterType.IS_STAKED_TO_NODE);
        return possibleRewardReceivers;
    }

    private static void addIdsInRewardSituation(@NonNull WritableAccountStore writableAccountStore, @NonNull Collection<AccountID> ids, @NonNull Set<AccountID> possibleRewardReceivers, @NonNull FilterType filterType) {
        for (AccountID id : ids) {
            if (filterType == FilterType.IS_CANONICAL_REWARD_SITUATION) {
                Account originalAcct;
                Account modifiedAcct = Objects.requireNonNull(writableAccountStore.get(id));
                if (!StakingRewardsHelper.isRewardSituation(modifiedAcct, originalAcct = writableAccountStore.getOriginalValue(id))) continue;
                possibleRewardReceivers.add(id);
                continue;
            }
            if (!StakingRewardsHelper.isCurrentlyStakedToNode(writableAccountStore.get(id))) continue;
            possibleRewardReceivers.add(id);
        }
    }

    private static boolean isRewardSituation(@NonNull Account modifiedAccount, @Nullable Account originalAccount) {
        Objects.requireNonNull(modifiedAccount);
        if (originalAccount == null || originalAccount.stakedNodeIdOrElse(Long.valueOf(-1L)) == -1L) {
            return false;
        }
        boolean hasBalanceChange = modifiedAccount.tinybarBalance() != originalAccount.tinybarBalance();
        boolean hasStakeMetaChanges = StakingUtilities.hasStakeMetaChanges(originalAccount, modifiedAccount);
        return hasBalanceChange || hasStakeMetaChanges;
    }

    public static boolean requiresExternalization(@NonNull Map<AccountID, Long> rewardsPaid) {
        if (rewardsPaid.isEmpty()) {
            return false;
        }
        for (Long reward : rewardsPaid.values()) {
            if (reward == 0L) continue;
            return true;
        }
        return false;
    }

    public void decreasePendingRewardsBy(@NonNull WritableStakingInfoStore stakingInfoStore, @NonNull WritableNetworkStakingRewardsStore stakingRewardsStore, long amount, @NonNull Long nodeId) {
        long currentPendingRewards = stakingRewardsStore.pendingRewards();
        long newPendingRewards = currentPendingRewards - amount;
        if (newPendingRewards < 0L) {
            if (this.assumeContiguousPeriods) {
                log.error("Pending rewards decreased by {} to a meaningless {}, fixing to zero hbar", (Object)amount, (Object)newPendingRewards);
            }
            newPendingRewards = 0L;
        }
        NetworkStakingRewards stakingRewards = stakingRewardsStore.get();
        NetworkStakingRewards.Builder copy = stakingRewards.copyBuilder();
        stakingRewardsStore.put(copy.pendingRewards(newPendingRewards).build());
        StakingNodeInfo stakingInfo = stakingInfoStore.get(nodeId);
        long currentNodePendingRewards = stakingInfo.pendingRewards();
        long newNodePendingRewards = currentNodePendingRewards - amount;
        if (newNodePendingRewards < 0L) {
            if (this.assumeContiguousPeriods) {
                log.error("Pending rewards decreased by {} to a meaningless {} for node {}, fixing to zero hbar", (Object)amount, (Object)newNodePendingRewards, (Object)nodeId);
            }
            newNodePendingRewards = 0L;
        }
        StakingNodeInfo stakingInfoCopy = stakingInfo.copyBuilder().pendingRewards(newNodePendingRewards).build();
        stakingInfoStore.put(nodeId, stakingInfoCopy);
    }

    public StakingNodeInfo increasePendingRewardsBy(@NonNull WritableNetworkStakingRewardsStore stakingRewardsStore, long amount, @NonNull StakingNodeInfo currStakingInfo) {
        long newNodePendingRewards;
        long newNetworkPendingRewards;
        Objects.requireNonNull(stakingRewardsStore);
        Objects.requireNonNull(currStakingInfo);
        long currentPendingRewards = stakingRewardsStore.pendingRewards();
        long nodePendingRewards = currStakingInfo.pendingRewards();
        if (!currStakingInfo.deleted()) {
            newNetworkPendingRewards = CommonUtils.clampedAdd((long)currentPendingRewards, (long)amount);
            newNodePendingRewards = CommonUtils.clampedAdd((long)nodePendingRewards, (long)amount);
        } else {
            newNetworkPendingRewards = currentPendingRewards;
            newNodePendingRewards = 0L;
        }
        if (newNetworkPendingRewards > 5000000000000000000L) {
            log.error("Pending rewards increased by {} to an un-payable {}, fixing to 50B hbar", (Object)amount, (Object)newNetworkPendingRewards);
            newNetworkPendingRewards = 5000000000000000000L;
        }
        if (newNodePendingRewards > 5000000000000000000L) {
            log.error("Pending rewards increased by {} to an un-payable {} for node {}, fixing to 50B hbar", (Object)amount, (Object)newNodePendingRewards, (Object)currStakingInfo.nodeNumber());
            newNodePendingRewards = 5000000000000000000L;
        }
        NetworkStakingRewards stakingRewards = stakingRewardsStore.get();
        NetworkStakingRewards.Builder copy = stakingRewards.copyBuilder();
        stakingRewardsStore.put(copy.pendingRewards(newNetworkPendingRewards).build());
        return currStakingInfo.copyBuilder().pendingRewards(newNodePendingRewards).build();
    }

    public static List<AccountAmount> asAccountAmounts(@NonNull Map<AccountID, Long> balanceAdjustments) {
        ArrayList<AccountAmount> accountAmounts = new ArrayList<AccountAmount>();
        for (Map.Entry<AccountID, Long> entry : balanceAdjustments.entrySet()) {
            if (entry.getValue() == 0L) continue;
            accountAmounts.add(AccountAmount.newBuilder().accountID(entry.getKey()).amount(entry.getValue().longValue()).build());
        }
        accountAmounts.sort(TokenComparators.ACCOUNT_AMOUNT_COMPARATOR);
        return accountAmounts;
    }

    private static boolean isCurrentlyStakedToNode(@Nullable Account account) {
        return account != null && account.stakedNodeIdOrElse(Long.valueOf(-1L)) != -1L;
    }

    private static enum FilterType {
        IS_CANONICAL_REWARD_SITUATION,
        IS_STAKED_TO_NODE;

    }
}

