/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.service.registry.InterceptionContextBlueprint;
import io.helidon.service.registry.ServiceInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.service.registry.InterceptionContextBlueprint")
public interface InterceptionContext
extends InterceptionContextBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(InterceptionContext instance) {
        return (Builder)InterceptionContext.builder().from(instance);
    }

    public static InterceptionContext create() {
        return InterceptionContext.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, InterceptionContext>
    implements io.helidon.common.Builder<Builder, InterceptionContext> {
        private Builder() {
        }

        public InterceptionContext buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.InterceptionContextImpl(this);
        }

        public InterceptionContext build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends InterceptionContext>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final List<Annotation> typeAnnotations = new ArrayList<Annotation>();
        private boolean isTypeAnnotationsMutated;
        private Object serviceInstance;
        private ServiceInfo serviceInfo;
        private TypedElementInfo elementInfo;

        protected BuilderBase() {
        }

        public BUILDER from(InterceptionContext prototype) {
            this.serviceInstance(prototype.serviceInstance());
            this.serviceInfo(prototype.serviceInfo());
            if (!this.isTypeAnnotationsMutated) {
                this.typeAnnotations.clear();
            }
            this.addTypeAnnotations(prototype.typeAnnotations());
            this.elementInfo(prototype.elementInfo());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.serviceInstance().ifPresent(this::serviceInstance);
            builder.serviceInfo().ifPresent(this::serviceInfo);
            if (this.isTypeAnnotationsMutated) {
                if (builder.isTypeAnnotationsMutated) {
                    this.addTypeAnnotations(builder.typeAnnotations);
                }
            } else {
                this.typeAnnotations.clear();
                this.addTypeAnnotations(builder.typeAnnotations);
            }
            builder.elementInfo().ifPresent(this::elementInfo);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearServiceInstance() {
            this.serviceInstance = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceInstance(Object serviceInstance) {
            Objects.requireNonNull(serviceInstance);
            this.serviceInstance = serviceInstance;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceInfo(ServiceInfo serviceInfo) {
            Objects.requireNonNull(serviceInfo);
            this.serviceInfo = serviceInfo;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER typeAnnotations(List<? extends Annotation> typeAnnotations) {
            Objects.requireNonNull(typeAnnotations);
            this.isTypeAnnotationsMutated = true;
            this.typeAnnotations.clear();
            this.typeAnnotations.addAll(typeAnnotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addTypeAnnotations(List<? extends Annotation> typeAnnotations) {
            Objects.requireNonNull(typeAnnotations);
            this.isTypeAnnotationsMutated = true;
            this.typeAnnotations.addAll(typeAnnotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER elementInfo(TypedElementInfo elementInfo) {
            Objects.requireNonNull(elementInfo);
            this.elementInfo = elementInfo;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER elementInfo(Consumer<TypedElementInfo.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypedElementInfo.Builder builder = TypedElementInfo.builder();
            consumer.accept(builder);
            this.elementInfo(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER elementInfo(Supplier<? extends TypedElementInfo> supplier) {
            Objects.requireNonNull(supplier);
            this.elementInfo(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<Object> serviceInstance() {
            return Optional.ofNullable(this.serviceInstance);
        }

        public Optional<ServiceInfo> serviceInfo() {
            return Optional.ofNullable(this.serviceInfo);
        }

        public List<Annotation> typeAnnotations() {
            return this.typeAnnotations;
        }

        public Optional<TypedElementInfo> elementInfo() {
            return Optional.ofNullable(this.elementInfo);
        }

        public String toString() {
            return "InterceptionContextBuilder{serviceInstance=" + String.valueOf(this.serviceInstance) + ",serviceInfo=" + String.valueOf(this.serviceInfo) + ",typeAnnotations=" + String.valueOf(this.typeAnnotations) + ",elementInfo=" + String.valueOf(this.elementInfo) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.serviceInfo == null) {
                collector.fatal(this.getClass(), "Property \"serviceInfo\" must not be null, but not set");
            }
            if (this.elementInfo == null) {
                collector.fatal(this.getClass(), "Property \"elementInfo\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER serviceInstance(Optional<?> serviceInstance) {
            Objects.requireNonNull(serviceInstance);
            this.serviceInstance = serviceInstance.map(Object.class::cast).orElse(this.serviceInstance);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class InterceptionContextImpl
        implements InterceptionContext {
            private final List<Annotation> typeAnnotations;
            private final Optional<Object> serviceInstance;
            private final ServiceInfo serviceInfo;
            private final TypedElementInfo elementInfo;

            protected InterceptionContextImpl(BuilderBase<?, ?> builder) {
                this.serviceInstance = builder.serviceInstance();
                this.serviceInfo = builder.serviceInfo().get();
                this.typeAnnotations = List.copyOf(builder.typeAnnotations());
                this.elementInfo = builder.elementInfo().get();
            }

            @Override
            public Optional<Object> serviceInstance() {
                return this.serviceInstance;
            }

            @Override
            public ServiceInfo serviceInfo() {
                return this.serviceInfo;
            }

            @Override
            public List<Annotation> typeAnnotations() {
                return this.typeAnnotations;
            }

            @Override
            public TypedElementInfo elementInfo() {
                return this.elementInfo;
            }

            public String toString() {
                return "InterceptionContext{serviceInstance=" + String.valueOf(this.serviceInstance) + ",serviceInfo=" + String.valueOf(this.serviceInfo) + ",typeAnnotations=" + String.valueOf(this.typeAnnotations) + ",elementInfo=" + String.valueOf(this.elementInfo) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InterceptionContext)) {
                    return false;
                }
                InterceptionContext other = (InterceptionContext)o;
                return Objects.equals(this.serviceInstance, other.serviceInstance()) && Objects.equals(this.serviceInfo, other.serviceInfo()) && Objects.equals(this.typeAnnotations, other.typeAnnotations()) && Objects.equals(this.elementInfo, other.elementInfo());
            }

            public int hashCode() {
                return Objects.hash(this.serviceInstance, this.serviceInfo, this.typeAnnotations, this.elementInfo);
            }
        }
    }
}

