/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.state.listeners;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.node.app.service.addressbook.ReadableNodeStore;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.file.ReadableUpgradeFileStore;
import com.hedera.node.app.service.networkadmin.ReadableFreezeStore;
import com.hedera.node.app.service.networkadmin.impl.handlers.ReadableFreezeUpgradeActions;
import com.hedera.node.app.service.token.ReadableStakingInfoStore;
import com.hedera.node.app.store.ReadableStoreFactory;
import com.hedera.node.config.ConfigProvider;
import com.swirlds.config.api.Configuration;
import com.swirlds.platform.listeners.ReconnectCompleteListener;
import com.swirlds.platform.listeners.ReconnectCompleteNotification;
import com.swirlds.platform.state.service.ReadablePlatformStateStore;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class ReconnectListener
implements ReconnectCompleteListener {
    private static final Logger log = LogManager.getLogger(ReconnectListener.class);
    private final Executor executor;
    private final ConfigProvider configProvider;
    private final EntityIdFactory entityIdFactory;
    @NonNull
    private final SemanticVersion softwareVersionFactory;

    @Inject
    public ReconnectListener(@Named(value="FreezeService") @NonNull Executor executor, @NonNull ConfigProvider configProvider, @NonNull SemanticVersion softwareVersionFactory, @NonNull EntityIdFactory entityIdFactory) {
        this.executor = Objects.requireNonNull(executor);
        this.configProvider = Objects.requireNonNull(configProvider);
        this.softwareVersionFactory = softwareVersionFactory;
        this.entityIdFactory = entityIdFactory;
    }

    public void notify(@NonNull ReconnectCompleteNotification notification) {
        Objects.requireNonNull(notification);
        log.info("ReconnectCompleteNotification Received: Reconnect Finished. consensusTimestamp: {}, roundNumber: {}, sequence: {}", (Object)notification.getConsensusTimestamp(), (Object)notification.getRoundNumber(), (Object)notification.getSequence());
        State state = notification.getState();
        ReadableStoreFactory readableStoreFactory = new ReadableStoreFactory(state);
        ReadableFreezeStore freezeStore = readableStoreFactory.getStore(ReadableFreezeStore.class);
        ReadableUpgradeFileStore upgradeFileStore = readableStoreFactory.getStore(ReadableUpgradeFileStore.class);
        ReadableNodeStore upgradeNodeStore = readableStoreFactory.getStore(ReadableNodeStore.class);
        ReadableStakingInfoStore upgradeStakingInfoStore = readableStoreFactory.getStore(ReadableStakingInfoStore.class);
        ReadablePlatformStateStore platformStateStore = readableStoreFactory.getStore(ReadablePlatformStateStore.class);
        ReadableFreezeUpgradeActions upgradeActions = new ReadableFreezeUpgradeActions((Configuration)this.configProvider.getConfiguration(), freezeStore, this.executor, upgradeFileStore, upgradeNodeStore, upgradeStakingInfoStore, this.entityIdFactory);
        try {
            upgradeActions.catchUpOnMissedSideEffects(platformStateStore);
        }
        catch (Exception e) {
            log.error("Unable to catch up on missed upgrade side effects after reconnect", (Throwable)e);
        }
    }
}

