/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.ethereum.rlp;

import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.MutableBytes;

class RLPEncodingHelpers {
    private RLPEncodingHelpers() {
    }

    static boolean isSingleRLPByte(Bytes value) {
        return value.size() == 1 && value.get(0) >= 0;
    }

    static boolean isShortElement(Bytes value) {
        return value.size() <= 55;
    }

    static boolean isShortList(int payloadSize) {
        return payloadSize <= 55;
    }

    static int elementSize(Bytes value) {
        if (RLPEncodingHelpers.isSingleRLPByte(value)) {
            return 1;
        }
        if (RLPEncodingHelpers.isShortElement(value)) {
            return 1 + value.size();
        }
        return 1 + RLPEncodingHelpers.sizeLength(value.size()) + value.size();
    }

    static int listSize(int payloadSize) {
        int size = 1 + payloadSize;
        if (!RLPEncodingHelpers.isShortList(payloadSize)) {
            size += RLPEncodingHelpers.sizeLength(payloadSize);
        }
        return size;
    }

    static int writeElement(Bytes value, MutableBytes dest, int destOffset) {
        int size = value.size();
        if (RLPEncodingHelpers.isSingleRLPByte(value)) {
            dest.set(destOffset, value.get(0));
            return destOffset + 1;
        }
        if (RLPEncodingHelpers.isShortElement(value)) {
            dest.set(destOffset, (byte)(128 + size));
            value.copyTo(dest, destOffset + 1);
            return destOffset + 1 + size;
        }
        int offset = RLPEncodingHelpers.writeLongMetadata(183, size, dest, destOffset);
        value.copyTo(dest, offset);
        return offset + size;
    }

    static int writeListHeader(int payloadSize, MutableBytes dest, int destOffset) {
        if (RLPEncodingHelpers.isShortList(payloadSize)) {
            dest.set(destOffset, (byte)(192 + payloadSize));
            return destOffset + 1;
        }
        return RLPEncodingHelpers.writeLongMetadata(247, payloadSize, dest, destOffset);
    }

    private static int writeLongMetadata(int baseCode, int size, MutableBytes dest, int destOffset) {
        int sizeLength = RLPEncodingHelpers.sizeLength(size);
        dest.set(destOffset, (byte)(baseCode + sizeLength));
        int shift = 0;
        for (int i = 0; i < sizeLength; ++i) {
            dest.set(destOffset + sizeLength - i, (byte)(size >> shift));
            shift += 8;
        }
        return destOffset + 1 + sizeLength;
    }

    private static int sizeLength(int size) {
        int zeros = Integer.numberOfLeadingZeros(size);
        return 4 - zeros / 8;
    }
}

