/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.blocks;

import com.hedera.hapi.block.stream.output.MapChangeKey;
import com.hedera.hapi.block.stream.output.MapChangeValue;
import com.hedera.hapi.block.stream.output.QueuePushChange;
import com.hedera.hapi.block.stream.output.SingletonUpdateChange;
import com.hedera.hapi.block.stream.output.StateIdentifier;
import com.hedera.hapi.node.base.TokenAssociation;
import com.hedera.hapi.node.state.common.EntityIDPair;
import com.hedera.hapi.node.state.common.EntityNumber;
import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.hapi.node.state.primitives.ProtoLong;
import com.hedera.hapi.node.state.primitives.ProtoString;
import edu.umd.cs.findbugs.annotations.NonNull;

public final class BlockStreamUtils {
    private static final String UPGRADE_DATA_FILE_NUM_FORMAT = "FileService.UPGRADE_DATA_%d";

    private BlockStreamUtils() {
    }

    public static String stateNameOf(int stateId) {
        return switch (StateIdentifier.fromProtobufOrdinal((int)stateId)) {
            default -> throw new MatchException(null, null);
            case StateIdentifier.UNKNOWN -> throw new IllegalArgumentException("Unknown state identifier");
            case StateIdentifier.STATE_ID_NODES -> "AddressBookService.NODES";
            case StateIdentifier.STATE_ID_ACCOUNT_NODE_REL -> "AddressBookService.ACCOUNT_NODE_REL";
            case StateIdentifier.STATE_ID_BLOCKS -> "BlockRecordService.BLOCKS";
            case StateIdentifier.STATE_ID_RUNNING_HASHES -> "BlockRecordService.RUNNING_HASHES";
            case StateIdentifier.STATE_ID_BLOCK_STREAM_INFO -> "BlockStreamService.BLOCK_STREAM_INFO";
            case StateIdentifier.STATE_ID_CONGESTION_LEVEL_STARTS -> "CongestionThrottleService.CONGESTION_LEVEL_STARTS";
            case StateIdentifier.STATE_ID_THROTTLE_USAGE_SNAPSHOTS -> "CongestionThrottleService.THROTTLE_USAGE_SNAPSHOTS";
            case StateIdentifier.STATE_ID_TOPICS -> "ConsensusService.TOPICS";
            case StateIdentifier.STATE_ID_BYTECODE -> "ContractService.BYTECODE";
            case StateIdentifier.STATE_ID_STORAGE -> "ContractService.STORAGE";
            case StateIdentifier.STATE_ID_EVM_HOOK_STATES -> "ContractService.EVM_HOOK_STATES";
            case StateIdentifier.STATE_ID_LAMBDA_STORAGE -> "ContractService.LAMBDA_STORAGE";
            case StateIdentifier.STATE_ID_ENTITY_ID -> "EntityIdService.ENTITY_ID";
            case StateIdentifier.STATE_ID_MIDNIGHT_RATES -> "FeeService.MIDNIGHT_RATES";
            case StateIdentifier.STATE_ID_FILES -> "FileService.FILES";
            case StateIdentifier.STATE_ID_UPGRADE_DATA_150 -> UPGRADE_DATA_FILE_NUM_FORMAT.formatted(150);
            case StateIdentifier.STATE_ID_UPGRADE_DATA_151 -> UPGRADE_DATA_FILE_NUM_FORMAT.formatted(151);
            case StateIdentifier.STATE_ID_UPGRADE_DATA_152 -> UPGRADE_DATA_FILE_NUM_FORMAT.formatted(152);
            case StateIdentifier.STATE_ID_UPGRADE_DATA_153 -> UPGRADE_DATA_FILE_NUM_FORMAT.formatted(153);
            case StateIdentifier.STATE_ID_UPGRADE_DATA_154 -> UPGRADE_DATA_FILE_NUM_FORMAT.formatted(154);
            case StateIdentifier.STATE_ID_UPGRADE_DATA_155 -> UPGRADE_DATA_FILE_NUM_FORMAT.formatted(155);
            case StateIdentifier.STATE_ID_UPGRADE_DATA_156 -> UPGRADE_DATA_FILE_NUM_FORMAT.formatted(156);
            case StateIdentifier.STATE_ID_UPGRADE_DATA_157 -> UPGRADE_DATA_FILE_NUM_FORMAT.formatted(157);
            case StateIdentifier.STATE_ID_UPGRADE_DATA_158 -> UPGRADE_DATA_FILE_NUM_FORMAT.formatted(158);
            case StateIdentifier.STATE_ID_UPGRADE_DATA_159 -> UPGRADE_DATA_FILE_NUM_FORMAT.formatted(159);
            case StateIdentifier.STATE_ID_FREEZE_TIME -> "FreezeService.FREEZE_TIME";
            case StateIdentifier.STATE_ID_UPGRADE_FILE_HASH -> "FreezeService.UPGRADE_FILE_HASH";
            case StateIdentifier.STATE_ID_PLATFORM_STATE -> "PlatformStateService.PLATFORM_STATE";
            case StateIdentifier.STATE_ID_ROSTER_STATE -> "RosterService.ROSTER_STATE";
            case StateIdentifier.STATE_ID_ROSTERS -> "RosterService.ROSTERS";
            case StateIdentifier.STATE_ID_ENTITY_COUNTS -> "EntityIdService.ENTITY_COUNTS";
            case StateIdentifier.STATE_ID_TRANSACTION_RECEIPTS -> "RecordCache.TRANSACTION_RECEIPTS";
            case StateIdentifier.STATE_ID_SCHEDULES_BY_EQUALITY -> "ScheduleService.SCHEDULES_BY_EQUALITY";
            case StateIdentifier.STATE_ID_SCHEDULES_BY_EXPIRY_SEC -> "ScheduleService.SCHEDULES_BY_EXPIRY_SEC";
            case StateIdentifier.STATE_ID_SCHEDULES_BY_ID -> "ScheduleService.SCHEDULES_BY_ID";
            case StateIdentifier.STATE_ID_SCHEDULE_ID_BY_EQUALITY -> "ScheduleService.SCHEDULE_ID_BY_EQUALITY";
            case StateIdentifier.STATE_ID_SCHEDULED_COUNTS -> "ScheduleService.SCHEDULED_COUNTS";
            case StateIdentifier.STATE_ID_SCHEDULED_ORDERS -> "ScheduleService.SCHEDULED_ORDERS";
            case StateIdentifier.STATE_ID_SCHEDULED_USAGES -> "ScheduleService.SCHEDULED_USAGES";
            case StateIdentifier.STATE_ID_ACCOUNTS -> "TokenService.ACCOUNTS";
            case StateIdentifier.STATE_ID_ALIASES -> "TokenService.ALIASES";
            case StateIdentifier.STATE_ID_NFTS -> "TokenService.NFTS";
            case StateIdentifier.STATE_ID_PENDING_AIRDROPS -> "TokenService.PENDING_AIRDROPS";
            case StateIdentifier.STATE_ID_STAKING_INFOS -> "TokenService.STAKING_INFOS";
            case StateIdentifier.STATE_ID_STAKING_NETWORK_REWARDS -> "TokenService.STAKING_NETWORK_REWARDS";
            case StateIdentifier.STATE_ID_TOKEN_RELS -> "TokenService.TOKEN_RELS";
            case StateIdentifier.STATE_ID_TOKENS -> "TokenService.TOKENS";
            case StateIdentifier.STATE_ID_TSS_MESSAGES -> "TssBaseService.TSS_MESSAGES";
            case StateIdentifier.STATE_ID_TSS_VOTES -> "TssBaseService.TSS_VOTES";
            case StateIdentifier.STATE_ID_TSS_ENCRYPTION_KEYS -> "TssBaseService.TSS_ENCRYPTION_KEYS";
            case StateIdentifier.STATE_ID_TSS_STATUS -> "TssBaseService.TSS_STATUS";
            case StateIdentifier.STATE_ID_HINTS_KEY_SETS -> "HintsService.HINTS_KEY_SETS";
            case StateIdentifier.STATE_ID_ACTIVE_HINTS_CONSTRUCTION -> "HintsService.ACTIVE_HINTS_CONSTRUCTION";
            case StateIdentifier.STATE_ID_NEXT_HINTS_CONSTRUCTION -> "HintsService.NEXT_HINTS_CONSTRUCTION";
            case StateIdentifier.STATE_ID_PREPROCESSING_VOTES -> "HintsService.PREPROCESSING_VOTES";
            case StateIdentifier.STATE_ID_LEDGER_ID -> "HistoryService.LEDGER_ID";
            case StateIdentifier.STATE_ID_PROOF_KEY_SETS -> "HistoryService.PROOF_KEY_SETS";
            case StateIdentifier.STATE_ID_ACTIVE_PROOF_CONSTRUCTION -> "HistoryService.ACTIVE_PROOF_CONSTRUCTION";
            case StateIdentifier.STATE_ID_NEXT_PROOF_CONSTRUCTION -> "HistoryService.NEXT_PROOF_CONSTRUCTION";
            case StateIdentifier.STATE_ID_HISTORY_SIGNATURES -> "HistoryService.HISTORY_SIGNATURES";
            case StateIdentifier.STATE_ID_PROOF_VOTES -> "HistoryService.PROOF_VOTES";
            case StateIdentifier.STATE_ID_CRS_STATE -> "HintsService.CRS_STATE";
            case StateIdentifier.STATE_ID_CRS_PUBLICATIONS -> "HintsService.CRS_PUBLICATIONS";
            case StateIdentifier.STATE_ID_NODE_REWARDS -> "TokenService.NODE_REWARDS";
        };
    }

    public static Object singletonPutFor(@NonNull SingletonUpdateChange singletonUpdateChange) {
        return switch ((SingletonUpdateChange.NewValueOneOfType)singletonUpdateChange.newValue().kind()) {
            default -> throw new MatchException(null, null);
            case SingletonUpdateChange.NewValueOneOfType.UNSET -> throw new IllegalStateException("Singleton update value is not set");
            case SingletonUpdateChange.NewValueOneOfType.BLOCK_INFO_VALUE -> singletonUpdateChange.blockInfoValueOrThrow();
            case SingletonUpdateChange.NewValueOneOfType.CONGESTION_LEVEL_STARTS_VALUE -> singletonUpdateChange.congestionLevelStartsValueOrThrow();
            case SingletonUpdateChange.NewValueOneOfType.ENTITY_NUMBER_VALUE -> new EntityNumber(singletonUpdateChange.entityNumberValueOrThrow().longValue());
            case SingletonUpdateChange.NewValueOneOfType.EXCHANGE_RATE_SET_VALUE -> singletonUpdateChange.exchangeRateSetValueOrThrow();
            case SingletonUpdateChange.NewValueOneOfType.NETWORK_STAKING_REWARDS_VALUE -> singletonUpdateChange.networkStakingRewardsValueOrThrow();
            case SingletonUpdateChange.NewValueOneOfType.NODE_REWARDS_VALUE -> singletonUpdateChange.nodeRewardsValueOrThrow();
            case SingletonUpdateChange.NewValueOneOfType.BYTES_VALUE -> new ProtoBytes(singletonUpdateChange.bytesValueOrThrow());
            case SingletonUpdateChange.NewValueOneOfType.STRING_VALUE -> new ProtoString(singletonUpdateChange.stringValueOrThrow());
            case SingletonUpdateChange.NewValueOneOfType.RUNNING_HASHES_VALUE -> singletonUpdateChange.runningHashesValueOrThrow();
            case SingletonUpdateChange.NewValueOneOfType.THROTTLE_USAGE_SNAPSHOTS_VALUE -> singletonUpdateChange.throttleUsageSnapshotsValueOrThrow();
            case SingletonUpdateChange.NewValueOneOfType.TIMESTAMP_VALUE -> singletonUpdateChange.timestampValueOrThrow();
            case SingletonUpdateChange.NewValueOneOfType.BLOCK_STREAM_INFO_VALUE -> singletonUpdateChange.blockStreamInfoValueOrThrow();
            case SingletonUpdateChange.NewValueOneOfType.PLATFORM_STATE_VALUE -> singletonUpdateChange.platformStateValueOrThrow();
            case SingletonUpdateChange.NewValueOneOfType.ROSTER_STATE_VALUE -> singletonUpdateChange.rosterStateValueOrThrow();
            case SingletonUpdateChange.NewValueOneOfType.HINTS_CONSTRUCTION_VALUE -> singletonUpdateChange.hintsConstructionValueOrThrow();
            case SingletonUpdateChange.NewValueOneOfType.ENTITY_COUNTS_VALUE -> singletonUpdateChange.entityCountsValueOrThrow();
            case SingletonUpdateChange.NewValueOneOfType.HISTORY_PROOF_CONSTRUCTION_VALUE -> singletonUpdateChange.historyProofConstructionValueOrThrow();
            case SingletonUpdateChange.NewValueOneOfType.CRS_STATE_VALUE -> singletonUpdateChange.crsStateValueOrThrow();
        };
    }

    public static Object queuePushFor(@NonNull QueuePushChange queuePushChange) {
        return switch ((QueuePushChange.ValueOneOfType)queuePushChange.value().kind()) {
            default -> throw new MatchException(null, null);
            case QueuePushChange.ValueOneOfType.UNSET, QueuePushChange.ValueOneOfType.PROTO_STRING_ELEMENT -> throw new IllegalStateException("Queue push value is not supported");
            case QueuePushChange.ValueOneOfType.PROTO_BYTES_ELEMENT -> new ProtoBytes(queuePushChange.protoBytesElementOrThrow());
            case QueuePushChange.ValueOneOfType.TRANSACTION_RECEIPT_ENTRIES_ELEMENT -> queuePushChange.transactionReceiptEntriesElementOrThrow();
        };
    }

    public static Object mapKeyFor(@NonNull MapChangeKey mapChangeKey) {
        return switch ((MapChangeKey.KeyChoiceOneOfType)mapChangeKey.keyChoice().kind()) {
            default -> throw new MatchException(null, null);
            case MapChangeKey.KeyChoiceOneOfType.UNSET -> throw new IllegalStateException("Key choice is not set for " + String.valueOf(mapChangeKey));
            case MapChangeKey.KeyChoiceOneOfType.ACCOUNT_ID_KEY -> mapChangeKey.accountIdKeyOrThrow();
            case MapChangeKey.KeyChoiceOneOfType.TOKEN_RELATIONSHIP_KEY -> BlockStreamUtils.pairFrom(mapChangeKey.tokenRelationshipKeyOrThrow());
            case MapChangeKey.KeyChoiceOneOfType.ENTITY_NUMBER_KEY -> new EntityNumber(mapChangeKey.entityNumberKeyOrThrow().longValue());
            case MapChangeKey.KeyChoiceOneOfType.FILE_ID_KEY -> mapChangeKey.fileIdKeyOrThrow();
            case MapChangeKey.KeyChoiceOneOfType.NFT_ID_KEY -> mapChangeKey.nftIdKeyOrThrow();
            case MapChangeKey.KeyChoiceOneOfType.PROTO_BYTES_KEY -> new ProtoBytes(mapChangeKey.protoBytesKeyOrThrow());
            case MapChangeKey.KeyChoiceOneOfType.PROTO_LONG_KEY -> new ProtoLong(mapChangeKey.protoLongKeyOrThrow().longValue());
            case MapChangeKey.KeyChoiceOneOfType.PROTO_STRING_KEY -> new ProtoString(mapChangeKey.protoStringKeyOrThrow());
            case MapChangeKey.KeyChoiceOneOfType.SCHEDULE_ID_KEY -> mapChangeKey.scheduleIdKeyOrThrow();
            case MapChangeKey.KeyChoiceOneOfType.SLOT_KEY_KEY -> mapChangeKey.slotKeyKeyOrThrow();
            case MapChangeKey.KeyChoiceOneOfType.TOKEN_ID_KEY -> mapChangeKey.tokenIdKeyOrThrow();
            case MapChangeKey.KeyChoiceOneOfType.TOPIC_ID_KEY -> mapChangeKey.topicIdKeyOrThrow();
            case MapChangeKey.KeyChoiceOneOfType.CONTRACT_ID_KEY -> mapChangeKey.contractIdKeyOrThrow();
            case MapChangeKey.KeyChoiceOneOfType.PENDING_AIRDROP_ID_KEY -> mapChangeKey.pendingAirdropIdKeyOrThrow();
            case MapChangeKey.KeyChoiceOneOfType.TIMESTAMP_SECONDS_KEY -> mapChangeKey.timestampSecondsKeyOrThrow();
            case MapChangeKey.KeyChoiceOneOfType.SCHEDULED_ORDER_KEY -> mapChangeKey.scheduledOrderKeyOrThrow();
            case MapChangeKey.KeyChoiceOneOfType.TSS_MESSAGE_MAP_KEY -> mapChangeKey.tssMessageMapKeyOrThrow();
            case MapChangeKey.KeyChoiceOneOfType.TSS_VOTE_MAP_KEY -> mapChangeKey.tssVoteMapKeyOrThrow();
            case MapChangeKey.KeyChoiceOneOfType.HINTS_PARTY_ID_KEY -> mapChangeKey.hintsPartyIdKeyOrThrow();
            case MapChangeKey.KeyChoiceOneOfType.PREPROCESSING_VOTE_ID_KEY -> mapChangeKey.preprocessingVoteIdKeyOrThrow();
            case MapChangeKey.KeyChoiceOneOfType.NODE_ID_KEY -> mapChangeKey.nodeIdKeyOrThrow();
            case MapChangeKey.KeyChoiceOneOfType.CONSTRUCTION_NODE_ID_KEY -> mapChangeKey.constructionNodeIdKeyOrThrow();
            case MapChangeKey.KeyChoiceOneOfType.HOOK_ID_KEY -> mapChangeKey.hookIdKeyOrThrow();
            case MapChangeKey.KeyChoiceOneOfType.LAMBDA_SLOT_KEY -> mapChangeKey.lambdaSlotKeyOrThrow();
        };
    }

    public static Object mapValueFor(@NonNull MapChangeValue mapChangeValue) {
        return switch ((MapChangeValue.ValueChoiceOneOfType)mapChangeValue.valueChoice().kind()) {
            default -> throw new MatchException(null, null);
            case MapChangeValue.ValueChoiceOneOfType.UNSET -> throw new IllegalStateException("Value choice is not set for " + String.valueOf(mapChangeValue));
            case MapChangeValue.ValueChoiceOneOfType.ACCOUNT_VALUE -> mapChangeValue.accountValueOrThrow();
            case MapChangeValue.ValueChoiceOneOfType.ACCOUNT_ID_VALUE -> mapChangeValue.accountIdValueOrThrow();
            case MapChangeValue.ValueChoiceOneOfType.BYTECODE_VALUE -> mapChangeValue.bytecodeValueOrThrow();
            case MapChangeValue.ValueChoiceOneOfType.FILE_VALUE -> mapChangeValue.fileValueOrThrow();
            case MapChangeValue.ValueChoiceOneOfType.NFT_VALUE -> mapChangeValue.nftValueOrThrow();
            case MapChangeValue.ValueChoiceOneOfType.PROTO_STRING_VALUE -> new ProtoString(mapChangeValue.protoStringValueOrThrow());
            case MapChangeValue.ValueChoiceOneOfType.SCHEDULE_VALUE -> mapChangeValue.scheduleValueOrThrow();
            case MapChangeValue.ValueChoiceOneOfType.SCHEDULE_ID_VALUE -> mapChangeValue.scheduleIdValueOrThrow();
            case MapChangeValue.ValueChoiceOneOfType.SCHEDULE_LIST_VALUE -> mapChangeValue.scheduleListValueOrThrow();
            case MapChangeValue.ValueChoiceOneOfType.SLOT_VALUE_VALUE -> mapChangeValue.slotValueValueOrThrow();
            case MapChangeValue.ValueChoiceOneOfType.STAKING_NODE_INFO_VALUE -> mapChangeValue.stakingNodeInfoValueOrThrow();
            case MapChangeValue.ValueChoiceOneOfType.TOKEN_VALUE -> mapChangeValue.tokenValueOrThrow();
            case MapChangeValue.ValueChoiceOneOfType.TOKEN_RELATION_VALUE -> mapChangeValue.tokenRelationValueOrThrow();
            case MapChangeValue.ValueChoiceOneOfType.TOPIC_VALUE -> mapChangeValue.topicValueOrThrow();
            case MapChangeValue.ValueChoiceOneOfType.NODE_VALUE -> mapChangeValue.nodeValueOrThrow();
            case MapChangeValue.ValueChoiceOneOfType.ACCOUNT_PENDING_AIRDROP_VALUE -> mapChangeValue.accountPendingAirdropValueOrThrow();
            case MapChangeValue.ValueChoiceOneOfType.ROSTER_VALUE -> mapChangeValue.rosterValueOrThrow();
            case MapChangeValue.ValueChoiceOneOfType.SCHEDULED_COUNTS_VALUE -> mapChangeValue.scheduledCountsValueOrThrow();
            case MapChangeValue.ValueChoiceOneOfType.THROTTLE_USAGE_SNAPSHOTS_VALUE -> mapChangeValue.throttleUsageSnapshotsValue();
            case MapChangeValue.ValueChoiceOneOfType.TSS_ENCRYPTION_KEYS_VALUE -> mapChangeValue.tssEncryptionKeysValue();
            case MapChangeValue.ValueChoiceOneOfType.TSS_MESSAGE_VALUE -> mapChangeValue.tssMessageValueOrThrow();
            case MapChangeValue.ValueChoiceOneOfType.TSS_VOTE_VALUE -> mapChangeValue.tssVoteValueOrThrow();
            case MapChangeValue.ValueChoiceOneOfType.HINTS_KEY_SET_VALUE -> mapChangeValue.hintsKeySetValueOrThrow();
            case MapChangeValue.ValueChoiceOneOfType.PREPROCESSING_VOTE_VALUE -> mapChangeValue.preprocessingVoteValueOrThrow();
            case MapChangeValue.ValueChoiceOneOfType.CRS_PUBLICATION_VALUE -> mapChangeValue.crsPublicationValueOrThrow();
            case MapChangeValue.ValueChoiceOneOfType.HISTORY_PROOF_VOTE_VALUE -> mapChangeValue.historyProofVoteValue();
            case MapChangeValue.ValueChoiceOneOfType.HISTORY_SIGNATURE_VALUE -> mapChangeValue.historySignatureValue();
            case MapChangeValue.ValueChoiceOneOfType.PROOF_KEY_SET_VALUE -> mapChangeValue.proofKeySetValue();
            case MapChangeValue.ValueChoiceOneOfType.EVM_HOOK_STATE_VALUE -> mapChangeValue.evmHookStateValueOrThrow();
            case MapChangeValue.ValueChoiceOneOfType.NODE_ID_VALUE -> mapChangeValue.nodeIdValueOrThrow();
        };
    }

    public static EntityIDPair pairFrom(@NonNull TokenAssociation tokenAssociation) {
        return new EntityIDPair(tokenAssociation.accountId(), tokenAssociation.tokenId());
    }
}

