/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage.crypto;

import com.hedera.node.app.hapi.fees.usage.crypto.AllowanceId;
import com.hederahashgraph.api.proto.java.CryptoAllowance;
import com.hederahashgraph.api.proto.java.GrantedCryptoAllowance;
import com.hederahashgraph.api.proto.java.GrantedNftAllowance;
import com.hederahashgraph.api.proto.java.GrantedTokenAllowance;
import com.hederahashgraph.api.proto.java.NftAllowance;
import com.hederahashgraph.api.proto.java.TokenAllowance;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CryptoContextUtils {
    private CryptoContextUtils() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static Map<Long, Long> convertToCryptoMapFromGranted(List<GrantedCryptoAllowance> allowances) {
        HashMap<Long, Long> allowanceMap = new HashMap<Long, Long>();
        for (GrantedCryptoAllowance a : allowances) {
            allowanceMap.put(a.getSpender().getAccountNum(), a.getAmount());
        }
        return allowanceMap;
    }

    public static Map<AllowanceId, Long> convertToTokenMapFromGranted(List<GrantedTokenAllowance> allowances) {
        HashMap<AllowanceId, Long> allowanceMap = new HashMap<AllowanceId, Long>();
        for (GrantedTokenAllowance a : allowances) {
            allowanceMap.put(new AllowanceId(a.getTokenId().getTokenNum(), a.getSpender().getAccountNum()), a.getAmount());
        }
        return allowanceMap;
    }

    public static Set<AllowanceId> convertToNftMapFromGranted(List<GrantedNftAllowance> allowances) {
        HashSet<AllowanceId> approveForAllAllowances = new HashSet<AllowanceId>();
        for (GrantedNftAllowance a : allowances) {
            approveForAllAllowances.add(new AllowanceId(a.getTokenId().getTokenNum(), a.getSpender().getAccountNum()));
        }
        return approveForAllAllowances;
    }

    public static Map<Long, Long> convertToCryptoMap(List<CryptoAllowance> allowances) {
        HashMap<Long, Long> allowanceMap = new HashMap<Long, Long>();
        for (CryptoAllowance a : allowances) {
            allowanceMap.put(a.getSpender().getAccountNum(), a.getAmount());
        }
        return allowanceMap;
    }

    public static Map<AllowanceId, Long> convertToTokenMap(List<TokenAllowance> allowances) {
        HashMap<AllowanceId, Long> allowanceMap = new HashMap<AllowanceId, Long>();
        for (TokenAllowance a : allowances) {
            allowanceMap.put(new AllowanceId(a.getTokenId().getTokenNum(), a.getSpender().getAccountNum()), a.getAmount());
        }
        return allowanceMap;
    }

    public static Set<AllowanceId> convertToNftMap(List<NftAllowance> allowances) {
        HashSet<AllowanceId> allowanceMap = new HashSet<AllowanceId>();
        for (NftAllowance a : allowances) {
            allowanceMap.add(new AllowanceId(a.getTokenId().getTokenNum(), a.getSpender().getAccountNum()));
        }
        return allowanceMap;
    }

    public static int countSerials(List<NftAllowance> nftAllowancesList) {
        int totalSerials = 0;
        for (NftAllowance allowance : nftAllowancesList) {
            totalSerials += allowance.getSerialNumbersCount();
        }
        return totalSerials;
    }

    static int getChangedCryptoKeys(Set<Long> newKeys, Set<Long> existingKeys) {
        int counter = 0;
        for (Long key : newKeys) {
            if (existingKeys.contains(key)) continue;
            ++counter;
        }
        return counter;
    }

    static int getChangedTokenKeys(Set<AllowanceId> newKeys, Set<AllowanceId> existingKeys) {
        int counter = 0;
        for (AllowanceId key : newKeys) {
            if (existingKeys.contains(key)) continue;
            ++counter;
        }
        return counter;
    }
}

