/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.metrics;

import com.hedera.node.app.service.contract.impl.exec.metrics.CountAccumulateAverageMetricTriplet;
import com.hedera.node.app.service.contract.impl.exec.metrics.PrecompileOpsDurationMetric;
import com.hedera.node.app.service.contract.impl.exec.metrics.SystemContractOpsDurationMetric;
import com.hedera.node.app.service.contract.impl.exec.metrics.TransactionThrottledByOpsDurationMetric;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class OpsDurationMetrics {
    private final SystemContractOpsDurationMetric systemContractOpsDurationMetric;
    private final PrecompileOpsDurationMetric precompileOpsDurationMetric;
    private final TransactionThrottledByOpsDurationMetric transactionThrottledByOpsDurationMetric;
    private final CountAccumulateAverageMetricTriplet perTransactionOpsDuration;

    public OpsDurationMetrics(@NonNull Metrics metrics) {
        Objects.requireNonNull(metrics, "Metrics cannot be null");
        this.systemContractOpsDurationMetric = new SystemContractOpsDurationMetric(metrics);
        this.precompileOpsDurationMetric = new PrecompileOpsDurationMetric(metrics);
        this.transactionThrottledByOpsDurationMetric = new TransactionThrottledByOpsDurationMetric(metrics);
        this.perTransactionOpsDuration = CountAccumulateAverageMetricTriplet.create(metrics, "app", String.format("%s:OpsDuration_PerTxn", "SmartContractService"), "Ops duration of all transaction in nanoseconds");
    }

    public void recordSystemContractOpsDuration(@NonNull String systemContractName, @NonNull String systemContractAddress, long durationNanos) {
        this.systemContractOpsDurationMetric.recordOperationDuration(systemContractName, systemContractAddress, durationNanos);
    }

    public void recordPrecompileOpsDuration(@NonNull String precompile, long durationNanos) {
        this.precompileOpsDurationMetric.recordPrecompileDuration(precompile, durationNanos);
    }

    public double getAveragePrecompileOpsDuration(@NonNull String precompile) {
        return this.precompileOpsDurationMetric.getAveragePrecompileDuration(precompile);
    }

    public long getPrecompileOpsDurationCount(@NonNull String precompile) {
        return this.precompileOpsDurationMetric.getPrecompileOpsDurationCount(precompile);
    }

    public long getTotalPrecompileOpsDuration(@NonNull String precompile) {
        return this.precompileOpsDurationMetric.getPrecompileOpsTotalDuration(precompile);
    }

    public void recordTxnTotalOpsDuration(long opsDurationNanos) {
        this.perTransactionOpsDuration.recordObservation(opsDurationNanos);
    }

    public double getAverageTransactionOpsDuration() {
        return this.perTransactionOpsDuration.average().get();
    }

    public long getTransactionOpsDurationCount() {
        return this.perTransactionOpsDuration.counter().get();
    }

    public long getTotalTransactionOpsDuration() {
        return this.perTransactionOpsDuration.accumulator().get();
    }

    public void recordTransactionThrottledByOpsDuration() {
        this.transactionThrottledByOpsDurationMetric.increment();
    }

    public long getTransactionsThrottledByOpsDurationCount() {
        return this.transactionThrottledByOpsDurationMetric.getCount();
    }
}

