/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.hevm;

import com.hedera.node.app.service.contract.impl.annotations.QueryScope;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmBlocks;
import com.hedera.node.app.service.contract.impl.hevm.HevmBlockValues;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.evm.frame.BlockValues;
import org.hyperledger.besu.evm.frame.MessageFrame;

@QueryScope
public class QueryContextHevmBlocks
implements HederaEvmBlocks {
    private final QueryContext context;

    @Inject
    public QueryContextHevmBlocks(@NonNull QueryContext context) {
        this.context = Objects.requireNonNull(context);
    }

    @Override
    public Hash blockHashOf(MessageFrame frame, long blockNo) {
        Bytes hederaBlockHash = this.context.blockRecordInfo().blockHashByBlockNumber(blockNo);
        return hederaBlockHash == null ? UNAVAILABLE_BLOCK_HASH : ConversionUtils.ethHashFrom(hederaBlockHash);
    }

    @Override
    public BlockValues blockValuesOf(long gasLimit) {
        return HevmBlockValues.from(this.context.blockRecordInfo(), gasLimit);
    }
}

