/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.nativelib.gnark;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.ptr.IntByReference;
import org.hyperledger.besu.nativelib.gnark.LibGnarkUtils;

public class LibGnarkEIP2537
implements Library {
    public static final boolean ENABLED;
    private static int degreeOfMSMParallelism;
    public static final int EIP2537_PREALLOCATE_FOR_RESULT_BYTES = 256;
    public static final int EIP2537_PREALLOCATE_FOR_ERROR_BYTES = 256;
    public static final byte BLS12_G1ADD_OPERATION_SHIM_VALUE = 1;
    public static final byte BLS12_G1MUL_OPERATION_SHIM_VALUE = 2;
    public static final byte BLS12_G1MULTIEXP_OPERATION_SHIM_VALUE = 3;
    public static final byte BLS12_G2ADD_OPERATION_SHIM_VALUE = 4;
    public static final byte BLS12_G2MUL_OPERATION_SHIM_VALUE = 5;
    public static final byte BLS12_G2MULTIEXP_OPERATION_SHIM_VALUE = 6;
    public static final byte BLS12_PAIR_OPERATION_SHIM_VALUE = 7;
    public static final byte BLS12_MAP_FP_TO_G1_OPERATION_SHIM_VALUE = 8;
    public static final byte BLS12_MAP_FP2_TO_G2_OPERATION_SHIM_VALUE = 9;

    public static int eip2537_perform_operation(byte op, byte[] i, int i_len, byte[] output, IntByReference o_len, byte[] err, IntByReference err_len) {
        int ret = -1;
        switch (op) {
            case 1: {
                ret = LibGnarkEIP2537.eip2537blsG1Add(i, output, err, i_len, 256, 256);
                o_len.setValue(128);
                break;
            }
            case 2: {
                ret = LibGnarkEIP2537.eip2537blsG1Mul(i, output, err, i_len, 256, 256);
                o_len.setValue(128);
                break;
            }
            case 3: {
                ret = i.length <= 384 ? LibGnarkEIP2537.eip2537blsG1MultiExp(i, output, err, i_len, 256, 256) : LibGnarkEIP2537.eip2537blsG1MultiExpParallel(i, output, err, i_len, 256, 256, degreeOfMSMParallelism);
                o_len.setValue(128);
                break;
            }
            case 4: {
                ret = LibGnarkEIP2537.eip2537blsG2Add(i, output, err, i_len, 256, 256);
                o_len.setValue(256);
                break;
            }
            case 5: {
                ret = LibGnarkEIP2537.eip2537blsG2Mul(i, output, err, i_len, 256, 256);
                o_len.setValue(256);
                break;
            }
            case 6: {
                ret = i.length <= 576 ? LibGnarkEIP2537.eip2537blsG2MultiExp(i, output, err, i_len, 256, 256) : LibGnarkEIP2537.eip2537blsG2MultiExpParallel(i, output, err, i_len, 256, 256, degreeOfMSMParallelism);
                o_len.setValue(256);
                break;
            }
            case 7: {
                ret = LibGnarkEIP2537.eip2537blsPairing(i, output, err, i_len, 256, 256);
                o_len.setValue(32);
                break;
            }
            case 8: {
                ret = LibGnarkEIP2537.eip2537blsMapFpToG1(i, output, err, i_len, 256, 256);
                o_len.setValue(128);
                break;
            }
            case 9: {
                ret = LibGnarkEIP2537.eip2537blsMapFp2ToG2(i, output, err, i_len, 256, 256);
                o_len.setValue(256);
                break;
            }
            default: {
                throw new RuntimeException("Not Implemented EIP-2537 operation " + op);
            }
        }
        if (ret != 0) {
            err_len.setValue(LibGnarkUtils.findFirstTrailingZeroIndex(err));
            o_len.setValue(0);
        } else {
            err_len.setValue(0);
        }
        return ret;
    }

    public static native int eip2537blsG1Add(byte[] var0, byte[] var1, byte[] var2, int var3, int var4, int var5);

    public static native int eip2537blsG1Mul(byte[] var0, byte[] var1, byte[] var2, int var3, int var4, int var5);

    public static native int eip2537blsG1MultiExp(byte[] var0, byte[] var1, byte[] var2, int var3, int var4, int var5);

    public static native int eip2537blsG1MultiExpParallel(byte[] var0, byte[] var1, byte[] var2, int var3, int var4, int var5, int var6);

    public static native int eip2537blsG2Add(byte[] var0, byte[] var1, byte[] var2, int var3, int var4, int var5);

    public static native int eip2537blsG2Mul(byte[] var0, byte[] var1, byte[] var2, int var3, int var4, int var5);

    public static native int eip2537blsG2MultiExp(byte[] var0, byte[] var1, byte[] var2, int var3, int var4, int var5);

    public static native int eip2537blsG2MultiExpParallel(byte[] var0, byte[] var1, byte[] var2, int var3, int var4, int var5, int var6);

    public static native int eip2537blsPairing(byte[] var0, byte[] var1, byte[] var2, int var3, int var4, int var5);

    public static native int eip2537blsMapFpToG1(byte[] var0, byte[] var1, byte[] var2, int var3, int var4, int var5);

    public static native int eip2537blsMapFp2ToG2(byte[] var0, byte[] var1, byte[] var2, int var3, int var4, int var5);

    public static void setDegreeOfMSMParallelism(int nbTasks) {
        degreeOfMSMParallelism = nbTasks;
    }

    static {
        boolean enabled;
        degreeOfMSMParallelism = 0;
        try {
            Native.register(LibGnarkEIP2537.class, (String)"gnark_eip_2537");
            enabled = true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            enabled = false;
        }
        ENABLED = enabled;
    }
}

