/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.handlers;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.QueryHeader;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ResponseHeader;
import com.hedera.hapi.node.base.ResponseType;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.contract.ContractCallLocalQuery;
import com.hedera.hapi.node.contract.ContractCallLocalResponse;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.hapi.node.transaction.Response;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.fee.SmartContractFeeBuilder;
import com.hedera.node.app.service.contract.impl.exec.CallOutcome;
import com.hedera.node.app.service.contract.impl.exec.QueryComponent;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.contract.impl.utils.ValidationUtils;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.validation.Validations;
import com.hedera.node.app.spi.workflows.PaidQueryHandler;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.hedera.node.config.data.ContractsConfig;
import com.hederahashgraph.api.proto.java.ContractFunctionResult;
import com.hederahashgraph.api.proto.java.FeeData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.InstantSource;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;

@Singleton
public class ContractCallLocalHandler
extends PaidQueryHandler {
    private final Provider<QueryComponent.Factory> provider;
    private final GasCalculator gasCalculator;
    private final InstantSource instantSource;
    private final EntityIdFactory entityIdFactory;

    @Inject
    public ContractCallLocalHandler(@NonNull Provider<QueryComponent.Factory> provider, @NonNull GasCalculator gasCalculator, @NonNull InstantSource instantSource, @NonNull EntityIdFactory entityIdFactory) {
        this.provider = Objects.requireNonNull(provider);
        this.gasCalculator = Objects.requireNonNull(gasCalculator);
        this.instantSource = Objects.requireNonNull(instantSource);
        this.entityIdFactory = Objects.requireNonNull(entityIdFactory);
    }

    public QueryHeader extractHeader(@NonNull Query query) {
        Objects.requireNonNull(query);
        return query.contractCallLocalOrThrow().header();
    }

    public Response createEmptyResponse(@NonNull ResponseHeader header) {
        Objects.requireNonNull(header);
        ContractCallLocalResponse.Builder response = ContractCallLocalResponse.newBuilder().header(header);
        return Response.newBuilder().contractCallLocal(response).build();
    }

    public void validate(@NonNull QueryContext context) throws PreCheckException {
        Account contract;
        Objects.requireNonNull(context);
        Query query = context.query();
        ContractCallLocalQuery op = query.contractCallLocalOrThrow();
        long requestedGas = op.gas();
        PreCheckException.validateTruePreCheck((requestedGas >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.CONTRACT_NEGATIVE_GAS);
        long maxGasLimit = ValidationUtils.getMaxGasLimit((ContractsConfig)context.configuration().getConfigData(ContractsConfig.class));
        PreCheckException.validateTruePreCheck((requestedGas <= maxGasLimit ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.MAX_GAS_LIMIT_EXCEEDED);
        long intrinsicGas = this.gasCalculator.transactionIntrinsicGasCost(Bytes.wrap((byte[])op.functionParameters().toByteArray()), false, 0L);
        PreCheckException.validateTruePreCheck((op.gas() >= intrinsicGas ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_GAS);
        ContractID contractID = op.contractID();
        Validations.mustExist((Object)contractID, (ResponseCodeEnum)ResponseCodeEnum.INVALID_CONTRACT_ID);
        if (op.contractID().hasEvmAddress()) {
            PreCheckException.validateTruePreCheck((op.contractID().evmAddressOrThrow().length() == 20L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_CONTRACT_ID);
        }
        if ((contract = ((ReadableAccountStore)context.createStore(ReadableAccountStore.class)).getContractById(contractID)) == null) {
            byte[] evmAddress;
            Long tokenNum = contractID.contractNumOrElse(Long.valueOf(0L));
            if (contractID.hasEvmAddress() && ConversionUtils.isLongZeroAddress(evmAddress = contractID.evmAddressOrThrow().toByteArray())) {
                tokenNum = ConversionUtils.numberOfLongZero(evmAddress);
            }
            TokenID tokenID = this.entityIdFactory.newTokenId(tokenNum.longValue());
            Token tokenContract = ((ReadableTokenStore)context.createStore(ReadableTokenStore.class)).get(tokenID);
            Validations.mustExist((Object)tokenContract, (ResponseCodeEnum)ResponseCodeEnum.INVALID_CONTRACT_ID);
        }
    }

    public Response findResponse(@NonNull QueryContext context, @NonNull ResponseHeader header) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(header);
        QueryComponent component = this.getQueryComponent(context);
        CallOutcome outcome = component.contextQueryProcessor().call();
        ResponseHeader responseHeader = outcome.isSuccess() ? header : header.copyBuilder().nodeTransactionPrecheckCode(outcome.status()).build();
        ContractCallLocalResponse.Builder response = ContractCallLocalResponse.newBuilder();
        response.header(responseHeader);
        response.functionResult(outcome.result());
        return Response.newBuilder().contractCallLocal(response).build();
    }

    @NonNull
    public Fees computeFees(@NonNull QueryContext context) {
        Objects.requireNonNull(context);
        ContractCallLocalQuery op = context.query().contractCallLocalOrThrow();
        ContractsConfig contractsConfig = (ContractsConfig)context.configuration().getConfigData(ContractsConfig.class);
        return context.feeCalculator().legacyCalculate(sigValueObj -> {
            ContractFunctionResult contractFnResult = ContractFunctionResult.newBuilder().setContractID(CommonPbjConverters.fromPbj((ContractID)op.contractIDOrElse(ContractID.DEFAULT))).setContractCallResult(CommonPbjConverters.fromPbj((com.hedera.pbj.runtime.io.buffer.Bytes)com.hedera.pbj.runtime.io.buffer.Bytes.wrap((byte[])new byte[contractsConfig.localCallEstRetBytes()]))).build();
            SmartContractFeeBuilder builder = new SmartContractFeeBuilder();
            FeeData feeData = builder.getContractCallLocalFeeMatrices((int)op.functionParameters().length(), contractFnResult, CommonPbjConverters.fromPbjResponseType((ResponseType)op.headerOrElse(QueryHeader.DEFAULT).responseType()));
            return feeData.toBuilder().setNodedata(feeData.getNodedata().toBuilder().setGas(op.gas())).build();
        });
    }

    @NonNull
    private QueryComponent getQueryComponent(@NonNull QueryContext context) {
        return Objects.requireNonNull(((QueryComponent.Factory)this.provider.get()).create(context, this.instantSource.instant(), HederaFunctionality.CONTRACT_CALL_LOCAL));
    }
}

