/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.gascalculator;

import java.util.function.Supplier;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.evm.gascalculator.ConstantinopleGasCalculator;

public class PetersburgGasCalculator
extends ConstantinopleGasCalculator {
    private static final long STORAGE_SET_GAS_COST = 20000L;
    private static final long STORAGE_RESET_GAS_COST = 5000L;
    private static final long STORAGE_RESET_REFUND_AMOUNT = 15000L;

    @Override
    public long calculateStorageCost(UInt256 newValue, Supplier<UInt256> currentValue, Supplier<UInt256> originalValue) {
        return !newValue.isZero() && currentValue.get().isZero() ? 20000L : 5000L;
    }

    @Override
    public long calculateStorageRefundAmount(UInt256 newValue, Supplier<UInt256> currentValue, Supplier<UInt256> originalValue) {
        return newValue.isZero() && !currentValue.get().isZero() ? 15000L : 0L;
    }
}

