/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.rlp;

import com.esaulpaugh.headlong.rlp.KVP;
import com.esaulpaugh.headlong.rlp.RLPDecoder;
import com.esaulpaugh.headlong.rlp.RLPEncoder;
import com.esaulpaugh.headlong.rlp.RLPItem;
import com.esaulpaugh.headlong.rlp.RLPList;
import com.esaulpaugh.headlong.rlp.RLPString;
import com.esaulpaugh.headlong.util.Integers;
import com.esaulpaugh.headlong.util.Strings;
import java.nio.ByteBuffer;
import java.security.InvalidParameterException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public final class Record
implements Iterable<KVP>,
Comparable<Record> {
    private static final int MAX_RECORD_LEN = 300;
    private static final String ENR_PREFIX = "enr:";
    private final long seq;
    private final RLPList rlp;

    public static ByteBuffer encode(Signer signer, long seq, KVP ... pairs) {
        return Record.encode(signer, seq, Arrays.asList(pairs));
    }

    public static ByteBuffer encode(Signer signer, long seq, List<KVP> pairs) {
        int signatureLen = signer.signatureLength();
        if (signatureLen <= 1) {
            throw new InvalidParameterException("signer specifies bad signature length: " + signatureLen);
        }
        if (seq < 0L) {
            throw new IllegalArgumentException("negative seq");
        }
        Collections.sort(pairs);
        byte[] seqBytes = Integers.toBytes(seq);
        int payloadLen = RLPEncoder.payloadLen(seqBytes, pairs);
        int recordDataLen = RLPEncoder.itemLen(signatureLen) + payloadLen;
        ByteBuffer recordBuf = ByteBuffer.allocate(Record.checkRecordLen(RLPEncoder.itemLen(recordDataLen)));
        byte[] content = RLPEncoder.encodeRecordContent(seqBytes, pairs, payloadLen);
        byte[] record = recordBuf.array();
        System.arraycopy(content, content.length - payloadLen, record, record.length - payloadLen, payloadLen);
        byte[] signature = signer.sign(content);
        if (signature.length != signatureLen) {
            throw new InvalidParameterException("unexpected signature length: " + signature.length + " != " + signatureLen);
        }
        RLPEncoder.insertListPrefix(recordDataLen, recordBuf);
        RLPEncoder.putString(signature, recordBuf);
        recordBuf.rewind();
        return recordBuf;
    }

    public Record(Signer signer, long seq, KVP ... pairs) {
        this(signer, seq, Arrays.asList(pairs));
    }

    public Record(Signer signer, long seq, List<KVP> pairs) {
        this(seq, RLPDecoder.RLP_STRICT.wrapList(Record.encode(signer, seq, pairs).array()));
    }

    private Record(long seq, RLPList recordRLP) {
        this.seq = seq;
        this.rlp = recordRLP;
    }

    private static int checkRecordLen(int recordLen) {
        if (recordLen > 300) {
            throw new IllegalArgumentException("record length exceeds maximum: " + recordLen + " > " + 300);
        }
        return recordLen;
    }

    public Record with(Signer signer, long seq, KVP ... newPairs) {
        HashSet<KVP> pairSet = new HashSet<KVP>();
        for (KVP pair : newPairs) {
            if (pairSet.add(pair)) continue;
            throw KVP.duplicateKeyErr(pair.key);
        }
        for (KVP pair : this) {
            pairSet.add(pair);
        }
        return new Record(signer, seq, pairSet.toArray(KVP.EMPTY_ARRAY));
    }

    public static Record parse(String enrString, Verifier verifier) throws SignatureException {
        if (enrString.startsWith(ENR_PREFIX)) {
            return Record.decode(Strings.decode(enrString.substring(ENR_PREFIX.length()), 2), verifier);
        }
        throw new IllegalArgumentException("prefix \"enr:\" not found");
    }

    public static Record decode(byte[] bytes, Verifier verifier) throws SignatureException {
        Record.checkRecordLen(bytes.length);
        RLPList rlpList = RLPDecoder.RLP_STRICT.wrapList(Arrays.copyOf(bytes, bytes.length));
        if (rlpList.encodingLength() != bytes.length) {
            throw new IllegalArgumentException("unconsumed trailing bytes");
        }
        Iterator<RLPItem> rlpIter = rlpList.iterator();
        if (verifier != null) {
            RLPString signatureItem = rlpIter.next().asRLPString();
            verifier.verify(signatureItem.asBytes(), Record.content(rlpList, signatureItem.endIndex));
        } else {
            rlpIter.next();
        }
        long seq = rlpIter.next().asRLPString().asLong();
        RLPString prevKey = null;
        while (rlpIter.hasNext()) {
            RLPString key = rlpIter.next().asRLPString();
            rlpIter.next();
            if (prevKey != null && key.compareTo(prevKey) <= 0) {
                throw key.compareTo(prevKey) == 0 ? KVP.duplicateKeyErr(key) : new IllegalArgumentException("key out of order");
            }
            prevKey = key;
        }
        return new Record(seq, rlpList);
    }

    public RLPList getRLP() {
        return this.rlp;
    }

    public RLPString getSignature() {
        return this.rlp.iterator(RLPDecoder.RLP_STRICT).next().asRLPString();
    }

    public RLPList getContent() {
        return RLPDecoder.RLP_STRICT.wrapList(Record.content(this.rlp, this.getSignature().endIndex));
    }

    public long getSeq() {
        return this.seq;
    }

    public List<KVP> getPairs() {
        ArrayList<KVP> list = new ArrayList<KVP>();
        for (KVP pair : this) {
            list.add(pair);
        }
        return list;
    }

    public LinkedHashMap<String, RLPItem> orderedMap() {
        LinkedHashMap<String, RLPItem> map = new LinkedHashMap<String, RLPItem>();
        for (KVP pair : this) {
            map.put(pair.key.asString(1), pair.value());
        }
        return map;
    }

    @Override
    public Iterator<KVP> iterator() {
        final Iterator<RLPItem> rlpIter = this.rlp.iterator();
        rlpIter.next();
        rlpIter.next();
        return new Iterator<KVP>(){

            @Override
            public boolean hasNext() {
                return rlpIter.hasNext();
            }

            @Override
            public KVP next() {
                return new KVP(((RLPItem)rlpIter.next()).asRLPString(), (RLPItem)rlpIter.next());
            }
        };
    }

    @Override
    public int compareTo(Record o) {
        return Long.compare(this.seq, o.seq);
    }

    public int hashCode() {
        return this.rlp.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof Record && ((Record)o).rlp.equals(this.rlp);
    }

    public String toString() {
        return ENR_PREFIX + this.rlp.encodingString(2);
    }

    private static byte[] content(RLPList rlpList, int index) {
        int contentDataLen = rlpList.encodingLength() - index;
        ByteBuffer bb = ByteBuffer.allocate(RLPEncoder.itemLen(contentDataLen));
        RLPEncoder.insertListPrefix(contentDataLen, bb);
        byte[] arr = bb.array();
        System.arraycopy(rlpList.buffer, index, arr, bb.position(), contentDataLen);
        return arr;
    }

    @FunctionalInterface
    public static interface Verifier {
        public void verify(byte[] var1, byte[] var2) throws SignatureException;
    }

    public static interface Signer {
        public int signatureLength();

        public byte[] sign(byte[] var1);
    }
}

