/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeName;
import io.helidon.service.registry.Activator;
import io.helidon.service.registry.CoreServiceRegistry;
import io.helidon.service.registry.Lookup;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.Scope;
import io.helidon.service.registry.Service;
import io.helidon.service.registry.ServiceDescriptor;
import io.helidon.service.registry.ServiceInfo;
import io.helidon.service.registry.ServiceInstance;
import io.helidon.service.registry.ServiceProvider;
import java.util.Set;
import java.util.function.Supplier;

class ServiceManager<T> {
    private final ServiceProvider<T> provider;
    private final boolean explicitInstance;
    private final Supplier<Activator<T>> activatorSupplier;
    private final CoreServiceRegistry registry;
    private final Supplier<Scope> scopeSupplier;

    ServiceManager(CoreServiceRegistry registry, Supplier<Scope> scopeSupplier, ServiceProvider<T> provider, boolean explicitInstance, Supplier<Activator<T>> activatorSupplier) {
        this.registry = registry;
        this.scopeSupplier = scopeSupplier;
        this.provider = provider;
        this.explicitInstance = explicitInstance;
        this.activatorSupplier = activatorSupplier;
    }

    public String toString() {
        return this.provider.descriptor().serviceType().classNameWithEnclosingNames();
    }

    void ensureBindingPlan() {
        if (this.explicitInstance) {
            return;
        }
        this.registry.bindings().bindingPlan(this.provider.descriptor()).ensure();
    }

    ServiceInstance<T> registryInstance(Lookup lookup, Service.QualifiedInstance<T> instance) {
        return new ServiceInstanceImpl<T>(this.provider.descriptor(), this.provider.contracts(lookup), instance);
    }

    ServiceInfo descriptor() {
        return this.provider.descriptor();
    }

    Activator<T> activator() {
        return this.scopeSupplier.get().registry().activator(this.provider.descriptor(), this.activatorSupplier);
    }

    private static final class ServiceInstanceImpl<T>
    implements ServiceInstance<T> {
        private final ServiceDescriptor<T> descriptor;
        private final Service.QualifiedInstance<T> qualifiedInstance;
        private final Set<ResolvedType> contracts;

        private ServiceInstanceImpl(ServiceDescriptor<T> descriptor, Set<ResolvedType> contracts, Service.QualifiedInstance<T> qualifiedInstance) {
            this.descriptor = descriptor;
            this.contracts = contracts;
            this.qualifiedInstance = qualifiedInstance;
        }

        @Override
        public T get() {
            return this.qualifiedInstance.get();
        }

        @Override
        public Set<Qualifier> qualifiers() {
            return this.qualifiedInstance.qualifiers();
        }

        @Override
        public Set<ResolvedType> contracts() {
            return this.contracts;
        }

        @Override
        public TypeName scope() {
            return this.descriptor.scope();
        }

        @Override
        public double weight() {
            return this.descriptor.weight();
        }

        @Override
        public TypeName serviceType() {
            return this.descriptor.serviceType();
        }

        public String toString() {
            return "Instance of " + this.descriptor.serviceType().fqName() + ": " + String.valueOf(this.qualifiedInstance);
        }
    }
}

