/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.keys;

import com.hedera.node.app.hapi.utils.keys.KeyUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.util.Objects;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.EdDSASecurityProvider;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;

public final class Ed25519Utils {
    private static final EdDSANamedCurveSpec ED25519_PARAMS = EdDSANamedCurveTable.getByName((String)"Ed25519");
    private static final int ED25519_BYTE_LENGTH = 32;
    public static final Provider ED_PROVIDER = new EdDSASecurityProvider();

    static boolean isValidEd25519Key(@NonNull Bytes key) {
        return key.length() == 32L;
    }

    public static EdDSAPrivateKey readKeyFrom(File pem, String passphrase) {
        return (EdDSAPrivateKey)KeyUtils.readKeyFrom(pem, passphrase, ED_PROVIDER);
    }

    public static KeyPair readKeyPairFrom(File pem, String passphrase) {
        return Ed25519Utils.keyPairFrom(Ed25519Utils.readKeyFrom(pem, passphrase));
    }

    public static EdDSAPrivateKey readKeyFrom(String pemLoc, String passphrase) {
        return (EdDSAPrivateKey)KeyUtils.readKeyFrom(new File(pemLoc), passphrase, ED_PROVIDER);
    }

    public static EdDSAPrivateKey readKeyFrom(@NonNull InputStream in, @NonNull String passphrase) {
        Objects.requireNonNull(in);
        Objects.requireNonNull(passphrase);
        return (EdDSAPrivateKey)KeyUtils.readKeyFrom(in, passphrase, ED_PROVIDER);
    }

    public static byte[] extractEd25519PublicKey(@NonNull EdDSAPrivateKey key) {
        return key.getAbyte();
    }

    public static void writeKeyTo(byte[] seed, String pemLoc, String passphrase) {
        KeyUtils.writeKeyTo((PrivateKey)Ed25519Utils.keyFrom(seed), pemLoc, passphrase);
    }

    public static EdDSAPrivateKey keyFrom(byte[] seed) {
        return new EdDSAPrivateKey(new EdDSAPrivateKeySpec(seed, (EdDSAParameterSpec)ED25519_PARAMS));
    }

    public static KeyPair keyPairFrom(EdDSAPrivateKey privateKey) {
        EdDSAPublicKey publicKey = new EdDSAPublicKey(new EdDSAPublicKeySpec(privateKey.getAbyte(), (EdDSAParameterSpec)ED25519_PARAMS));
        return new KeyPair((PublicKey)publicKey, (PrivateKey)privateKey);
    }

    private Ed25519Utils() {
        throw new UnsupportedOperationException("Utility Class");
    }
}

